/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingGraphFactory;
import dagger.internal.codegen.binding.ComponentDescriptorFactory;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.BindingGraphValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class ModuleValidator {
    private static final ImmutableSet<ClassName> SUBCOMPONENT_TYPES;
    private static final ImmutableSet<ClassName> SUBCOMPONENT_CREATOR_TYPES;
    private static final Optional<Class<?>> ANDROID_PROCESSOR;
    private static final ClassName CONTRIBUTES_ANDROID_INJECTOR_NAME;
    private static final String ANDROID_PROCESSOR_NAME = "dagger.android.processor.AndroidProcessor";
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final BindingGraphValidator bindingGraphValidator;
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerSuperficialValidation superficialValidation;
    private final XProcessingEnv processingEnv;
    private final Map<XTypeElement, ValidationReport> cache = new HashMap<XTypeElement, ValidationReport>();
    private final Set<XTypeElement> knownModules = new HashSet<XTypeElement>();

    @Inject
    ModuleValidator(AnyBindingMethodValidator anyBindingMethodValidator, MethodSignatureFormatter methodSignatureFormatter, ComponentDescriptorFactory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, BindingGraphValidator bindingGraphValidator, InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation, XProcessingEnv processingEnv) {
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.bindingGraphValidator = bindingGraphValidator;
        this.injectionAnnotations = injectionAnnotations;
        this.superficialValidation = superficialValidation;
        this.processingEnv = processingEnv;
    }

    public void addKnownModules(Collection<XTypeElement> modules) {
        this.knownModules.addAll(modules);
    }

    public ValidationReport validate(XTypeElement module) {
        return this.validate(module, new HashSet<XTypeElement>());
    }

    private ValidationReport validate(XTypeElement module, Set<XTypeElement> visitedModules) {
        if (visitedModules.add(module)) {
            return Util.reentrantComputeIfAbsent(this.cache, module, m -> this.validateUncached(module, visitedModules));
        }
        return ValidationReport.about((XElement)module).build();
    }

    private ValidationReport validateUncached(XTypeElement module, Set<XTypeElement> visitedModules) {
        ValidationReport.Builder builder = ValidationReport.about((XElement)module);
        ModuleKind moduleKind = ModuleKind.forAnnotatedElement(module).get();
        List moduleMethods = module.getDeclaredMethods();
        ArrayList<XMethodElement> bindingMethods = new ArrayList<XMethodElement>();
        for (XMethodElement moduleMethod : moduleMethods) {
            if (!this.anyBindingMethodValidator.isBindingMethod((XExecutableElement)moduleMethod)) continue;
            builder.addSubreport(this.anyBindingMethodValidator.validate(moduleMethod));
            bindingMethods.add(moduleMethod);
        }
        this.validateKotlinObjectDoesNotInheritInstanceBindingMethods(module, moduleKind, builder);
        this.validateDaggerAndroidProcessorRequirements(module, builder);
        if (((ImmutableSet)bindingMethods.stream().map(ModuleMethodKind::ofMethod).collect(DaggerStreams.toImmutableSet())).containsAll(EnumSet.of(ModuleMethodKind.ABSTRACT_DECLARATION, ModuleMethodKind.INSTANCE_BINDING))) {
            builder.addError(String.format("A @%s may not contain both non-static and abstract binding methods", moduleKind.annotation().simpleName()));
        }
        this.validateModuleVisibility(module, moduleKind, builder);
        ImmutableListMultimap bindingMethodsByName = Multimaps.index(bindingMethods, XElements::getSimpleName);
        this.validateMethodsWithSameName(builder, (ListMultimap<String, XMethodElement>)bindingMethodsByName);
        if (!module.isInterface()) {
            this.validateBindingMethodOverrides(module, builder, (ImmutableListMultimap<String, XMethodElement>)Multimaps.index((Iterable)moduleMethods, XElements::getSimpleName), (ImmutableListMultimap<String, XMethodElement>)bindingMethodsByName);
        }
        this.validateModifiers(module, builder);
        this.validateReferencedModules(module, moduleKind, visitedModules, builder);
        this.validateReferencedSubcomponents(module, moduleKind, builder);
        this.validateNoScopeAnnotationsOnModuleElement(module, moduleKind, builder);
        this.validateSelfCycles(module, moduleKind, builder);
        ((Optional)module.getEnclosedTypeElements().stream().filter(XTypeElement::isCompanionObject).collect(DaggerCollectors.toOptional())).ifPresent(companionModule -> this.validateCompanionModule((XTypeElement)companionModule, builder));
        if (builder.build().isClean() && this.bindingGraphValidator.shouldDoFullBindingGraphValidation(module)) {
            this.validateModuleBindings(module, builder);
        }
        return builder.build();
    }

    private void validateDaggerAndroidProcessorRequirements(XTypeElement module, ValidationReport.Builder builder) {
        if (ANDROID_PROCESSOR.isPresent() || this.processingEnv.findTypeElement((TypeName)CONTRIBUTES_ANDROID_INJECTOR_NAME) == null) {
            return;
        }
        module.getDeclaredMethods().stream().filter(method -> method.hasAnnotation(CONTRIBUTES_ANDROID_INJECTOR_NAME)).forEach(method -> builder.addSubreport(ValidationReport.about((XElement)method).addError(String.format("@%s was used, but %s was not found on the processor path", CONTRIBUTES_ANDROID_INJECTOR_NAME.simpleName(), ANDROID_PROCESSOR_NAME)).build()));
    }

    private void validateKotlinObjectDoesNotInheritInstanceBindingMethods(XTypeElement module, ModuleKind moduleKind, ValidationReport.Builder builder) {
        if (!module.isKotlinObject()) {
            return;
        }
        XTypeElement currentClass = module;
        while (!currentClass.getSuperType().getTypeName().equals((Object)TypeName.OBJECT)) {
            currentClass = currentClass.getSuperType().getTypeElement();
            currentClass.getDeclaredMethods().stream().filter(this.anyBindingMethodValidator::isBindingMethod).filter(method -> ModuleMethodKind.ofMethod(method) == ModuleMethodKind.INSTANCE_BINDING).forEach(method -> builder.addError(String.format("@%s-annotated Kotlin object cannot inherit instance (i.e. non-abstract, non-JVM static) binding method: %s", moduleKind.annotation().simpleName(), this.methodSignatureFormatter.format((XExecutableElement)method))));
        }
    }

    private void validateReferencedSubcomponents(XTypeElement subject, ModuleKind moduleKind, ValidationReport.Builder builder) {
        XAnnotation moduleAnnotation = moduleKind.getModuleAnnotation(subject);
        for (XAnnotationValue subcomponentValue : moduleAnnotation.getAsAnnotationValueList("subcomponents")) {
            XType type = subcomponentValue.asType();
            if (!XTypes.isDeclared(type)) {
                builder.addError(type + " is not a valid subcomponent type", (XElement)subject, moduleAnnotation, subcomponentValue);
                continue;
            }
            XTypeElement subcomponentElement = type.getTypeElement();
            if (XElements.hasAnyAnnotation((XAnnotated)subcomponentElement, SUBCOMPONENT_TYPES)) {
                this.validateSubcomponentHasBuilder(subject, subcomponentElement, moduleAnnotation, builder);
                continue;
            }
            builder.addError(XElements.hasAnyAnnotation((XAnnotated)subcomponentElement, SUBCOMPONENT_CREATOR_TYPES) ? this.moduleSubcomponentsIncludesCreator(subcomponentElement) : ModuleValidator.moduleSubcomponentsIncludesNonSubcomponent(subcomponentElement), (XElement)subject, moduleAnnotation, subcomponentValue);
        }
    }

    private static String moduleSubcomponentsIncludesNonSubcomponent(XTypeElement notSubcomponent) {
        return notSubcomponent.getQualifiedName() + " is not a @Subcomponent or @ProductionSubcomponent";
    }

    private String moduleSubcomponentsIncludesCreator(XTypeElement moduleSubcomponentsAttribute) {
        XTypeElement subcomponentType = moduleSubcomponentsAttribute.getEnclosingTypeElement();
        ComponentCreatorAnnotation creatorAnnotation = (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(ComponentCreatorAnnotation.getCreatorAnnotations(moduleSubcomponentsAttribute)));
        return String.format("%s is a @%s.%s. Did you mean to use %s?", moduleSubcomponentsAttribute.getQualifiedName(), ComponentAnnotation.subcomponentAnnotation(subcomponentType, this.superficialValidation).get().simpleName(), creatorAnnotation.creatorKind().typeName(), subcomponentType.getQualifiedName());
    }

    private void validateSubcomponentHasBuilder(XTypeElement subject, XTypeElement subcomponentAttribute, XAnnotation moduleAnnotation, ValidationReport.Builder builder) {
        if (ConfigurationAnnotations.getSubcomponentCreator(subcomponentAttribute).isPresent()) {
            return;
        }
        builder.addError(this.moduleSubcomponentsDoesntHaveCreator(subcomponentAttribute, moduleAnnotation), (XElement)subject, moduleAnnotation);
    }

    private String moduleSubcomponentsDoesntHaveCreator(XTypeElement subcomponent, XAnnotation moduleAnnotation) {
        return String.format("%1$s doesn't have a @%2$s.Builder or @%2$s.Factory, which is required when used with @%3$s.subcomponents", subcomponent.getQualifiedName(), ComponentAnnotation.subcomponentAnnotation(subcomponent, this.superficialValidation).get().simpleName(), XAnnotations.getClassName(moduleAnnotation).simpleName());
    }

    private void validateModifiers(XTypeElement subject, ValidationReport.Builder builder) {
        if (XTypeElements.hasTypeParameters(subject) && !subject.isAbstract()) {
            builder.addError("Modules with type parameters must be abstract", (XElement)subject);
        }
    }

    private void validateMethodsWithSameName(ValidationReport.Builder builder, ListMultimap<String, XMethodElement> bindingMethodsByName) {
        bindingMethodsByName.asMap().values().stream().filter(methods -> methods.size() > 1).flatMap(Collection::stream).forEach(duplicateMethod -> builder.addError("Cannot have more than one binding method with the same name in a single module", (XElement)duplicateMethod));
    }

    private void validateReferencedModules(XTypeElement subject, ModuleKind moduleKind, Set<XTypeElement> visitedModules, ValidationReport.Builder builder) {
        XAnnotation mirror = moduleKind.getModuleAnnotation(subject);
        builder.addSubreport(this.validateReferencedModules(subject, mirror, moduleKind.legalIncludedModuleKinds(), visitedModules));
    }

    ValidationReport validateReferencedModules(XTypeElement annotatedType, XAnnotation annotation, ImmutableSet<ModuleKind> validModuleKinds, Set<XTypeElement> visitedModules) {
        this.superficialValidation.validateAnnotationOf((XElement)annotatedType, annotation);
        ValidationReport.Builder subreport = ValidationReport.about((XElement)annotatedType);
        for (XAnnotationValue includedModule : ModuleValidator.getModules(annotation)) {
            ImmutableSet validModuleAnnotations;
            XType type = includedModule.asType();
            if (!XTypes.isDeclared(type)) {
                subreport.addError(String.format("%s is not a valid module type.", type), (XElement)annotatedType, annotation, includedModule);
                continue;
            }
            XTypeElement module = type.getTypeElement();
            if (XTypeElements.hasTypeParameters(module)) {
                subreport.addError(String.format("%s is listed as a module, but has type parameters", module.getQualifiedName()), (XElement)annotatedType, annotation, includedModule);
            }
            if (!XElements.hasAnyAnnotation((XAnnotated)module, (Collection<ClassName>)(validModuleAnnotations = (ImmutableSet)validModuleKinds.stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet())))) {
                subreport.addError(String.format("%s is listed as a module, but is not annotated with %s", module.getQualifiedName(), (validModuleAnnotations.size() > 1 ? "one of " : "") + validModuleAnnotations.stream().map(otherClass -> "@" + otherClass.simpleName()).collect(Collectors.joining(", "))), (XElement)annotatedType, annotation, includedModule);
            } else if (this.knownModules.contains(module) && !this.validate(module, visitedModules).isClean()) {
                subreport.addError(String.format("%s has errors", module.getQualifiedName()), (XElement)annotatedType, annotation, includedModule);
            }
            if (!module.isCompanionObject()) continue;
            subreport.addError(String.format("%s is listed as a module, but it is a companion object class. Add @Module to the enclosing class and reference that instead.", module.getQualifiedName()), (XElement)annotatedType, annotation, includedModule);
        }
        return subreport.build();
    }

    private static ImmutableList<XAnnotationValue> getModules(XAnnotation annotation) {
        if (ModuleAnnotation.isModuleAnnotation(annotation)) {
            return ImmutableList.copyOf((Collection)annotation.getAsAnnotationValueList("includes"));
        }
        if (ComponentAnnotation.isComponentAnnotation(annotation)) {
            return ImmutableList.copyOf((Collection)annotation.getAsAnnotationValueList("modules"));
        }
        throw new IllegalArgumentException(String.format("unsupported annotation: %s", annotation));
    }

    private void validateBindingMethodOverrides(XTypeElement subject, ValidationReport.Builder builder, ImmutableListMultimap<String, XMethodElement> moduleMethodsByName, ImmutableListMultimap<String, XMethodElement> bindingMethodsByName) {
        XTypeElement currentClass = subject;
        HashSet visitedMethods = Sets.newHashSet();
        ListMultimap allMethodsByName = MultimapBuilder.hashKeys().arrayListValues().build(moduleMethodsByName);
        while (!currentClass.getSuperType().getTypeName().equals((Object)TypeName.OBJECT)) {
            currentClass = currentClass.getSuperType().getTypeElement();
            List superclassMethods = currentClass.getDeclaredMethods();
            for (XMethodElement superclassMethod : superclassMethods) {
                String name = XElements.getSimpleName((XElement)superclassMethod);
                for (XMethodElement bindingMethod : bindingMethodsByName.get((Object)name)) {
                    if (!visitedMethods.add(bindingMethod) || !bindingMethod.overrides(superclassMethod, subject)) continue;
                    builder.addError(String.format("Binding methods may not override another method. Overrides: %s", this.methodSignatureFormatter.format((XExecutableElement)superclassMethod)), (XElement)bindingMethod);
                }
                if (this.anyBindingMethodValidator.isBindingMethod((XExecutableElement)superclassMethod)) {
                    for (XMethodElement method : allMethodsByName.get((Object)name)) {
                        if (!visitedMethods.add(method) || !method.overrides(superclassMethod, subject)) continue;
                        builder.addError(String.format("Binding methods may not be overridden in modules. Overrides: %s", this.methodSignatureFormatter.format((XExecutableElement)superclassMethod)), (XElement)method);
                    }
                }
                allMethodsByName.put((Object)XElements.getSimpleName((XElement)superclassMethod), (Object)superclassMethod);
            }
        }
    }

    private void validateModuleVisibility(XTypeElement moduleElement, ModuleKind moduleKind, ValidationReport.Builder reportBuilder) {
        ImmutableSet<XTypeElement> invalidVisibilityIncludes;
        if (moduleElement.isPrivate() || moduleElement.isKtPrivate()) {
            reportBuilder.addError("Modules cannot be private.", (XElement)moduleElement);
        } else if (XTypeElements.isEffectivelyPrivate(moduleElement)) {
            reportBuilder.addError("Modules cannot be enclosed in private types.", (XElement)moduleElement);
        }
        if (XTypeElements.isEffectivelyPublic(moduleElement) && !(invalidVisibilityIncludes = this.getModuleIncludesWithInvalidVisibility(moduleKind.getModuleAnnotation(moduleElement))).isEmpty()) {
            reportBuilder.addError(String.format("This module is public, but it includes non-public (or effectively non-public) modules (%s) that have non-static, non-abstract binding methods. Either reduce the visibility of this module, make the included modules public, or make all of the binding methods on the included modules abstract or static.", ModuleValidator.formatListForErrorMessage((List)invalidVisibilityIncludes.stream().map(XTypeElement::getClassName).map(ClassName::canonicalName).collect(DaggerStreams.toImmutableList()))), (XElement)moduleElement);
        }
    }

    private ImmutableSet<XTypeElement> getModuleIncludesWithInvalidVisibility(XAnnotation moduleAnnotation) {
        return (ImmutableSet)moduleAnnotation.getAnnotationValue("includes").asTypeList().stream().map(XType::getTypeElement).filter(include -> !XTypeElements.isEffectivelyPublic(include)).filter(this::requiresModuleInstance).collect(DaggerStreams.toImmutableSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresModuleInstance(XTypeElement module) {
        if (module.isKotlinObject()) return false;
        if (module.isCompanionObject()) return false;
        if (XTypeElements.getAllMethods(module).stream().filter(this.anyBindingMethodValidator::isBindingMethod).allMatch(method -> method.isAbstract() || method.isStatic())) return false;
        return true;
    }

    private void validateNoScopeAnnotationsOnModuleElement(XTypeElement module, ModuleKind moduleKind, ValidationReport.Builder report) {
        for (Scope scope : this.injectionAnnotations.getScopes((XElement)module)) {
            report.addError(String.format("@%ss cannot be scoped. Did you mean to scope a method instead?", moduleKind.annotation().simpleName()), (XElement)module, scope.scopeAnnotation().xprocessing());
        }
    }

    private void validateSelfCycles(XTypeElement module, ModuleKind moduleKind, ValidationReport.Builder builder) {
        XAnnotation moduleAnnotation = moduleKind.getModuleAnnotation(module);
        moduleAnnotation.getAsAnnotationValueList("includes").stream().filter(includedModule -> XTypes.areEquivalentTypes(module.getType(), includedModule.asType())).forEach(includedModule -> builder.addError(String.format("@%s cannot include themselves.", moduleKind.annotation().simpleName()), (XElement)module, moduleAnnotation, (XAnnotationValue)includedModule));
    }

    private void validateCompanionModule(XTypeElement companionModule, ValidationReport.Builder builder) {
        ArrayList<XMethodElement> companionBindingMethods = new ArrayList<XMethodElement>();
        for (XMethodElement companionMethod : companionModule.getDeclaredMethods()) {
            if (this.anyBindingMethodValidator.isBindingMethod((XExecutableElement)companionMethod)) {
                builder.addSubreport(this.anyBindingMethodValidator.validate(companionMethod));
                companionBindingMethods.add(companionMethod);
            }
            if (!companionMethod.hasAnnotation(TypeNames.OVERRIDE)) continue;
            builder.addError("Binding method in companion object may not override another method.", (XElement)companionMethod);
        }
        ImmutableListMultimap bindingMethodsByName = Multimaps.index(companionBindingMethods, XElements::getSimpleName);
        this.validateMethodsWithSameName(builder, (ListMultimap<String, XMethodElement>)bindingMethodsByName);
        if (!companionBindingMethods.isEmpty() && companionModule.isPrivate()) {
            builder.addError("A Companion Module with binding methods cannot be private.", (XElement)companionModule);
        }
    }

    private void validateModuleBindings(XTypeElement module, ValidationReport.Builder report) {
        BindingGraph.TopLevelBindingGraph bindingGraph = this.bindingGraphFactory.create(this.componentDescriptorFactory.moduleComponentDescriptor(module), true).topLevelBindingGraph();
        if (!this.bindingGraphValidator.isValid(bindingGraph)) {
            report.markDirty();
        }
    }

    private static String formatListForErrorMessage(List<?> things) {
        switch (things.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return things.get(0).toString();
            }
        }
        StringBuilder output = new StringBuilder();
        Joiner.on((String)", ").appendTo(output, things.subList(0, things.size() - 1));
        output.append(" and ").append(things.get(things.size() - 1));
        return output.toString();
    }

    static {
        Class<?> clazz;
        SUBCOMPONENT_TYPES = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT);
        SUBCOMPONENT_CREATOR_TYPES = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT_BUILDER, (Object)TypeNames.SUBCOMPONENT_FACTORY, (Object)TypeNames.PRODUCTION_SUBCOMPONENT_BUILDER, (Object)TypeNames.PRODUCTION_SUBCOMPONENT_FACTORY);
        CONTRIBUTES_ANDROID_INJECTOR_NAME = ClassName.get((String)"dagger.android", (String)"ContributesAndroidInjector", (String[])new String[0]);
        try {
            clazz = Class.forName(ANDROID_PROCESSOR_NAME, false, ModuleValidator.class.getClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            clazz = null;
        }
        ANDROID_PROCESSOR = Optional.ofNullable(clazz);
    }

    static enum ModuleMethodKind {
        ABSTRACT_DECLARATION,
        INSTANCE_BINDING,
        STATIC_BINDING;


        static ModuleMethodKind ofMethod(XMethodElement moduleMethod) {
            if (moduleMethod.isStatic()) {
                return STATIC_BINDING;
            }
            if (moduleMethod.isAbstract()) {
                return ABSTRACT_DECLARATION;
            }
            return INSTANCE_BINDING;
        }
    }
}

