/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConversionException;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConverter;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import java.util.Map;
import org.springframework.util.Assert;

public class JacksonPubSubMessageConverter
implements PubSubMessageConverter {
    private final ObjectMapper objectMapper;

    public JacksonPubSubMessageConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"A valid ObjectMapper is required.");
        this.objectMapper = objectMapper;
    }

    @Override
    public PubsubMessage toPubSubMessage(Object payload, Map<String, String> headers) {
        try {
            return this.byteStringToPubSubMessage(ByteString.copyFrom((byte[])this.objectMapper.writeValueAsBytes(payload)), headers);
        }
        catch (JsonProcessingException ex) {
            throw new PubSubMessageConversionException("JSON serialization of an object of type " + payload.getClass().getName() + " failed.", ex);
        }
    }

    @Override
    public <T> T fromPubSubMessage(PubsubMessage message, Class<T> payloadType) {
        try {
            return (T)this.objectMapper.readerFor(payloadType).readValue(message.getData().toByteArray());
        }
        catch (IOException ex) {
            throw new PubSubMessageConversionException("JSON deserialization of an object of type " + payloadType.getName() + " failed.", ex);
        }
    }
}

