/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.api.LlmUtilityServiceClient;
import com.google.cloud.vertexai.api.LlmUtilityServiceSettings;
import com.google.cloud.vertexai.api.PredictionServiceClient;
import com.google.cloud.vertexai.api.PredictionServiceSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VertexAI
implements AutoCloseable {
    private final String projectId;
    private final String location;
    private final String apiEndpoint;
    private final Transport transport;
    private final CredentialsProvider credentialsProvider;
    private PredictionServiceClient predictionServiceClient = null;
    private LlmUtilityServiceClient llmUtilityClient = null;
    private final ReentrantLock lock = new ReentrantLock();

    public VertexAI(String projectId, String location) {
        this.projectId = projectId;
        this.location = location;
        this.apiEndpoint = String.format("%s-aiplatform.googleapis.com", this.location);
        this.transport = Transport.GRPC;
        this.credentialsProvider = null;
    }

    private VertexAI(String projectId, String location, String apiEndpoint, Transport transport, Credentials credentials, List<String> scopes) {
        if (!scopes.isEmpty() && credentials != null) {
            throw new IllegalArgumentException("At most one of Credentials and scopes should be specified.");
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"projectId can't be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0, (Object)"location can't be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)apiEndpoint) ? 1 : 0) != 0, (Object)"apiEndpoint can't be null or empty");
        Preconditions.checkNotNull((Object)((Object)transport), (Object)"transport can't be null");
        this.projectId = projectId;
        this.location = location;
        this.apiEndpoint = apiEndpoint;
        this.transport = transport;
        this.credentialsProvider = credentials != null ? FixedCredentialsProvider.create((Credentials)credentials) : (scopes.size() == 0 ? null : GoogleCredentialsProvider.newBuilder().setScopesToApply(scopes).setUseJwtAccessWithScope(true).build());
    }

    public Transport getTransport() {
        return this.transport;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public Credentials getCredentials() throws IOException {
        if (this.credentialsProvider == null) {
            throw new IllegalStateException("Either Credentials or scopes needs to be provided while instantiating VertexAI.");
        }
        return this.credentialsProvider.getCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi
    public PredictionServiceClient getPredictionServiceClient() throws IOException {
        if (this.predictionServiceClient != null) {
            return this.predictionServiceClient;
        }
        this.lock.lock();
        try {
            if (this.predictionServiceClient == null) {
                PredictionServiceSettings settings = this.getPredictionServiceSettings();
                Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
                Level previousLevel = defaultCredentialsProviderLogger.getLevel();
                defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
                this.predictionServiceClient = PredictionServiceClient.create(settings);
                defaultCredentialsProviderLogger.setLevel(previousLevel);
            }
            PredictionServiceClient predictionServiceClient = this.predictionServiceClient;
            return predictionServiceClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    private PredictionServiceSettings getPredictionServiceSettings() throws IOException {
        PredictionServiceSettings.Builder builder = this.transport == Transport.REST ? PredictionServiceSettings.newHttpJsonBuilder() : PredictionServiceSettings.newBuilder();
        builder.setEndpoint(String.format("%s:443", this.apiEndpoint));
        if (this.credentialsProvider != null) {
            builder.setCredentialsProvider(this.credentialsProvider);
        }
        FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(PredictionServiceSettings.class))});
        builder.setHeaderProvider((HeaderProvider)headerProvider);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi
    public LlmUtilityServiceClient getLlmUtilityClient() throws IOException {
        if (this.llmUtilityClient != null) {
            return this.llmUtilityClient;
        }
        this.lock.lock();
        try {
            if (this.llmUtilityClient == null) {
                LlmUtilityServiceSettings settings = this.getLlmUtilityServiceClientSettings();
                Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
                Level previousLevel = defaultCredentialsProviderLogger.getLevel();
                defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
                this.llmUtilityClient = LlmUtilityServiceClient.create(settings);
                defaultCredentialsProviderLogger.setLevel(previousLevel);
            }
            LlmUtilityServiceClient llmUtilityServiceClient = this.llmUtilityClient;
            return llmUtilityServiceClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    private LlmUtilityServiceSettings getLlmUtilityServiceClientSettings() throws IOException {
        LlmUtilityServiceSettings.Builder settingsBuilder = this.transport == Transport.REST ? LlmUtilityServiceSettings.newHttpJsonBuilder() : LlmUtilityServiceSettings.newBuilder();
        settingsBuilder.setEndpoint(String.format("%s:443", this.apiEndpoint));
        if (this.credentialsProvider != null) {
            settingsBuilder.setCredentialsProvider(this.credentialsProvider);
        }
        FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(LlmUtilityServiceSettings.class))});
        settingsBuilder.setHeaderProvider((HeaderProvider)headerProvider);
        return settingsBuilder.build();
    }

    @Override
    public void close() {
        if (this.predictionServiceClient != null) {
            this.predictionServiceClient.close();
        }
        if (this.llmUtilityClient != null) {
            this.llmUtilityClient.close();
        }
    }

    public static class Builder {
        private String projectId;
        private String location;
        private Credentials credentials;
        private String apiEndpoint;
        private Transport transport = Transport.GRPC;
        private ImmutableList<String> scopes = ImmutableList.of();

        public VertexAI build() {
            Preconditions.checkNotNull((Object)this.projectId, (Object)"projectId must be set.");
            Preconditions.checkNotNull((Object)this.location, (Object)"location must be set.");
            if (this.apiEndpoint == null) {
                this.apiEndpoint = String.format("%s-aiplatform.googleapis.com", this.location);
            }
            return new VertexAI(this.projectId, this.location, this.apiEndpoint, this.transport, this.credentials, (List)this.scopes);
        }

        public Builder setProjectId(String projectId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"projectId can't be null or empty");
            this.projectId = projectId;
            return this;
        }

        public Builder setLocation(String location) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0, (Object)"location can't be null or empty");
            this.location = location;
            return this;
        }

        public Builder setApiEndpoint(String apiEndpoint) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)apiEndpoint) ? 1 : 0) != 0, (Object)"apiEndpoint can't be null or empty");
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public Builder setTransport(Transport transport) {
            Preconditions.checkNotNull((Object)((Object)transport), (Object)"transport can't be null");
            this.transport = transport;
            return this;
        }

        public Builder setCredentials(Credentials credentials) {
            Preconditions.checkNotNull((Object)credentials, (Object)"credentials can't be null");
            this.credentials = credentials;
            return this;
        }

        public Builder setScopes(List<String> scopes) {
            Preconditions.checkNotNull(scopes, (Object)"scopes can't be null");
            this.scopes = ImmutableList.copyOf(scopes);
            return this;
        }
    }
}

