/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.api.core.BetaApi;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@BetaApi
public final class UploadPartRequest {
    private final String bucket;
    private final String key;
    private final int partNumber;
    private final String uploadId;

    private UploadPartRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
    }

    @BetaApi
    public String bucket() {
        return this.bucket;
    }

    @BetaApi
    public String key() {
        return this.key;
    }

    @BetaApi
    public int partNumber() {
        return this.partNumber;
    }

    @BetaApi
    public String uploadId() {
        return this.uploadId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadPartRequest)) {
            return false;
        }
        UploadPartRequest that = (UploadPartRequest)o;
        return this.partNumber == that.partNumber && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.key, this.partNumber, this.uploadId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("partNumber", this.partNumber).add("uploadId", (Object)this.uploadId).toString();
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public static class Builder {
        private String bucket;
        private String key;
        private int partNumber;
        private String uploadId;

        private Builder() {
        }

        @BetaApi
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @BetaApi
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @BetaApi
        public Builder partNumber(int partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @BetaApi
        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @BetaApi
        public UploadPartRequest build() {
            return new UploadPartRequest(this);
        }
    }
}

