/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.Context;
import com.google.cloud.logging.LoggingConfig;

public class ContextHandler {
    private static final ThreadLocal<Context> contextHolder = ContextHandler.initContextHolder();
    private static final ThreadLocal<ContextPriority> currentPriority = ThreadLocal.withInitial(() -> ContextPriority.NO_INPUT);

    private static ThreadLocal<Context> initContextHolder() {
        LoggingConfig config = new LoggingConfig(ContextHandler.class.getName());
        if (config.getUseInheritedContext()) {
            return new InheritableThreadLocal<Context>();
        }
        return new ThreadLocal<Context>();
    }

    public Context getCurrentContext() {
        return contextHolder.get();
    }

    public void setCurrentContext(Context context) {
        this.setCurrentContext(context, ContextPriority.NO_INPUT);
    }

    public ContextPriority getCurrentContextPriority() {
        return currentPriority.get();
    }

    public void setCurrentContext(Context context, ContextPriority priority) {
        if (priority != null && priority.compareTo(currentPriority.get()) >= 0 && context != null) {
            Context.Builder combinedContextBuilder = Context.newBuilder().setTraceId(context.getTraceId()).setSpanId(context.getSpanId()).setTraceSampled(context.getTraceSampled());
            Context currentContext = this.getCurrentContext();
            if (context.getHttpRequest() != null) {
                combinedContextBuilder.setRequest(context.getHttpRequest());
            } else if (currentContext != null && currentContext.getHttpRequest() != null) {
                combinedContextBuilder.setRequest(currentContext.getHttpRequest());
            }
            contextHolder.set(combinedContextBuilder.build());
            currentPriority.set(priority);
        }
    }

    public void removeCurrentContext() {
        contextHolder.remove();
    }

    public void removeCurrentContextPriority() {
        currentPriority.remove();
    }

    public static enum ContextPriority {
        NO_INPUT,
        XCLOUD_HEADER,
        W3C_HEADER,
        OTEL_EXTRACTED;

    }
}

