/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.testing.junit4;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

abstract class StdXCaptureRule
implements TestRule {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    protected abstract PrintStream getOriginal();

    protected abstract void set(PrintStream var1);

    public ByteArrayOutputStream getCapturedOutput() {
        return new ReadOnlyByteArrayOutputStream(this.byteArrayOutputStream);
    }

    public String getCapturedOutputAsUtf8String() {
        return new String(this.byteArrayOutputStream.toByteArray(), Charsets.UTF_8);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                PrintStream originalOut = StdXCaptureRule.this.getOriginal();
                TeeOutputStream tee = new TeeOutputStream(System.out, StdXCaptureRule.this.byteArrayOutputStream);
                boolean outReplaced = false;
                try {
                    StdXCaptureRule.this.set(new PrintStream(tee));
                    outReplaced = true;
                    base.evaluate();
                }
                finally {
                    if (outReplaced) {
                        StdXCaptureRule.this.set(originalOut);
                    }
                }
            }
        };
    }

    private static final class ReadOnlyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final ByteArrayOutputStream delegate;

        public ReadOnlyByteArrayOutputStream(ByteArrayOutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized void write(int b) {
            throw this.getIllegalStateException("write(b)");
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            throw this.getIllegalStateException("write(byte[], off, len)");
        }

        @Override
        public synchronized void writeTo(OutputStream out) {
            throw this.getIllegalStateException("writeOt(out)");
        }

        @Override
        public synchronized void reset() {
            throw this.getIllegalStateException("reset()");
        }

        @Override
        public synchronized byte[] toByteArray() {
            return this.delegate.toByteArray();
        }

        @Override
        public void close() {
        }

        @Override
        public synchronized int size() {
            return this.delegate.size();
        }

        @Override
        public synchronized String toString() {
            return this.delegate.toString();
        }

        @Override
        public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
            return this.delegate.toString(charsetName);
        }

        @Override
        public synchronized String toString(int hibyte) {
            return this.delegate.toString(hibyte);
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
            throw this.getIllegalStateException("write(byte[])");
        }

        private IllegalStateException getIllegalStateException(String desc) {
            return new IllegalStateException(desc + " is forbidden");
        }
    }

    private static final class TeeOutputStream
    extends OutputStream {
        private final OutputStream left;
        private final OutputStream right;

        public TeeOutputStream(OutputStream left, OutputStream right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.left.write(b);
            }
            finally {
                this.right.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.left.flush();
            }
            finally {
                this.right.flush();
            }
        }
    }
}

