/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.testing;

import com.google.cloud.testing.Version;
import org.junit.Assert;
import org.junit.Test;

public class VersionTest {
    @Test
    public void testFromString() {
        Version version = Version.fromString((String)"2016.01.13");
        Assert.assertEquals((long)2016L, (long)version.getMajor());
        Assert.assertEquals((long)1L, (long)version.getMinor());
        Assert.assertEquals((long)13L, (long)version.getPatch());
        version = Version.fromString((String)"1.2.0");
        Assert.assertEquals((long)1L, (long)version.getMajor());
        Assert.assertEquals((long)2L, (long)version.getMinor());
        Assert.assertEquals((long)0L, (long)version.getPatch());
    }

    @Test
    public void testFromStringWithAlphas() {
        try {
            Version.fromString((String)"2016.01.hello");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testFromStringMissingPatch() {
        try {
            Version.fromString((String)"2016.01");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testFromStringMissingMinor() {
        try {
            Version.fromString((String)"2016");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testFromStringEmpty() {
        try {
            Version.fromString((String)"");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testFromStringNull() {
        try {
            Version.fromString(null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testCompare() {
        Version version = Version.fromString((String)"2016.01.13");
        Version sameVersion = Version.fromString((String)"2016.01.13");
        Version olderVersion = Version.fromString((String)"2015.12.01");
        Version newerVersion = Version.fromString((String)"2016.08.12");
        Assert.assertEquals((long)0L, (long)version.compareTo(sameVersion));
        Assert.assertTrue((version.compareTo(olderVersion) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((version.compareTo(newerVersion) < 0 ? 1 : 0) != 0);
        Version otherVersion = Version.fromString((String)"1.2.0");
        Assert.assertTrue((version.compareTo(otherVersion) > 0 ? 1 : 0) != 0);
    }
}

