/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.testing;

import com.google.cloud.testing.BaseEmulatorHelper;
import com.google.cloud.testing.CommandWrapper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CommandWrapperTest {
    private static final List<String> COMMAND = ImmutableList.of((Object)"my", (Object)"command");
    private static final List<String> WIN_COMMAND = ImmutableList.of((Object)"cmd", (Object)"/C", (Object)"my", (Object)"command");
    private static final List<String> UNIX_COMMAND = ImmutableList.of((Object)"bash", (Object)"my", (Object)"command");
    private static final Path DIRECTORY = Paths.get("my-path", new String[0]);
    private static final File WIN_NULL_FILE = new File("NUL:");
    private static final File UNIX_NULL_FILE = new File("/dev/null");

    @Test
    public void testCommandWrapperCommand() {
        CommandWrapper commandWrapper = CommandWrapper.create();
        commandWrapper.setCommand(COMMAND);
        ProcessBuilder processBuilder = commandWrapper.getBuilder();
        if (BaseEmulatorHelper.isWindows()) {
            Assert.assertEquals(WIN_COMMAND, processBuilder.command());
        } else {
            Assert.assertEquals(UNIX_COMMAND, processBuilder.command());
        }
        Assert.assertNull((Object)processBuilder.directory());
        Assert.assertFalse((boolean)processBuilder.redirectErrorStream());
        Assert.assertEquals((Object)ProcessBuilder.Redirect.PIPE, (Object)processBuilder.redirectError());
    }

    @Test
    public void testCommandWrapperRedirectErrorStream() {
        CommandWrapper commandWrapper = CommandWrapper.create();
        commandWrapper.setCommand(COMMAND);
        commandWrapper.setRedirectErrorStream();
        ProcessBuilder processBuilder = commandWrapper.getBuilder();
        if (BaseEmulatorHelper.isWindows()) {
            Assert.assertEquals(WIN_COMMAND, processBuilder.command());
        } else {
            Assert.assertEquals(UNIX_COMMAND, processBuilder.command());
        }
        Assert.assertNull((Object)processBuilder.directory());
        Assert.assertTrue((boolean)processBuilder.redirectErrorStream());
        Assert.assertEquals((Object)ProcessBuilder.Redirect.PIPE, (Object)processBuilder.redirectError());
    }

    @Test
    public void testCommandWrapperRedirectErrorInherit() {
        CommandWrapper commandWrapper = CommandWrapper.create();
        commandWrapper.setCommand(COMMAND);
        commandWrapper.setRedirectErrorInherit();
        ProcessBuilder processBuilder = commandWrapper.getBuilder();
        if (BaseEmulatorHelper.isWindows()) {
            Assert.assertEquals(WIN_COMMAND, processBuilder.command());
        } else {
            Assert.assertEquals(UNIX_COMMAND, processBuilder.command());
        }
        Assert.assertNull((Object)processBuilder.directory());
        Assert.assertFalse((boolean)processBuilder.redirectErrorStream());
        Assert.assertEquals((Object)ProcessBuilder.Redirect.INHERIT, (Object)processBuilder.redirectError());
    }

    @Test
    public void testCommandWrapperDirectory() {
        CommandWrapper commandWrapper = CommandWrapper.create();
        commandWrapper.setCommand(COMMAND);
        commandWrapper.setDirectory(DIRECTORY);
        ProcessBuilder processBuilder = commandWrapper.getBuilder();
        if (BaseEmulatorHelper.isWindows()) {
            Assert.assertEquals(WIN_COMMAND, processBuilder.command());
        } else {
            Assert.assertEquals(UNIX_COMMAND, processBuilder.command());
        }
        Assert.assertEquals((Object)DIRECTORY, (Object)processBuilder.directory().toPath());
        Assert.assertFalse((boolean)processBuilder.redirectErrorStream());
        Assert.assertEquals((Object)ProcessBuilder.Redirect.PIPE, (Object)processBuilder.redirectError());
    }

    @Test
    public void testCommandWrapperRedirectOutputToNull() {
        CommandWrapper commandWrapper = CommandWrapper.create();
        commandWrapper.setCommand(COMMAND);
        commandWrapper.setRedirectOutputToNull();
        ProcessBuilder processBuilder = commandWrapper.getBuilder();
        if (BaseEmulatorHelper.isWindows()) {
            Assert.assertEquals(WIN_COMMAND, processBuilder.command());
            Assert.assertEquals((Object)ProcessBuilder.Redirect.to(WIN_NULL_FILE), (Object)processBuilder.redirectOutput());
        } else {
            Assert.assertEquals(UNIX_COMMAND, processBuilder.command());
            Assert.assertEquals((Object)ProcessBuilder.Redirect.to(UNIX_NULL_FILE), (Object)processBuilder.redirectOutput());
        }
        Assert.assertNull((Object)processBuilder.directory());
        Assert.assertFalse((boolean)processBuilder.redirectErrorStream());
        Assert.assertEquals((Object)ProcessBuilder.Redirect.PIPE, (Object)processBuilder.redirectError());
    }
}

