/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.testing;

import com.google.api.client.util.Charsets;
import com.google.cloud.testing.BlockingProcessStreamReader;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class BlockingProcessStreamReaderTest {
    private static final String BLOCK_UNTIL = "Dev App Server is now running";
    private static final String OUTPUT = "First Line\nSecond Line\nDev App Server is now running";
    private static final String OUTPUT_WITH_LOGS = "First Line\nDev App Server is now running\nNov 08, 2016 2:05:44 PM io.netty.buffer.PooledByteBufAllocator <clinit>\nINFO: log line 1\nlog line 2\nNov 08, 2016 2:05:44 PM io.netty.buffer.PooledByteBufAllocator <clinit>\nFINE: log line 3\n";
    private static final String TAGGED_OUTPUT_WITH_LOGS = "[emulator] First Line\n[emulator]Dev App Server is now running\n[emulator] Nov 08, 2016 2:05:44 PM io.netty.buffer.PooledByteBufAllocator <clinit>\n[emulator] INFO: log line 1\n[emulator] log line 2\n[emulator] Nov 08, 2016 2:05:44 PM io.netty.buffer.PooledByteBufAllocator <clinit>\n[emulator] FINE: log line 3\n";
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)10L);

    @Test
    public void testForwardLogEntry() throws IOException, InterruptedException {
        TestLogger logger = new TestLogger();
        ByteArrayInputStream stream = new ByteArrayInputStream(OUTPUT_WITH_LOGS.getBytes(Charsets.UTF_8));
        BlockingProcessStreamReader.start((String)"emulator", (InputStream)stream, (String)BLOCK_UNTIL, (Logger)logger).join();
        Assert.assertEquals((Object)("[emulator] log line 1" + System.lineSeparator() + "[emulator] log line 2"), logger.getLogs().get((Object)Level.INFO).iterator().next());
        Assert.assertEquals((Object)"[emulator] log line 3", logger.getLogs().get((Object)Level.FINE).iterator().next());
        ((InputStream)stream).close();
    }

    @Test
    public void testForwardAlreadyTaggedLogs() throws IOException, InterruptedException {
        TestLogger logger = new TestLogger();
        ByteArrayInputStream stream = new ByteArrayInputStream(TAGGED_OUTPUT_WITH_LOGS.getBytes(Charsets.UTF_8));
        BlockingProcessStreamReader.start((String)"emulator", (InputStream)stream, (String)BLOCK_UNTIL, (Logger)logger).join();
        Assert.assertEquals((Object)("[emulator] log line 1" + System.lineSeparator() + "[emulator] log line 2"), logger.getLogs().get((Object)Level.INFO).iterator().next());
        Assert.assertEquals((Object)"[emulator] log line 3", logger.getLogs().get((Object)Level.FINE).iterator().next());
        ((InputStream)stream).close();
    }

    private static final class TestLogger
    extends Logger {
        private final Multimap<Level, String> logs = LinkedHashMultimap.create();

        private TestLogger() {
            super("text-logger", null);
        }

        @Override
        public void log(Level level, String msg) {
            this.logs.put((Object)level, (Object)msg);
        }

        Multimap<Level, String> getLogs() {
            return this.logs;
        }
    }
}

