/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.testing;

import com.google.api.client.util.Charsets;
import com.google.cloud.ServiceOptions;
import com.google.cloud.testing.BaseEmulatorHelper;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.junit.Test;
import org.threeten.bp.Duration;

public class BaseEmulatorHelperTest {
    private static final String BLOCK_UNTIL = "Block until";

    @Test
    public void testEmulatorHelper() throws IOException, InterruptedException, TimeoutException {
        Process process = (Process)EasyMock.createStrictMock(Process.class);
        ByteArrayInputStream stream = new ByteArrayInputStream(BLOCK_UNTIL.getBytes(Charsets.UTF_8));
        BaseEmulatorHelper.EmulatorRunner emulatorRunner = (BaseEmulatorHelper.EmulatorRunner)EasyMock.createStrictMock(BaseEmulatorHelper.EmulatorRunner.class);
        EasyMock.expect((Object)process.getInputStream()).andReturn((Object)stream);
        EasyMock.expect((Object)emulatorRunner.isAvailable()).andReturn((Object)true);
        emulatorRunner.start();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)emulatorRunner.getProcess()).andReturn((Object)process);
        emulatorRunner.waitFor(Duration.ofMinutes((long)1L));
        EasyMock.expectLastCall().andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{process, emulatorRunner});
        TestEmulatorHelper helper = new TestEmulatorHelper((List)ImmutableList.of((Object)emulatorRunner), BLOCK_UNTIL);
        helper.start();
        helper.stop(Duration.ofMinutes((long)1L));
        EasyMock.verify((Object[])new Object[0]);
    }

    @Test
    public void testEmulatorHelperDownloadWithRetries() throws IOException, InterruptedException, TimeoutException {
        String mockExternalForm = "mockExternalForm";
        String mockInputStream = "mockInputStream";
        String mockProtocol = "mockProtocol";
        String mockFile = "mockFile";
        String mockAccessToken = "mockAccessToken";
        String mockCommandText = "mockCommandText";
        MockURLStreamHandler mockURLStreamHandler = (MockURLStreamHandler)EasyMock.createMock(MockURLStreamHandler.class);
        URLConnection mockURLConnection = (URLConnection)EasyMock.mock(URLConnection.class);
        EasyMock.expect((Object)mockURLStreamHandler.toExternalForm((URL)EasyMock.anyObject(URL.class))).andReturn((Object)mockExternalForm).anyTimes();
        EasyMock.expect((Object)mockURLConnection.getInputStream()).andReturn((Object)new ByteArrayInputStream(mockInputStream.getBytes())).anyTimes();
        mockURLConnection.setRequestProperty("Authorization", "Bearer " + mockAccessToken);
        EasyMock.expect((Object)mockURLStreamHandler.openConnection((URL)EasyMock.anyObject(URL.class))).andThrow((Throwable)new EOFException()).times(1);
        EasyMock.expect((Object)mockURLStreamHandler.openConnection((URL)EasyMock.anyObject(URL.class))).andReturn((Object)mockURLConnection).times(1);
        EasyMock.replay((Object[])new Object[]{mockURLStreamHandler, mockURLConnection});
        URL url = new URL(mockProtocol, null, 0, mockFile, mockURLStreamHandler);
        BaseEmulatorHelper.DownloadableEmulatorRunner runner = new BaseEmulatorHelper.DownloadableEmulatorRunner((List)ImmutableList.of((Object)mockCommandText), url, null, mockAccessToken);
        File cachedFile = new File(System.getProperty("java.io.tmpdir"), mockExternalForm);
        cachedFile.delete();
        runner.start();
        EasyMock.verify((Object[])new Object[0]);
        cachedFile.delete();
    }

    @Test
    public void testEmulatorHelperMultipleRunners() throws IOException, InterruptedException, TimeoutException {
        Process process = (Process)EasyMock.createStrictMock(Process.class);
        ByteArrayInputStream stream = new ByteArrayInputStream(BLOCK_UNTIL.getBytes(Charsets.UTF_8));
        BaseEmulatorHelper.EmulatorRunner firstRunner = (BaseEmulatorHelper.EmulatorRunner)EasyMock.createStrictMock(BaseEmulatorHelper.EmulatorRunner.class);
        BaseEmulatorHelper.EmulatorRunner secondRunner = (BaseEmulatorHelper.EmulatorRunner)EasyMock.createStrictMock(BaseEmulatorHelper.EmulatorRunner.class);
        EasyMock.expect((Object)process.getInputStream()).andReturn((Object)stream);
        EasyMock.expect((Object)firstRunner.isAvailable()).andReturn((Object)false);
        EasyMock.expect((Object)secondRunner.isAvailable()).andReturn((Object)true);
        secondRunner.start();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)secondRunner.getProcess()).andReturn((Object)process);
        secondRunner.waitFor(Duration.ofMinutes((long)1L));
        EasyMock.expectLastCall().andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{process, secondRunner});
        TestEmulatorHelper helper = new TestEmulatorHelper((List)ImmutableList.of((Object)firstRunner, (Object)secondRunner), BLOCK_UNTIL);
        helper.start();
        helper.stop(Duration.ofMinutes((long)1L));
        EasyMock.verify((Object[])new Object[0]);
    }

    private class MockURLStreamHandler
    extends URLStreamHandler {
        private MockURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return null;
        }

        @Override
        protected String toExternalForm(URL u) {
            return null;
        }
    }

    private static class TestEmulatorHelper
    extends BaseEmulatorHelper<ServiceOptions> {
        private final List<BaseEmulatorHelper.EmulatorRunner> runners;
        private final String blockUntil;

        private TestEmulatorHelper(List<BaseEmulatorHelper.EmulatorRunner> runners, String blockUntil) {
            super("emulator", 1, "project");
            this.runners = runners;
            this.blockUntil = blockUntil;
        }

        protected List<BaseEmulatorHelper.EmulatorRunner> getEmulatorRunners() {
            return this.runners;
        }

        protected Logger getLogger() {
            return null;
        }

        public ServiceOptions getOptions() {
            return null;
        }

        public void start() throws IOException, InterruptedException {
            this.startProcess(this.blockUntil);
        }

        public void stop(Duration timeout) throws IOException, InterruptedException, TimeoutException {
            this.waitForProcess(timeout);
        }

        public void reset() throws IOException {
        }
    }
}

