/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Timestamp;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TimestampTest {
    private static final String TEST_TIME_ISO = "2015-10-12T15:14:54Z";
    private static final long TEST_TIME_SECONDS = 1444662894L;
    private static final long TEST_TIME_MICROSECONDS = 10000100L;
    private static final long TEST_TIME_MILLISECONDS = TimeUnit.SECONDS.toMillis(1444662894L) + TimeUnit.MICROSECONDS.toMillis(1234L);
    private static final long TEST_TIME_MILLISECONDS_NEGATIVE = -1000L;
    private static final Date TEST_DATE = new Date(TEST_TIME_MILLISECONDS);
    private static final Date TEST_DATE_PRE_EPOCH = new Date(-1000L);

    @Test
    public void minValue() {
        Truth.assertThat((Long)Timestamp.MIN_VALUE.getSeconds()).isEqualTo((Object)-62135596800L);
        Truth.assertThat((Integer)Timestamp.MIN_VALUE.getNanos()).isEqualTo((Object)0);
    }

    @Test
    public void maxValue() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.set(9999, 11, 31, 23, 59, 59);
        java.sql.Timestamp expectedMin = new java.sql.Timestamp(calendar.getTimeInMillis());
        expectedMin.setNanos(999999999);
        Truth.assertThat((Long)Timestamp.MAX_VALUE.getSeconds()).isEqualTo((Object)(calendar.getTimeInMillis() / 1000L));
        Truth.assertThat((Integer)Timestamp.MAX_VALUE.getNanos()).isEqualTo((Object)999999999);
    }

    @Test
    public void ofMicroseconds() {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)10000100L);
        Truth.assertThat((Long)timestamp.getSeconds()).isEqualTo((Object)10L);
        Truth.assertThat((Integer)timestamp.getNanos()).isEqualTo((Object)100000L);
    }

    @Test
    public void ofDate() {
        Timestamp timestamp = Timestamp.of((Date)TEST_DATE);
        Long expectedSeconds = TimeUnit.MILLISECONDS.toSeconds(TEST_TIME_MILLISECONDS);
        Long expectedNanos = TimeUnit.MILLISECONDS.toNanos(TEST_TIME_MILLISECONDS) - TimeUnit.SECONDS.toNanos(expectedSeconds);
        Truth.assertThat((Long)timestamp.getSeconds()).isEqualTo((Object)expectedSeconds);
        Truth.assertThat((Integer)timestamp.getNanos()).isEqualTo((Object)expectedNanos);
    }

    @Test
    public void testOf() {
        String expectedTimestampString = "1970-01-01T00:00:12.345000000Z";
        java.sql.Timestamp input = new java.sql.Timestamp(12345L);
        Timestamp timestamp = Timestamp.of((java.sql.Timestamp)input);
        Assert.assertEquals((Object)timestamp.toString(), (Object)expectedTimestampString);
    }

    @Test
    public void testOf_exactSecond() {
        String expectedTimestampString = "1970-01-01T00:00:12Z";
        java.sql.Timestamp input = new java.sql.Timestamp(12000L);
        Timestamp timestamp = Timestamp.of((java.sql.Timestamp)input);
        Assert.assertEquals((Object)timestamp.toString(), (Object)expectedTimestampString);
    }

    @Test
    public void testOf_preEpoch() {
        String expectedTimestampString = "1969-12-31T23:59:47.655000000Z";
        java.sql.Timestamp input = new java.sql.Timestamp(-12345L);
        Timestamp timestamp = Timestamp.of((java.sql.Timestamp)input);
        Assert.assertEquals((Object)timestamp.toString(), (Object)expectedTimestampString);
    }

    @Test
    public void testOf_onEpoch() {
        String expectedTimestampString = "1970-01-01T00:00:00Z";
        java.sql.Timestamp input = new java.sql.Timestamp(0L);
        Timestamp timestamp = Timestamp.of((java.sql.Timestamp)input);
        Assert.assertEquals((Object)timestamp.toString(), (Object)expectedTimestampString);
    }

    @Test
    public void testOf_preEpochExactSecond() {
        String expectedTimestampString = "1969-12-31T23:59:59Z";
        java.sql.Timestamp input = new java.sql.Timestamp(-1000L);
        Timestamp timestamp = Timestamp.of((java.sql.Timestamp)input);
        Assert.assertEquals((Object)timestamp.toString(), (Object)expectedTimestampString);
    }

    @Test
    public void ofDatePreEpoch() {
        Timestamp timestamp = Timestamp.of((Date)TEST_DATE_PRE_EPOCH);
        long expectedSeconds = -1L;
        int expectedNanos = 0;
        if (expectedNanos < 0) {
            --expectedSeconds;
            expectedNanos += 1000000000;
        }
        Truth.assertThat((Long)timestamp.getSeconds()).isEqualTo((Object)expectedSeconds);
        Truth.assertThat((Integer)timestamp.getNanos()).isEqualTo((Object)expectedNanos);
    }

    @Test
    public void toDate() {
        Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)1234000);
        Date date = timestamp.toDate();
        Truth.assertThat((Long)TEST_TIME_MILLISECONDS).isEqualTo((Object)date.getTime());
    }

    @Test
    public void toFromSqlTimestamp() {
        long seconds = 1444662894L;
        int nanos = 500000000;
        java.sql.Timestamp sqlTs = new java.sql.Timestamp(seconds * 1000L);
        sqlTs.setNanos(nanos);
        Timestamp ts = Timestamp.of((java.sql.Timestamp)sqlTs);
        Truth.assertThat((Long)ts.getSeconds()).isEqualTo((Object)seconds);
        Truth.assertThat((Integer)ts.getNanos()).isEqualTo((Object)nanos);
        Truth.assertThat((Comparable)ts.toSqlTimestamp()).isEqualTo((Object)sqlTs);
    }

    @Test
    public void boundsSecondsMin() {
        try {
            Timestamp.ofTimeSecondsAndNanos((long)(Timestamp.MIN_VALUE.getSeconds() - 1L), (int)999999999);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void boundsSecondsMax() {
        try {
            Timestamp.ofTimeSecondsAndNanos((long)(Timestamp.MAX_VALUE.getSeconds() + 1L), (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void boundsNanosMin() {
        try {
            Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)-1);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void boundsNanosMax() {
        try {
            Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)1000000000);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void boundsSqlTimestampMin() {
        try {
            Timestamp.of((java.sql.Timestamp)new java.sql.Timestamp((Timestamp.MIN_VALUE.getSeconds() - 1L) * 1000L));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void boundsSqlTimestampMax() {
        try {
            Timestamp.of((java.sql.Timestamp)new java.sql.Timestamp((Timestamp.MAX_VALUE.getSeconds() + 1L) * 1000L));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void equalsAndHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0), Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0), Timestamp.of((java.sql.Timestamp)new java.sql.Timestamp(1444662894000L))});
        tester.addEqualityGroup(new Object[]{Timestamp.ofTimeSecondsAndNanos((long)1444662895L, (int)0)});
        tester.addEqualityGroup(new Object[]{Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)1)});
        tester.testEquals();
    }

    @Test
    public void testToString() {
        Truth.assertThat((String)Timestamp.MIN_VALUE.toString()).isEqualTo((Object)"0001-01-01T00:00:00Z");
        Truth.assertThat((String)Timestamp.MAX_VALUE.toString()).isEqualTo((Object)"9999-12-31T23:59:59.999999999Z");
        Truth.assertThat((String)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0).toString()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Truth.assertThat((String)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)100).toString()).isEqualTo((Object)"1970-01-01T00:00:00.000000100Z");
        Truth.assertThat((String)Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0).toString()).isEqualTo((Object)TEST_TIME_ISO);
    }

    @Test
    public void parseTimestamp() {
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"0001-01-01T00:00:00Z")).isEqualTo((Object)Timestamp.MIN_VALUE);
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"9999-12-31T23:59:59.999999999Z")).isEqualTo((Object)Timestamp.MAX_VALUE);
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)TEST_TIME_ISO)).isEqualTo((Object)Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0));
    }

    @Test
    public void parseTimestampWithoutTimeZoneOffset() {
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"0001-01-01T00:00:00")).isEqualTo((Object)Timestamp.MIN_VALUE);
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"9999-12-31T23:59:59.999999999")).isEqualTo((Object)Timestamp.MAX_VALUE);
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"2015-10-12T15:14:54")).isEqualTo((Object)Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0));
    }

    @Test
    public void parseTimestampWithTimeZoneOffset() {
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"0001-01-01T00:00:00-00:00")).isEqualTo((Object)Timestamp.MIN_VALUE);
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"9999-12-31T23:59:59.999999999-00:00")).isEqualTo((Object)Timestamp.MAX_VALUE);
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"2020-12-06T19:21:12.123+05:30")).isEqualTo((Object)Timestamp.ofTimeSecondsAndNanos((long)1607262672L, (int)123000000));
        Truth.assertThat((Comparable)Timestamp.parseTimestamp((String)"2020-07-10T14:03:00-07:00")).isEqualTo((Object)Timestamp.ofTimeSecondsAndNanos((long)1594414980L, (int)0));
    }

    @Test
    public void fromProto() {
        com.google.protobuf.Timestamp proto = com.google.protobuf.Timestamp.newBuilder().setSeconds(1234L).setNanos(567).build();
        Timestamp timestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)proto);
        Truth.assertThat((Long)timestamp.getSeconds()).isEqualTo((Object)1234);
        Truth.assertThat((Integer)timestamp.getNanos()).isEqualTo((Object)567);
    }

    @Test
    public void comparable() {
        Truth.assertThat((Comparable)Timestamp.MIN_VALUE).isLessThan((Comparable)Timestamp.MAX_VALUE);
        Truth.assertThat((Comparable)Timestamp.MAX_VALUE).isGreaterThan((Comparable)Timestamp.MIN_VALUE);
        Truth.assertThat((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)0)).isAtLeast((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)0));
        Truth.assertThat((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)0)).isAtMost((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)0));
        Truth.assertThat((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)1000)).isLessThan((Comparable)Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0));
        Truth.assertThat((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)1000)).isAtMost((Comparable)Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0));
        Truth.assertThat((Comparable)Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0)).isGreaterThan((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)1000));
        Truth.assertThat((Comparable)Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0)).isAtLeast((Comparable)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)1000));
    }

    @Test
    public void serialization() throws Exception {
        SerializableTester.reserializeAndAssert((Object)Timestamp.parseTimestamp((String)"9999-12-31T23:59:59.999999999Z"));
    }
}

