/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.core.ApiFunction;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class StringEnumTest {
    @Test(expected=NullPointerException.class)
    public void testNullClass() {
        new StringEnumType(null, Letter.CONSTRUCTOR);
    }

    @Test
    public void testNullConstructor() {
        try {
            new StringEnumType(Letter.class, null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testEnumInstances() {
        Truth.assertThat((String)Letter.A.toString()).isEqualTo((Object)"A");
    }

    @Test
    public void testValueOf() {
        Truth.assertThat((Object)((Object)Letter.valueOf("A"))).isSameInstanceAs((Object)Letter.A);
        Truth.assertThat((Object)((Object)Letter.valueOf("B"))).isSameInstanceAs((Object)Letter.B);
        Truth.assertThat((Object)((Object)Letter.valueOf("C"))).isSameInstanceAs((Object)Letter.C);
        Truth.assertThat((String)Letter.valueOf("NonExistentLetter").toString()).isEqualTo((Object)"NonExistentLetter");
    }

    @Test
    public void testValueOfStrict() {
        Truth.assertThat((Object)((Object)Letter.valueOfStrict("A"))).isSameInstanceAs((Object)Letter.A);
        Truth.assertThat((Object)((Object)Letter.valueOfStrict("B"))).isSameInstanceAs((Object)Letter.B);
        Truth.assertThat((Object)((Object)Letter.valueOfStrict("C"))).isSameInstanceAs((Object)Letter.C);
    }

    @Test
    public void testEquals() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{Letter.A, Letter.valueOf("A"), Letter.valueOfStrict("A")});
        tester.addEqualityGroup(new Object[]{Letter.B, Letter.valueOf("B"), Letter.valueOfStrict("B")});
        tester.addEqualityGroup(new Object[]{Letter.C, Letter.valueOf("C"), Letter.valueOfStrict("C")});
        tester.addEqualityGroup(new Object[]{Letter.valueOf("NonExistentLetter"), Letter.valueOf("NonExistentLetter")});
    }

    @Test
    public void testValueOfStrict_invalid() {
        try {
            Letter.valueOfStrict("NonExistentLetter");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testValues() {
        Truth.assertThat((Boolean)Arrays.asList(Letter.values()).containsAll(Arrays.asList(Letter.A, Letter.B, Letter.C)));
    }

    public static class Letter
    extends StringEnumValue {
        private static final long serialVersionUID = -1717976087182628526L;
        private static final ApiFunction<String, Letter> CONSTRUCTOR = new ApiFunction<String, Letter>(){

            public Letter apply(String constant) {
                return new Letter(constant);
            }
        };
        private static final StringEnumType<Letter> type = new StringEnumType(Letter.class, CONSTRUCTOR);
        public static final Letter A = (Letter)((Object)type.createAndRegister("A"));
        public static final Letter B = (Letter)((Object)type.createAndRegister("B"));
        public static final Letter C = (Letter)((Object)type.createAndRegister("C"));

        private Letter(String constant) {
            super(constant);
        }

        public static Letter valueOfStrict(String constant) {
            return (Letter)((Object)type.valueOfStrict(constant));
        }

        public static Letter valueOf(String constant) {
            return (Letter)((Object)type.valueOf(constant));
        }

        public static Letter[] values() {
            return (Letter[])type.values();
        }
    }
}

