/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.RetryOption;
import org.junit.Assert;
import org.junit.Test;
import org.threeten.bp.Duration;

public class RetryOptionTest {
    private static final RetryOption TOTAL_TIMEOUT = RetryOption.totalTimeout((Duration)Duration.ofMillis((long)420L));
    private static final RetryOption INITIAL_RETRY_DELAY = RetryOption.initialRetryDelay((Duration)Duration.ofMillis((long)42L));
    private static final RetryOption RETRY_DELAY_MULTIPLIER = RetryOption.retryDelayMultiplier((double)1.5);
    private static final RetryOption MAX_RETRY_DELAY = RetryOption.maxRetryDelay((Duration)Duration.ofMillis((long)100L));
    private static final RetryOption MAX_ATTEMPTS = RetryOption.maxAttempts((int)100);
    private static final RetryOption JITTERED = RetryOption.jittered((boolean)false);
    private static final RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(Duration.ofMillis((long)420L)).setInitialRetryDelay(Duration.ofMillis((long)42L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)100L)).setMaxAttempts(100).setJittered(false).build();

    @Test
    public void testEqualsAndHashCode() {
        Assert.assertEquals((Object)TOTAL_TIMEOUT, (Object)TOTAL_TIMEOUT);
        Assert.assertEquals((Object)INITIAL_RETRY_DELAY, (Object)INITIAL_RETRY_DELAY);
        Assert.assertEquals((Object)RETRY_DELAY_MULTIPLIER, (Object)RETRY_DELAY_MULTIPLIER);
        Assert.assertEquals((Object)MAX_RETRY_DELAY, (Object)MAX_RETRY_DELAY);
        Assert.assertEquals((Object)MAX_ATTEMPTS, (Object)MAX_ATTEMPTS);
        Assert.assertEquals((Object)JITTERED, (Object)JITTERED);
        Assert.assertNotEquals((Object)TOTAL_TIMEOUT, (Object)JITTERED);
        Assert.assertNotEquals((Object)INITIAL_RETRY_DELAY, (Object)TOTAL_TIMEOUT);
        Assert.assertNotEquals((Object)RETRY_DELAY_MULTIPLIER, (Object)INITIAL_RETRY_DELAY);
        Assert.assertNotEquals((Object)MAX_RETRY_DELAY, (Object)RETRY_DELAY_MULTIPLIER);
        Assert.assertNotEquals((Object)MAX_ATTEMPTS, (Object)MAX_RETRY_DELAY);
        Assert.assertNotEquals((Object)JITTERED, (Object)MAX_ATTEMPTS);
        RetryOption totalTimeout = RetryOption.totalTimeout((Duration)Duration.ofMillis((long)420L));
        RetryOption initialRetryDelay = RetryOption.initialRetryDelay((Duration)Duration.ofMillis((long)42L));
        RetryOption retryDelayMultiplier = RetryOption.retryDelayMultiplier((double)1.5);
        RetryOption maxRetryDelay = RetryOption.maxRetryDelay((Duration)Duration.ofMillis((long)100L));
        RetryOption maxAttempts = RetryOption.maxAttempts((int)100);
        RetryOption jittered = RetryOption.jittered((boolean)false);
        Assert.assertEquals((Object)TOTAL_TIMEOUT, (Object)totalTimeout);
        Assert.assertEquals((Object)INITIAL_RETRY_DELAY, (Object)initialRetryDelay);
        Assert.assertEquals((Object)RETRY_DELAY_MULTIPLIER, (Object)retryDelayMultiplier);
        Assert.assertEquals((Object)MAX_RETRY_DELAY, (Object)maxRetryDelay);
        Assert.assertEquals((Object)MAX_ATTEMPTS, (Object)maxAttempts);
        Assert.assertEquals((Object)JITTERED, (Object)jittered);
        Assert.assertEquals((long)TOTAL_TIMEOUT.hashCode(), (long)totalTimeout.hashCode());
        Assert.assertEquals((long)INITIAL_RETRY_DELAY.hashCode(), (long)initialRetryDelay.hashCode());
        Assert.assertEquals((long)RETRY_DELAY_MULTIPLIER.hashCode(), (long)retryDelayMultiplier.hashCode());
        Assert.assertEquals((long)MAX_RETRY_DELAY.hashCode(), (long)maxRetryDelay.hashCode());
        Assert.assertEquals((long)MAX_ATTEMPTS.hashCode(), (long)maxAttempts.hashCode());
        Assert.assertEquals((long)JITTERED.hashCode(), (long)jittered.hashCode());
    }

    @Test
    public void testMergeToSettings() {
        RetrySettings defRetrySettings = RetrySettings.newBuilder().build();
        Assert.assertEquals((Object)defRetrySettings, (Object)RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[0]));
        RetrySettings mergedRetrySettings = RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[]{TOTAL_TIMEOUT, INITIAL_RETRY_DELAY, RETRY_DELAY_MULTIPLIER, MAX_RETRY_DELAY, MAX_ATTEMPTS, JITTERED});
        Assert.assertEquals((Object)retrySettings, (Object)mergedRetrySettings);
        defRetrySettings = defRetrySettings.toBuilder().setTotalTimeout(Duration.ofMillis((long)420L)).build();
        mergedRetrySettings = RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[]{TOTAL_TIMEOUT});
        Assert.assertEquals((Object)defRetrySettings, (Object)mergedRetrySettings);
        defRetrySettings = defRetrySettings.toBuilder().setMaxRetryDelay(Duration.ofMillis((long)100L)).build();
        mergedRetrySettings = RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[]{MAX_RETRY_DELAY});
        Assert.assertEquals((Object)defRetrySettings, (Object)mergedRetrySettings);
        defRetrySettings = defRetrySettings.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)42L)).build();
        mergedRetrySettings = RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[]{INITIAL_RETRY_DELAY});
        Assert.assertEquals((Object)defRetrySettings, (Object)mergedRetrySettings);
        defRetrySettings = defRetrySettings.toBuilder().setRetryDelayMultiplier(1.5).build();
        mergedRetrySettings = RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[]{RETRY_DELAY_MULTIPLIER});
        Assert.assertEquals((Object)defRetrySettings, (Object)mergedRetrySettings);
        defRetrySettings = defRetrySettings.toBuilder().setMaxAttempts(100).build();
        mergedRetrySettings = RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[]{MAX_ATTEMPTS});
        Assert.assertEquals((Object)defRetrySettings, (Object)mergedRetrySettings);
        defRetrySettings = defRetrySettings.toBuilder().setJittered(false).build();
        mergedRetrySettings = RetryOption.mergeToSettings((RetrySettings)defRetrySettings, (RetryOption[])new RetryOption[]{JITTERED});
        Assert.assertEquals((Object)defRetrySettings, (Object)mergedRetrySettings);
    }
}

