/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Binding;
import com.google.cloud.Condition;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class PolicyV3Test {
    private static final String ALL_USERS = "allUsers";
    private static final String ALL_AUTH_USERS = "allAuthenticatedUsers";
    private static final String USER = "user:abc@gmail.com";
    private static final String SERVICE_ACCOUNT = "serviceAccount:service-account@gmail.com";
    private static final String GROUP = "group:group@gmail.com";
    private static final String DOMAIN = "domain:google.com";
    private static final String VIEWER = "roles/viewer";
    private static final String EDITOR = "roles/editor";
    private static final String OWNER = "roles/owner";
    private static final ImmutableList<String> MEMBERS_LIST_1 = ImmutableList.of((Object)"user:abc@gmail.com", (Object)"serviceAccount:service-account@gmail.com", (Object)"allUsers");
    private static final ImmutableList<String> MEMBERS_LIST_2 = ImmutableList.of((Object)"allAuthenticatedUsers", (Object)"group:group@gmail.com", (Object)"domain:google.com");
    private static final Binding VIEWER_BINDING = Binding.newBuilder().setRole("roles/viewer").setMembers(MEMBERS_LIST_1).build();
    private static final Binding EDITOR_BINDING = Binding.newBuilder().setRole("roles/editor").setMembers(MEMBERS_LIST_2).build();
    private static final ImmutableList<Binding> BINDINGS_NO_CONDITIONS = ImmutableList.of((Object)VIEWER_BINDING, (Object)EDITOR_BINDING);
    private static final Condition CONDITION = Condition.newBuilder().setTitle("Condition").setDescription("Condition").setExpression("Expr").build();
    private static final ImmutableList<Binding> BINDINGS_WITH_CONDITIONS = ImmutableList.of((Object)VIEWER_BINDING.toBuilder().setCondition(CONDITION).build(), (Object)EDITOR_BINDING);
    private static final Policy FULL_POLICY_V1 = Policy.newBuilder().setBindings(BINDINGS_NO_CONDITIONS).setEtag("etag").setVersion(1).build();
    private static final Policy FULL_POLICY_V3 = Policy.newBuilder().setBindings(BINDINGS_WITH_CONDITIONS).setEtag("etag").setVersion(3).build();
    private static final Policy FULL_POLICY_V3_WITH_VERSION_1 = Policy.newBuilder().setBindings(BINDINGS_WITH_CONDITIONS).setEtag("etag").setVersion(1).build();

    @Test
    public void testBuilderV1() {
        Assert.assertEquals(BINDINGS_NO_CONDITIONS, (Object)FULL_POLICY_V1.getBindingsList());
        Assert.assertEquals((long)1L, (long)FULL_POLICY_V1.getVersion());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY_V1.getEtag());
        Policy policy = FULL_POLICY_V1.toBuilder().setBindings(BINDINGS_NO_CONDITIONS).build();
        Assert.assertEquals(BINDINGS_NO_CONDITIONS, (Object)policy.getBindingsList());
        Assert.assertEquals((Object)"etag", (Object)policy.getEtag());
        Assert.assertEquals((long)1L, (long)policy.getVersion());
    }

    @Test
    public void testBuilderV3WithConditions() {
        Assert.assertEquals(BINDINGS_WITH_CONDITIONS, (Object)FULL_POLICY_V3.getBindingsList());
        Assert.assertEquals((long)3L, (long)FULL_POLICY_V3.getVersion());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY_V3.getEtag());
        Policy policy = FULL_POLICY_V3.toBuilder().setBindings(BINDINGS_WITH_CONDITIONS).build();
        Assert.assertEquals(BINDINGS_WITH_CONDITIONS, (Object)policy.getBindingsList());
        Assert.assertEquals((Object)"etag", (Object)policy.getEtag());
        Assert.assertEquals((long)3L, (long)policy.getVersion());
    }

    @Test
    public void testBuilderV1ToV3Compatability() {
        Assert.assertEquals(BINDINGS_WITH_CONDITIONS, (Object)FULL_POLICY_V3_WITH_VERSION_1.getBindingsList());
        Assert.assertEquals((long)1L, (long)FULL_POLICY_V3_WITH_VERSION_1.getVersion());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY_V3_WITH_VERSION_1.getEtag());
        Policy policy = FULL_POLICY_V3_WITH_VERSION_1.toBuilder().setBindings(BINDINGS_WITH_CONDITIONS).setVersion(3).build();
        Assert.assertEquals(BINDINGS_WITH_CONDITIONS, (Object)policy.getBindingsList());
        Assert.assertEquals((Object)"etag", (Object)policy.getEtag());
        Assert.assertEquals((long)3L, (long)policy.getVersion());
    }

    @Test
    public void removeMemberFromPolicy() {
        Assert.assertEquals((long)3L, (long)((Binding)FULL_POLICY_V3.getBindingsList().get(0)).getMembers().size());
        ArrayList<Binding> bindings = new ArrayList<Binding>((Collection<Binding>)FULL_POLICY_V3.getBindingsList());
        for (int i = 0; i < bindings.size(); ++i) {
            Binding binding = (Binding)bindings.get(i);
            if (!binding.getRole().equals(VIEWER)) continue;
            bindings.set(i, binding.toBuilder().removeMembers(new String[]{ALL_USERS}).build());
            break;
        }
        Policy updatedPolicy = FULL_POLICY_V3.toBuilder().setBindings(bindings).build();
        Assert.assertEquals((long)2L, (long)((Binding)updatedPolicy.getBindingsList().get(0)).getMembers().size());
    }

    @Test
    public void addMemberFromPolicy() {
        Assert.assertEquals((long)3L, (long)((Binding)FULL_POLICY_V3.getBindingsList().get(0)).getMembers().size());
        ArrayList<Binding> bindings = new ArrayList<Binding>((Collection<Binding>)FULL_POLICY_V3.getBindingsList());
        for (int i = 0; i < bindings.size(); ++i) {
            Binding binding = (Binding)bindings.get(i);
            if (!binding.getRole().equals(VIEWER)) continue;
            bindings.set(i, binding.toBuilder().addMembers("user:example@example.com", new String[0]).build());
        }
        Policy updatedPolicy = FULL_POLICY_V3.toBuilder().setBindings(bindings).build();
        Assert.assertEquals((long)4L, (long)((Binding)updatedPolicy.getBindingsList().get(0)).getMembers().size());
    }

    @Test
    public void removeBindingFromPolicy() {
        Assert.assertEquals((long)2L, (long)FULL_POLICY_V3.getBindingsList().size());
        ArrayList bindings = new ArrayList(FULL_POLICY_V3.getBindingsList());
        Iterator iterator = bindings.iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            if (!binding.getRole().equals(EDITOR) || binding.getCondition() != null) continue;
            iterator.remove();
            break;
        }
        Policy updatedPolicy = FULL_POLICY_V3.toBuilder().setBindings(bindings).build();
        Assert.assertEquals((long)1L, (long)updatedPolicy.getBindingsList().size());
    }

    @Test
    public void addBindingToPolicy() {
        Assert.assertEquals((long)2L, (long)FULL_POLICY_V3.getBindingsList().size());
        ArrayList<Binding> bindings = new ArrayList<Binding>((Collection<Binding>)FULL_POLICY_V3.getBindingsList());
        bindings.add(Binding.newBuilder().setRole(OWNER).setMembers((Iterable)ImmutableList.of((Object)USER)).build());
        Policy updatedPolicy = FULL_POLICY_V3.toBuilder().setBindings(bindings).build();
        Assert.assertEquals((long)3L, (long)updatedPolicy.getBindingsList().size());
    }

    @Test
    public void testIllegalPolicies() {
        try {
            Binding.newBuilder().setRole(null).build();
            Assert.fail((String)"Null role should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"Null role", (Object)ex.getMessage());
        }
        try {
            FULL_POLICY_V3.toBuilder().setBindings(Arrays.asList(Binding.newBuilder().setRole("test").setMembers(Arrays.asList(null, "user")).build())).build();
            Assert.fail((String)"Null member should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"at index 0", (Object)ex.getMessage());
        }
        try {
            FULL_POLICY_V3.getBindings();
            Assert.fail((String)"getBindings() should cause exception with Policy V3.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"getBindings() is only supported with version 1 policies and non-conditional policies", (Object)ex.getMessage());
        }
        try {
            FULL_POLICY_V3.toBuilder().addIdentity(Role.editor(), Identity.allUsers(), new Identity[0]);
            Assert.fail((String)"getBindings() should cause exception with Policy V3.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"addIdentity() is only supported with version 1 policies and non-conditional policies", (Object)ex.getMessage());
        }
        try {
            FULL_POLICY_V3.toBuilder().removeIdentity(Role.editor(), Identity.allUsers(), new Identity[0]);
            Assert.fail((String)"getBindings() should cause exception with Policy V3.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"removeIdentity() is only supported with version 1 policies and non-conditional policies", (Object)ex.getMessage());
        }
        try {
            FULL_POLICY_V3.toBuilder().setBindings(FULL_POLICY_V1.getBindings());
            Assert.fail((String)"getBindings() should cause exception with Policy V3.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"setBindings() is only supported with version 1 policies and non-conditional policies", (Object)ex.getMessage());
        }
    }

    @Test
    public void testEqualsHashCode() {
        Assert.assertNotNull((Object)FULL_POLICY_V3);
        Policy emptyPolicy = Policy.newBuilder().build();
        Policy anotherPolicy = Policy.newBuilder().build();
        Assert.assertEquals((Object)emptyPolicy, (Object)anotherPolicy);
        Assert.assertEquals((long)emptyPolicy.hashCode(), (long)anotherPolicy.hashCode());
        Assert.assertNotEquals((Object)FULL_POLICY_V3, (Object)FULL_POLICY_V1);
        Assert.assertNotEquals((long)FULL_POLICY_V3.hashCode(), (long)FULL_POLICY_V1.hashCode());
        Policy copy = FULL_POLICY_V1.toBuilder().build();
        Assert.assertEquals((Object)FULL_POLICY_V1, (Object)copy);
        Assert.assertEquals((long)FULL_POLICY_V1.hashCode(), (long)copy.hashCode());
    }

    @Test
    public void testBindings() {
        Assert.assertTrue((boolean)Policy.newBuilder().build().getBindingsList().isEmpty());
        Assert.assertEquals(BINDINGS_WITH_CONDITIONS, (Object)FULL_POLICY_V3.getBindingsList());
    }

    @Test
    public void testEtag() {
        Assert.assertNotNull((Object)FULL_POLICY_V3.getEtag());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY_V3.getEtag());
    }

    @Test
    public void testVersion() {
        Assert.assertEquals((long)1L, (long)FULL_POLICY_V1.getVersion());
        Assert.assertEquals((long)3L, (long)FULL_POLICY_V3.getVersion());
        Assert.assertEquals((long)1L, (long)FULL_POLICY_V3_WITH_VERSION_1.getVersion());
    }

    @Test
    public void testDefaultMarshaller() {
        Policy.DefaultMarshaller marshaller = new Policy.DefaultMarshaller();
        Policy emptyPolicy = Policy.newBuilder().build();
        Assert.assertEquals((Object)emptyPolicy, (Object)marshaller.fromPb(marshaller.toPb(emptyPolicy)));
        Assert.assertEquals((Object)FULL_POLICY_V3, (Object)marshaller.fromPb(marshaller.toPb(FULL_POLICY_V3)));
        Assert.assertEquals((Object)FULL_POLICY_V1, (Object)marshaller.fromPb(marshaller.toPb(FULL_POLICY_V1)));
        com.google.iam.v1.Policy policyPb = com.google.iam.v1.Policy.getDefaultInstance();
        Policy policy = marshaller.fromPb(policyPb);
        Assert.assertTrue((boolean)policy.getBindingsList().isEmpty());
        Assert.assertNull((Object)policy.getEtag());
        Assert.assertEquals((long)0L, (long)policy.getVersion());
    }
}

