/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.gax.paging.Page;
import com.google.cloud.PageImpl;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;

public class PageImplTest {
    private static final ImmutableList<String> VALUES = ImmutableList.of((Object)"1", (Object)"2");
    private static final ImmutableList<String> NEXT_VALUES = ImmutableList.of((Object)"3", (Object)"4");
    private static final ImmutableList<String> ALL_VALUES = ImmutableList.builder().addAll(VALUES).addAll(NEXT_VALUES).build();

    @Test
    public void testPage() {
        PageImpl nextResult = new PageImpl(null, "c", NEXT_VALUES);
        TestPageFetcher fetcher = new TestPageFetcher((PageImpl<String>)nextResult);
        PageImpl result = new PageImpl((PageImpl.NextPageFetcher)fetcher, "c", VALUES);
        Assert.assertEquals((Object)nextResult, (Object)result.getNextPage());
        Assert.assertEquals((Object)"c", (Object)result.getNextPageToken());
        Assert.assertEquals(VALUES, (Object)result.getValues());
    }

    @Test
    public void testIterateAll() {
        PageImpl nextResult = new PageImpl(null, "c", NEXT_VALUES);
        TestPageFetcher fetcher = new TestPageFetcher((PageImpl<String>)nextResult);
        PageImpl result = new PageImpl((PageImpl.NextPageFetcher)fetcher, "c", VALUES);
        Assert.assertEquals(ALL_VALUES, (Object)ImmutableList.copyOf((Iterable)result.iterateAll()));
    }

    private static class TestPageFetcher
    implements PageImpl.NextPageFetcher<String> {
        private static final long serialVersionUID = -8316752901403429976L;
        private final PageImpl<String> nextResult;

        TestPageFetcher(PageImpl<String> nextResult) {
            this.nextResult = nextResult;
        }

        public Page<String> getNextPage() {
            return this.nextResult;
        }
    }
}

