/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.LabelDescriptor;
import com.google.cloud.MonitoredResourceDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MonitoredResourceDescriptorTest {
    private static final MonitoredResourceDescriptor.LabelDescriptor BOOLEAN_LABEL = new MonitoredResourceDescriptor.LabelDescriptor("booleanKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.BOOL, "Boolean label");
    private static final MonitoredResourceDescriptor.LabelDescriptor STRING_LABEL = new MonitoredResourceDescriptor.LabelDescriptor("stringKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.STRING, "String label");
    private static final MonitoredResourceDescriptor.LabelDescriptor INT_LABEL = new MonitoredResourceDescriptor.LabelDescriptor("intKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, "Int label");
    private static final MonitoredResourceDescriptor.LabelDescriptor INT_LABEL_NO_DESCRIPTION = new MonitoredResourceDescriptor.LabelDescriptor("intKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, null);
    private static final String TYPE = "resource_type";
    private static final String NAME = "resourceName";
    private static final String DISPLAY_NAME = "Display Name";
    private static final String DESCRIPTION = "Resource Descriptor";
    private static final List<MonitoredResourceDescriptor.LabelDescriptor> LABELS = ImmutableList.of((Object)BOOLEAN_LABEL, (Object)STRING_LABEL, (Object)INT_LABEL);
    private static final MonitoredResourceDescriptor RESOURCE_DESCRIPTOR = MonitoredResourceDescriptor.newBuilder((String)"resource_type").setName("resourceName").setDisplayName("Display Name").setDescription("Resource Descriptor").setLabels(LABELS).build();

    @Test
    public void testLabelDescriptor() {
        Assert.assertEquals((Object)"booleanKey", (Object)BOOLEAN_LABEL.getKey());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.BOOL, (Object)BOOLEAN_LABEL.getValueType());
        Assert.assertEquals((Object)"Boolean label", (Object)BOOLEAN_LABEL.getDescription());
        Assert.assertEquals((Object)"stringKey", (Object)STRING_LABEL.getKey());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.STRING, (Object)STRING_LABEL.getValueType());
        Assert.assertEquals((Object)"String label", (Object)STRING_LABEL.getDescription());
        Assert.assertEquals((Object)"intKey", (Object)INT_LABEL.getKey());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, (Object)INT_LABEL.getValueType());
        Assert.assertEquals((Object)"Int label", (Object)INT_LABEL.getDescription());
        Assert.assertEquals((Object)"intKey", (Object)INT_LABEL_NO_DESCRIPTION.getKey());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, (Object)INT_LABEL_NO_DESCRIPTION.getValueType());
        Assert.assertNull((Object)INT_LABEL_NO_DESCRIPTION.getDescription());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TYPE, (Object)RESOURCE_DESCRIPTOR.getType());
        Assert.assertEquals((Object)NAME, (Object)RESOURCE_DESCRIPTOR.getName());
        Assert.assertEquals((Object)DISPLAY_NAME, (Object)RESOURCE_DESCRIPTOR.getDisplayName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)RESOURCE_DESCRIPTOR.getDescription());
        Assert.assertEquals(LABELS, (Object)RESOURCE_DESCRIPTOR.getLabels());
        MonitoredResourceDescriptor resourceDescriptor = MonitoredResourceDescriptor.newBuilder((String)TYPE).build();
        Assert.assertEquals((Object)TYPE, (Object)resourceDescriptor.getType());
        Assert.assertNull((Object)resourceDescriptor.getName());
        Assert.assertNull((Object)resourceDescriptor.getDisplayName());
        Assert.assertNull((Object)resourceDescriptor.getDescription());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)resourceDescriptor.getLabels());
    }

    @Test
    public void testToAndFromPbLabelDescriptor() {
        this.compareLabelDescriptor(BOOLEAN_LABEL, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)BOOLEAN_LABEL.toPb()));
        this.compareLabelDescriptor(STRING_LABEL, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)STRING_LABEL.toPb()));
        this.compareLabelDescriptor(INT_LABEL, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)INT_LABEL.toPb()));
        this.compareLabelDescriptor(INT_LABEL_NO_DESCRIPTION, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)INT_LABEL_NO_DESCRIPTION.toPb()));
    }

    @Test
    public void testToAndFromPb() {
        this.compareResourceDescriptor(RESOURCE_DESCRIPTOR, MonitoredResourceDescriptor.fromPb((com.google.api.MonitoredResourceDescriptor)RESOURCE_DESCRIPTOR.toPb()));
        MonitoredResourceDescriptor resourceDescriptor = MonitoredResourceDescriptor.newBuilder((String)TYPE).build();
        this.compareResourceDescriptor(resourceDescriptor, MonitoredResourceDescriptor.fromPb((com.google.api.MonitoredResourceDescriptor)resourceDescriptor.toPb()));
    }

    private void compareLabelDescriptor(MonitoredResourceDescriptor.LabelDescriptor expected, MonitoredResourceDescriptor.LabelDescriptor value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getKey(), (Object)value.getKey());
        Assert.assertEquals((Object)expected.getValueType(), (Object)value.getValueType());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }

    private void compareResourceDescriptor(MonitoredResourceDescriptor expected, MonitoredResourceDescriptor value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((Object)expected.getDisplayName(), (Object)value.getDisplayName());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

