/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.FieldSelector;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FieldSelectorHelperTest {
    private static final FieldSelector FIELD1 = new FieldSelector(){

        public String getSelector() {
            return "field1";
        }
    };
    private static final FieldSelector FIELD2 = new FieldSelector(){

        public String getSelector() {
            return "field2";
        }
    };
    private static final FieldSelector FIELD3 = new FieldSelector(){

        public String getSelector() {
            return "field3";
        }
    };
    private static final String[] FIRST_LEVEL_FIELDS = new String[]{"firstLevel1", "firstLevel2"};
    private static final List<FieldSelector> REQUIRED_FIELDS = ImmutableList.of((Object)FIELD1, (Object)FIELD2);
    private static final String CONTAINER = "container";

    @Test
    public void testSelector() {
        String selector = FieldSelector.Helper.selector(REQUIRED_FIELDS, (FieldSelector[])new FieldSelector[]{FIELD3});
        Assert.assertTrue((boolean)selector.contains("field1"));
        Assert.assertTrue((boolean)selector.contains("field2"));
        Assert.assertTrue((boolean)selector.contains("field3"));
        Assert.assertEquals((long)20L, (long)selector.length());
    }

    @Test
    public void testListSelector() {
        String selector = FieldSelector.Helper.listSelector((String)CONTAINER, REQUIRED_FIELDS, (FieldSelector[])new FieldSelector[]{FIELD3});
        Assert.assertTrue((boolean)selector.startsWith("nextPageToken,container("));
        Assert.assertTrue((boolean)selector.contains("field1"));
        Assert.assertTrue((boolean)selector.contains("field2"));
        Assert.assertTrue((boolean)selector.contains("field3"));
        Assert.assertTrue((boolean)selector.endsWith(")"));
        Assert.assertEquals((long)45L, (long)selector.length());
    }

    @Test
    public void testListSelectorWithExtraFields() {
        String selector = FieldSelector.Helper.listSelector((String)CONTAINER, REQUIRED_FIELDS, (FieldSelector[])new FieldSelector[]{FIELD3}, (String[])new String[]{"field4"});
        Assert.assertTrue((boolean)selector.startsWith("nextPageToken,container("));
        Assert.assertTrue((boolean)selector.contains("field1"));
        Assert.assertTrue((boolean)selector.contains("field2"));
        Assert.assertTrue((boolean)selector.contains("field3"));
        Assert.assertTrue((boolean)selector.contains("field4"));
        Assert.assertTrue((boolean)selector.endsWith(")"));
        Assert.assertEquals((long)52L, (long)selector.length());
    }

    @Test
    public void testListSelectorWithFirstLevelFields() {
        String selector = FieldSelector.Helper.listSelector((String[])FIRST_LEVEL_FIELDS, (String)CONTAINER, REQUIRED_FIELDS, (FieldSelector[])new FieldSelector[]{FIELD3}, (String[])new String[]{"field4"});
        Assert.assertTrue((boolean)selector.contains("firstLevel1"));
        Assert.assertTrue((boolean)selector.contains("firstLevel2"));
        Assert.assertTrue((boolean)selector.contains("nextPageToken"));
        Assert.assertTrue((boolean)selector.contains("container("));
        Assert.assertTrue((boolean)selector.contains("field1"));
        Assert.assertTrue((boolean)selector.contains("field2"));
        Assert.assertTrue((boolean)selector.contains("field3"));
        Assert.assertTrue((boolean)selector.contains("field4"));
        Assert.assertTrue((boolean)selector.endsWith(")"));
        Assert.assertEquals((long)76L, (long)selector.length());
    }
}

