/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.ExceptionHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionHandlerTest {
    @Test
    public void testVerifyCaller() {
        ExceptionHandler handler = ExceptionHandler.getDefaultInstance();
        class A
        implements Callable<Object> {
            A() {
            }

            @Override
            public Object call() throws IOException, InterruptedException {
                return null;
            }
        }
        ExceptionHandlerTest.assertValidCallable(new A(), handler);
        class B
        extends A {
            B() {
            }
        }
        ExceptionHandlerTest.assertValidCallable(new B(), handler);
        class C
        extends A {
            C() {
            }

            @Override
            public Object call() throws FileNotFoundException {
                return "c";
            }
        }
        ExceptionHandlerTest.assertValidCallable(new C(), handler);
        class D
        extends C {
            D() {
            }

            @Override
            public Object call() throws IllegalArgumentException {
                return "d";
            }
        }
        ExceptionHandlerTest.assertValidCallable(new D(), handler);
        class E
        extends A {
            E() {
            }

            @Override
            public String call() throws NullPointerException {
                return "e";
            }
        }
        ExceptionHandlerTest.assertValidCallable(new E(), handler);
        class F
        extends A {
            F() {
            }

            @Override
            public Object call() throws Error {
                return "f";
            }
        }
        ExceptionHandlerTest.assertInvalidCallable(new F(), handler);
        handler = ExceptionHandler.newBuilder().retryOn(new Class[]{FileNotFoundException.class, NullPointerException.class}).build();
        ExceptionHandlerTest.assertInvalidCallable(new A(), handler);
        ExceptionHandlerTest.assertInvalidCallable(new B(), handler);
        ExceptionHandlerTest.assertValidCallable(new C(), handler);
        ExceptionHandlerTest.assertInvalidCallable(new D(), handler);
        ExceptionHandlerTest.assertValidCallable(new E(), handler);
        ExceptionHandlerTest.assertInvalidCallable(new F(), handler);
    }

    private static <T> void assertValidCallable(Callable<T> callable, ExceptionHandler handler) {
        handler.verifyCaller(callable);
    }

    private static <T> void assertInvalidCallable(Callable<T> callable, ExceptionHandler handler) {
        try {
            handler.verifyCaller(callable);
            Assert.fail((String)"Expected RetryHelper constructor to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testShouldTry() {
        ExceptionHandler handler = ExceptionHandler.newBuilder().retryOn(new Class[]{IOException.class}).build();
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new IOException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new ClosedByInterruptException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new RuntimeException(), null));
        ExceptionHandler.Builder builder = ExceptionHandler.newBuilder().retryOn(new Class[]{IOException.class, NullPointerException.class}).abortOn(new Class[]{RuntimeException.class, ClosedByInterruptException.class, InterruptedException.class});
        handler = builder.build();
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new IOException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new ClosedByInterruptException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new InterruptedException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new RuntimeException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new NullPointerException(), null));
        final AtomicReference<ExceptionHandler.Interceptor.RetryResult> before = new AtomicReference<ExceptionHandler.Interceptor.RetryResult>(ExceptionHandler.Interceptor.RetryResult.NO_RETRY);
        ExceptionHandler.Interceptor interceptor = new ExceptionHandler.Interceptor(){

            public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
                return retryResult == ExceptionHandler.Interceptor.RetryResult.NO_RETRY ? ExceptionHandler.Interceptor.RetryResult.RETRY : ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
            }

            public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
                return (ExceptionHandler.Interceptor.RetryResult)before.get();
            }
        };
        builder.addInterceptors(new ExceptionHandler.Interceptor[]{interceptor});
        handler = builder.build();
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new IOException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new ClosedByInterruptException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new InterruptedException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new RuntimeException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new NullPointerException(), null));
        before.set(ExceptionHandler.Interceptor.RetryResult.RETRY);
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new IOException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new ClosedByInterruptException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new InterruptedException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new RuntimeException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new NullPointerException(), null));
        before.set(ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION);
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new IOException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new ClosedByInterruptException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new InterruptedException(), null));
        Assert.assertTrue((boolean)handler.shouldRetry((Throwable)new RuntimeException(), null));
        Assert.assertFalse((boolean)handler.shouldRetry((Throwable)new NullPointerException(), null));
    }

    @Test(expected=NullPointerException.class)
    public void testNullRetryResultFromBeforeEval() {
        ExceptionHandler.Interceptor interceptor = new ExceptionHandler.Interceptor(){

            public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
                return null;
            }

            public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
                return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
            }
        };
        ExceptionHandler handler = ExceptionHandler.newBuilder().addInterceptors(new ExceptionHandler.Interceptor[]{interceptor}).build();
        handler.shouldRetry((Throwable)new Exception(), null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullRetryResultFromAfterEval() {
        ExceptionHandler.Interceptor interceptor = new ExceptionHandler.Interceptor(){

            public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
                return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
            }

            public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
                return null;
            }
        };
        ExceptionHandler handler = ExceptionHandler.newBuilder().addInterceptors(new ExceptionHandler.Interceptor[]{interceptor}).build();
        handler.shouldRetry((Throwable)new Exception(), null);
    }
}

