/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.ByteArray;
import com.google.common.io.ByteStreams;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ByteArrayTest {
    private static final String STRING_CONTENT = "Hello, ByteArray!";
    private static final byte[] BYTES_CONTENT = "Hello, ByteArray!".getBytes(StandardCharsets.UTF_8);
    private static final ByteBuffer BYTE_BUFFER_CONTENT = ByteBuffer.wrap(BYTES_CONTENT);
    private static final InputStream STREAM_CONTENT = new ByteArrayInputStream(BYTES_CONTENT);
    private static final ByteArray STRING_ARRAY = ByteArray.copyFrom((String)"Hello, ByteArray!");
    private static final ByteArray BYTES_ARRAY = ByteArray.copyFrom((byte[])BYTES_CONTENT);
    private static final ByteArray BYTE_BUFFER_ARRAY = ByteArray.copyFrom((ByteBuffer)BYTE_BUFFER_CONTENT);
    private static final ByteArray ARRAY = new ByteArray(ByteString.copyFrom((byte[])BYTES_CONTENT));
    private static ByteArray streamArray;

    @BeforeClass
    public static void beforeClass() throws IOException {
        streamArray = ByteArray.copyFrom((InputStream)STREAM_CONTENT);
        BYTE_BUFFER_CONTENT.flip();
    }

    @Test
    public void testCopyFromString() throws IOException {
        Assert.assertEquals((Object)STRING_CONTENT, (Object)STRING_ARRAY.toStringUtf8());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])STRING_ARRAY.toByteArray());
        Assert.assertEquals((Object)BYTE_BUFFER_CONTENT.asReadOnlyBuffer(), (Object)STRING_ARRAY.asReadOnlyByteBuffer());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])ByteStreams.toByteArray((InputStream)STRING_ARRAY.asInputStream()));
    }

    @Test
    public void testCopyFromByteArray() throws IOException {
        Assert.assertEquals((Object)STRING_CONTENT, (Object)BYTES_ARRAY.toStringUtf8());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])BYTES_ARRAY.toByteArray());
        Assert.assertEquals((Object)BYTE_BUFFER_CONTENT.asReadOnlyBuffer(), (Object)BYTES_ARRAY.asReadOnlyByteBuffer());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])ByteStreams.toByteArray((InputStream)BYTES_ARRAY.asInputStream()));
    }

    @Test
    public void testCopyFromByteBuffer() throws IOException {
        Assert.assertEquals((Object)STRING_CONTENT, (Object)BYTE_BUFFER_ARRAY.toStringUtf8());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])BYTE_BUFFER_ARRAY.toByteArray());
        Assert.assertEquals((Object)BYTE_BUFFER_CONTENT.asReadOnlyBuffer(), (Object)BYTE_BUFFER_ARRAY.asReadOnlyByteBuffer());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])ByteStreams.toByteArray((InputStream)BYTE_BUFFER_ARRAY.asInputStream()));
    }

    @Test
    public void testCopyFromStream() throws IOException {
        Assert.assertEquals((Object)STRING_CONTENT, (Object)streamArray.toStringUtf8());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])streamArray.toByteArray());
        Assert.assertEquals((Object)BYTE_BUFFER_CONTENT.asReadOnlyBuffer(), (Object)streamArray.asReadOnlyByteBuffer());
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])ByteStreams.toByteArray((InputStream)streamArray.asInputStream()));
    }

    @Test
    public void testLength() {
        Assert.assertEquals((long)BYTES_CONTENT.length, (long)ARRAY.length());
    }

    @Test
    public void testToStringUtf8() {
        Assert.assertEquals((Object)STRING_CONTENT, (Object)ARRAY.toStringUtf8());
    }

    @Test
    public void testToByteArray() {
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])ARRAY.toByteArray());
    }

    @Test
    public void testAsReadOnlyByteBuffer() {
        Assert.assertEquals((Object)BYTE_BUFFER_CONTENT.asReadOnlyBuffer(), (Object)ARRAY.asReadOnlyByteBuffer());
    }

    @Test
    public void testAsInputStream() throws IOException {
        Assert.assertArrayEquals((byte[])BYTES_CONTENT, (byte[])ByteStreams.toByteArray((InputStream)ARRAY.asInputStream()));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)STRING_ARRAY.hashCode(), (long)BYTES_ARRAY.hashCode());
        Assert.assertEquals((long)BYTES_ARRAY.hashCode(), (long)BYTE_BUFFER_ARRAY.hashCode());
        Assert.assertEquals((long)BYTE_BUFFER_ARRAY.hashCode(), (long)streamArray.hashCode());
    }
}

