/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.paging.AsyncPage;
import com.google.cloud.AsyncPageImpl;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class AsyncPageImplTest {
    private static final ImmutableList<String> VALUES1 = ImmutableList.of((Object)"1", (Object)"2");
    private static final ImmutableList<String> VALUES2 = ImmutableList.of((Object)"3", (Object)"4");
    private static final ImmutableList<String> VALUES3 = ImmutableList.of((Object)"5", (Object)"6");
    private static final ImmutableList<String> ALL_VALUES = ImmutableList.builder().addAll(VALUES1).addAll(VALUES2).addAll(VALUES3).build();
    private static final ImmutableList<String> SOME_VALUES = ImmutableList.builder().addAll(VALUES2).addAll(VALUES3).build();

    @Test
    public void testPage() {
        AsyncPageImpl nextResult = new AsyncPageImpl(null, "c", VALUES2);
        TestPageFetcher fetcher = new TestPageFetcher((AsyncPageImpl<String>)nextResult);
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher, "c", VALUES1);
        Assert.assertEquals((Object)nextResult, (Object)result.getNextPage());
        Assert.assertEquals((Object)"c", (Object)result.getNextPageToken());
        Assert.assertEquals(VALUES1, (Object)result.getValues());
    }

    @Test
    public void testPageAsync() throws ExecutionException, InterruptedException {
        AsyncPageImpl nextResult = new AsyncPageImpl(null, "c", VALUES2);
        TestPageFetcher fetcher = new TestPageFetcher((AsyncPageImpl<String>)nextResult);
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher, "c", VALUES1);
        Assert.assertEquals((Object)nextResult, (Object)result.getNextPageAsync().get());
        Assert.assertEquals((Object)"c", (Object)result.getNextPageToken());
        Assert.assertEquals(VALUES1, (Object)result.getValues());
    }

    @Test
    public void testIterateAll() {
        AsyncPageImpl nextResult2 = new AsyncPageImpl(null, "c3", VALUES3);
        TestPageFetcher fetcher2 = new TestPageFetcher((AsyncPageImpl<String>)nextResult2);
        AsyncPageImpl nextResult1 = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher2, "c2", VALUES2);
        TestPageFetcher fetcher1 = new TestPageFetcher((AsyncPageImpl<String>)nextResult1);
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher1, "c1", VALUES1);
        Assert.assertEquals(ALL_VALUES, (Object)ImmutableList.copyOf((Iterable)result.iterateAll()));
    }

    @Test
    public void testAsyncPageAndIterateAll() throws ExecutionException, InterruptedException {
        AsyncPageImpl nextResult2 = new AsyncPageImpl(null, "c3", VALUES3);
        TestPageFetcher fetcher2 = new TestPageFetcher((AsyncPageImpl<String>)nextResult2);
        AsyncPageImpl nextResult1 = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher2, "c2", VALUES2);
        TestPageFetcher fetcher1 = new TestPageFetcher((AsyncPageImpl<String>)nextResult1);
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher1, "c1", VALUES1);
        Assert.assertEquals((Object)nextResult1, (Object)result.getNextPageAsync().get());
        Assert.assertEquals((Object)"c1", (Object)result.getNextPageToken());
        Assert.assertEquals(VALUES1, (Object)result.getValues());
        Assert.assertEquals(SOME_VALUES, (Object)ImmutableList.copyOf((Iterable)((AsyncPage)result.getNextPageAsync().get()).iterateAll()));
    }

    private static class TestPageFetcher
    implements AsyncPageImpl.NextPageFetcher<String> {
        private static final long serialVersionUID = 4703765400378593176L;
        private final AsyncPageImpl<String> nextResult;

        TestPageFetcher(AsyncPageImpl<String> nextResult) {
            this.nextResult = nextResult;
        }

        public ApiFuture<AsyncPage<String>> getNextPage() {
            return ApiFutures.immediateFuture(this.nextResult);
        }
    }
}

