/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.core.BetaApi;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValueList;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FieldValue
implements Serializable {
    private static final int MICROSECONDS = 1000000;
    private static final long serialVersionUID = 469098630191710061L;
    private final Attribute attribute;
    private final Object value;

    private FieldValue(Attribute attribute, Object value) {
        this.attribute = (Attribute)((Object)Preconditions.checkNotNull((Object)((Object)attribute)));
        this.value = value;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (String)this.value;
    }

    public byte[] getBytesValue() {
        try {
            return BaseEncoding.base64().decode((CharSequence)this.getStringValue());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public long getLongValue() {
        return Long.parseLong(this.getStringValue());
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.getStringValue());
    }

    public boolean getBooleanValue() {
        String stringValue = this.getStringValue();
        Preconditions.checkState((stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false") ? 1 : 0) != 0, (Object)"Field value is not of boolean type");
        return Boolean.parseBoolean(stringValue);
    }

    public long getTimestampValue() {
        BigDecimal secondsWithMicro = new BigDecimal(this.getStringValue());
        BigDecimal scaled = secondsWithMicro.scaleByPowerOfTen(6).setScale(0, RoundingMode.HALF_UP);
        return scaled.longValue();
    }

    public BigDecimal getNumericValue() {
        return new BigDecimal(this.getStringValue());
    }

    public List<FieldValue> getRepeatedValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (List)this.value;
    }

    public FieldValueList getRecordValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (FieldValueList)this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attribute", (Object)this.attribute).add("value", this.value).toString();
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.value});
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(FieldValue.class)) {
            return false;
        }
        FieldValue other = (FieldValue)obj;
        return this.attribute == other.attribute && Objects.equals(this.value, other.value);
    }

    @BetaApi
    public static FieldValue of(Attribute attribute, Object value) {
        return new FieldValue(attribute, value);
    }

    static FieldValue fromPb(Object cellPb) {
        return FieldValue.fromPb(cellPb, null);
    }

    static FieldValue fromPb(Object cellPb, Field recordSchema) {
        if (Data.isNull((Object)cellPb)) {
            return FieldValue.of(Attribute.PRIMITIVE, null);
        }
        if (cellPb instanceof String) {
            return FieldValue.of(Attribute.PRIMITIVE, cellPb);
        }
        if (cellPb instanceof List) {
            return FieldValue.of(Attribute.REPEATED, FieldValueList.fromPb((List)cellPb, null));
        }
        if (cellPb instanceof Map) {
            Map cellMapPb = (Map)cellPb;
            if (cellMapPb.containsKey("f")) {
                FieldList subFieldsSchema = recordSchema != null ? recordSchema.getSubFields() : null;
                return FieldValue.of(Attribute.RECORD, FieldValueList.fromPb((List)cellMapPb.get("f"), subFieldsSchema));
            }
            if (cellMapPb.containsKey("v")) {
                return FieldValue.fromPb(cellMapPb.get("v"), recordSchema);
            }
        }
        throw new IllegalArgumentException("Unexpected table cell format");
    }

    public static enum Attribute {
        PRIMITIVE,
        REPEATED,
        RECORD;

    }
}

