/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.youtubeAnalytics;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.youtubeAnalytics.YouTubeAnalyticsRequest;
import com.google.api.services.youtubeAnalytics.YouTubeAnalyticsRequestInitializer;
import com.google.api.services.youtubeAnalytics.model.BatchReportDefinitionList;
import com.google.api.services.youtubeAnalytics.model.BatchReportList;
import com.google.api.services.youtubeAnalytics.model.Group;
import com.google.api.services.youtubeAnalytics.model.GroupItem;
import com.google.api.services.youtubeAnalytics.model.GroupItemListResponse;
import com.google.api.services.youtubeAnalytics.model.GroupListResponse;
import com.google.api.services.youtubeAnalytics.model.ResultTable;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YouTubeAnalytics
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "youtube/analytics/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/youtube/analytics/v1/";

    public YouTubeAnalytics(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    YouTubeAnalytics(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public BatchReportDefinitions batchReportDefinitions() {
        return new BatchReportDefinitions();
    }

    public BatchReports batchReports() {
        return new BatchReports();
    }

    public GroupItems groupItems() {
        return new GroupItems();
    }

    public Groups groups() {
        return new Groups();
    }

    public Reports reports() {
        return new Reports();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the YouTube Analytics API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, YouTubeAnalytics.DEFAULT_ROOT_URL, YouTubeAnalytics.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public YouTubeAnalytics build() {
            return new YouTubeAnalytics(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setYouTubeAnalyticsRequestInitializer(YouTubeAnalyticsRequestInitializer youTubeAnalyticsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)youTubeAnalyticsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Reports {
        public Query query(String string, String string2, String string3, String string4) throws IOException {
            Query query = new Query(string, string2, string3, string4);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)query);
            return query;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends YouTubeAnalyticsRequest<ResultTable> {
            private static final String REST_PATH = "reports";
            private final Pattern IDS_PATTERN;
            private final Pattern START_DATE_PATTERN;
            private final Pattern END_DATE_PATTERN;
            private final Pattern METRICS_PATTERN;
            private final Pattern CURRENCY_PATTERN;
            private final Pattern DIMENSIONS_PATTERN;
            private final Pattern SORT_PATTERN;
            @Key
            private String ids;
            @Key(value="start-date")
            private String startDate;
            @Key(value="end-date")
            private String endDate;
            @Key
            private String metrics;
            @Key
            private String currency;
            @Key
            private String dimensions;
            @Key
            private String filters;
            @Key(value="max-results")
            private Integer maxResults;
            @Key
            private String sort;
            @Key(value="start-index")
            private Integer startIndex;

            protected Query(String string, String string2, String string3, String string4) {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, ResultTable.class);
                this.IDS_PATTERN = Pattern.compile("[a-zA-Z]+==[a-zA-Z0-9_+-]+");
                this.START_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                this.END_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                this.METRICS_PATTERN = Pattern.compile("[0-9a-zA-Z,]+");
                this.CURRENCY_PATTERN = Pattern.compile("[A-Z]{3}");
                this.DIMENSIONS_PATTERN = Pattern.compile("[0-9a-zA-Z,]+");
                this.SORT_PATTERN = Pattern.compile("[-0-9a-zA-Z,]+");
                this.ids = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter ids must be specified.");
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern [a-zA-Z]+==[a-zA-Z0-9_+-]+");
                }
                this.startDate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter startDate must be specified.");
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(string2).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.endDate = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter endDate must be specified.");
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(string3).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.metrics = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter metrics must be specified.");
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string4).matches(), (Object)"Parameter metrics must conform to the pattern [0-9a-zA-Z,]+");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Query setAlt(String string) {
                return (Query)super.setAlt(string);
            }

            public Query setFields(String string) {
                return (Query)super.setFields(string);
            }

            public Query setKey(String string) {
                return (Query)super.setKey(string);
            }

            public Query setOauthToken(String string) {
                return (Query)super.setOauthToken(string);
            }

            public Query setPrettyPrint(Boolean bl) {
                return (Query)super.setPrettyPrint(bl);
            }

            public Query setQuotaUser(String string) {
                return (Query)super.setQuotaUser(string);
            }

            public Query setUserIp(String string) {
                return (Query)super.setUserIp(string);
            }

            public String getIds() {
                return this.ids;
            }

            public Query setIds(String string) {
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern [a-zA-Z]+==[a-zA-Z0-9_+-]+");
                }
                this.ids = string;
                return this;
            }

            public String getStartDate() {
                return this.startDate;
            }

            public Query setStartDate(String string) {
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(string).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.startDate = string;
                return this;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public Query setEndDate(String string) {
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(string).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.endDate = string;
                return this;
            }

            public String getMetrics() {
                return this.metrics;
            }

            public Query setMetrics(String string) {
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string).matches(), (Object)"Parameter metrics must conform to the pattern [0-9a-zA-Z,]+");
                }
                this.metrics = string;
                return this;
            }

            public String getCurrency() {
                return this.currency;
            }

            public Query setCurrency(String string) {
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.CURRENCY_PATTERN.matcher(string).matches(), (Object)"Parameter currency must conform to the pattern [A-Z]{3}");
                }
                this.currency = string;
                return this;
            }

            public String getDimensions() {
                return this.dimensions;
            }

            public Query setDimensions(String string) {
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(string).matches(), (Object)"Parameter dimensions must conform to the pattern [0-9a-zA-Z,]+");
                }
                this.dimensions = string;
                return this;
            }

            public String getFilters() {
                return this.filters;
            }

            public Query setFilters(String string) {
                this.filters = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Query setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getSort() {
                return this.sort;
            }

            public Query setSort(String string) {
                if (!YouTubeAnalytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(string).matches(), (Object)"Parameter sort must conform to the pattern [-0-9a-zA-Z,]+");
                }
                this.sort = string;
                return this;
            }

            public Integer getStartIndex() {
                return this.startIndex;
            }

            public Query setStartIndex(Integer n) {
                this.startIndex = n;
                return this;
            }

            @Override
            public Query set(String string, Object object) {
                return (Query)super.set(string, object);
            }
        }
    }

    public class Groups {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(Group group) throws IOException {
            Insert insert = new Insert(group);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(Group group) throws IOException {
            Update update = new Update(group);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeAnalyticsRequest<Group> {
            private static final String REST_PATH = "groups";
            @Key
            private String onBehalfOfContentOwner;

            protected Update(Group group) {
                super(YouTubeAnalytics.this, "PUT", REST_PATH, (Object)group, Group.class);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeAnalyticsRequest<GroupListResponse> {
            private static final String REST_PATH = "groups";
            @Key
            private String id;
            @Key
            private Boolean mine;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String pageToken;

            protected List() {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, GroupListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeAnalyticsRequest<Group> {
            private static final String REST_PATH = "groups";
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(Group group) {
                super(YouTubeAnalytics.this, "POST", REST_PATH, (Object)group, Group.class);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeAnalyticsRequest<Void> {
            private static final String REST_PATH = "groups";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String string) {
                super(YouTubeAnalytics.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class GroupItems {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(GroupItem groupItem) throws IOException {
            Insert insert = new Insert(groupItem);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeAnalyticsRequest<GroupItemListResponse> {
            private static final String REST_PATH = "groupItems";
            @Key
            private String groupId;
            @Key
            private String onBehalfOfContentOwner;

            protected List(String string) {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, GroupItemListResponse.class);
                this.groupId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getGroupId() {
                return this.groupId;
            }

            public List setGroupId(String string) {
                this.groupId = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeAnalyticsRequest<GroupItem> {
            private static final String REST_PATH = "groupItems";
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(GroupItem groupItem) {
                super(YouTubeAnalytics.this, "POST", REST_PATH, (Object)groupItem, GroupItem.class);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeAnalyticsRequest<Void> {
            private static final String REST_PATH = "groupItems";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String string) {
                super(YouTubeAnalytics.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class BatchReports {
        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeAnalyticsRequest<BatchReportList> {
            private static final String REST_PATH = "batchReports";
            @Key
            private String batchReportDefinitionId;
            @Key
            private String onBehalfOfContentOwner;

            protected List(String string, String string2) {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, BatchReportList.class);
                this.batchReportDefinitionId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter batchReportDefinitionId must be specified.");
                this.onBehalfOfContentOwner = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter onBehalfOfContentOwner must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBatchReportDefinitionId() {
                return this.batchReportDefinitionId;
            }

            public List setBatchReportDefinitionId(String string) {
                this.batchReportDefinitionId = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class BatchReportDefinitions {
        public List list(String string) throws IOException {
            List list = new List(string);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeAnalyticsRequest<BatchReportDefinitionList> {
            private static final String REST_PATH = "batchReportDefinitions";
            @Key
            private String onBehalfOfContentOwner;

            protected List(String string) {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, BatchReportDefinitionList.class);
                this.onBehalfOfContentOwner = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter onBehalfOfContentOwner must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }
}

