/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-04 15:59:39 UTC)
 * on 2016-05-18 at 04:50:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtubeAnalytics.model;

/**
 * A paginated list of batchReportDefinition resources returned in response to a
 * youtubeAnalytics.batchReportDefinitions.list request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Analytics API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchReportDefinitionList extends com.google.api.client.json.GenericJson {

  /**
   * A list of batchReportDefinition resources that match the request criteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BatchReportDefinition> items;

  static {
    // hack to force ProGuard to consider BatchReportDefinition used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BatchReportDefinition.class);
  }

  /**
   * This value specifies the type of data included in the API response. For the list method, the
   * kind property value is youtubeAnalytics#batchReportDefinitionList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A list of batchReportDefinition resources that match the request criteria.
   * @return value or {@code null} for none
   */
  public java.util.List<BatchReportDefinition> getItems() {
    return items;
  }

  /**
   * A list of batchReportDefinition resources that match the request criteria.
   * @param items items or {@code null} for none
   */
  public BatchReportDefinitionList setItems(java.util.List<BatchReportDefinition> items) {
    this.items = items;
    return this;
  }

  /**
   * This value specifies the type of data included in the API response. For the list method, the
   * kind property value is youtubeAnalytics#batchReportDefinitionList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This value specifies the type of data included in the API response. For the list method, the
   * kind property value is youtubeAnalytics#batchReportDefinitionList.
   * @param kind kind or {@code null} for none
   */
  public BatchReportDefinitionList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public BatchReportDefinitionList set(String fieldName, Object value) {
    return (BatchReportDefinitionList) super.set(fieldName, value);
  }

  @Override
  public BatchReportDefinitionList clone() {
    return (BatchReportDefinitionList) super.clone();
  }

}
