/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-04 15:59:39 UTC)
 * on 2016-05-18 at 04:50:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtubeAnalytics.model;

/**
 * Contains single batchReport resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Analytics API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchReport extends com.google.api.client.json.GenericJson {

  /**
   * The ID that YouTube assigns and uses to uniquely identify the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * This value specifies the type of data of this item. For batch report the kind property value is
   * youtubeAnalytics#batchReport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Report outputs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Outputs> outputs;

  static {
    // hack to force ProGuard to consider Outputs used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Outputs.class);
  }

  /**
   * The ID of the the report definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportId;

  /**
   * Period included in the report. For reports containing all entities endTime is not set. Both
   * startTime and endTime are inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeSpan timeSpan;

  /**
   * The time when the report was updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeUpdated;

  /**
   * The ID that YouTube assigns and uses to uniquely identify the report.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube assigns and uses to uniquely identify the report.
   * @param id id or {@code null} for none
   */
  public BatchReport setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * This value specifies the type of data of this item. For batch report the kind property value is
   * youtubeAnalytics#batchReport.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This value specifies the type of data of this item. For batch report the kind property value is
   * youtubeAnalytics#batchReport.
   * @param kind kind or {@code null} for none
   */
  public BatchReport setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Report outputs.
   * @return value or {@code null} for none
   */
  public java.util.List<Outputs> getOutputs() {
    return outputs;
  }

  /**
   * Report outputs.
   * @param outputs outputs or {@code null} for none
   */
  public BatchReport setOutputs(java.util.List<Outputs> outputs) {
    this.outputs = outputs;
    return this;
  }

  /**
   * The ID of the the report definition.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportId() {
    return reportId;
  }

  /**
   * The ID of the the report definition.
   * @param reportId reportId or {@code null} for none
   */
  public BatchReport setReportId(java.lang.String reportId) {
    this.reportId = reportId;
    return this;
  }

  /**
   * Period included in the report. For reports containing all entities endTime is not set. Both
   * startTime and endTime are inclusive.
   * @return value or {@code null} for none
   */
  public TimeSpan getTimeSpan() {
    return timeSpan;
  }

  /**
   * Period included in the report. For reports containing all entities endTime is not set. Both
   * startTime and endTime are inclusive.
   * @param timeSpan timeSpan or {@code null} for none
   */
  public BatchReport setTimeSpan(TimeSpan timeSpan) {
    this.timeSpan = timeSpan;
    return this;
  }

  /**
   * The time when the report was updated.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeUpdated() {
    return timeUpdated;
  }

  /**
   * The time when the report was updated.
   * @param timeUpdated timeUpdated or {@code null} for none
   */
  public BatchReport setTimeUpdated(com.google.api.client.util.DateTime timeUpdated) {
    this.timeUpdated = timeUpdated;
    return this;
  }

  @Override
  public BatchReport set(String fieldName, Object value) {
    return (BatchReport) super.set(fieldName, value);
  }

  @Override
  public BatchReport clone() {
    return (BatchReport) super.clone();
  }

  /**
   * Model definition for BatchReportOutputs.
   */
  public static final class Outputs extends com.google.api.client.json.GenericJson {

    /**
     * Cloud storage URL to download this report. This URL is valid for 30 minutes.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String downloadUrl;

    /**
     * Format of the output.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String format;

    /**
     * Type of the output.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Cloud storage URL to download this report. This URL is valid for 30 minutes.
     * @return value or {@code null} for none
     */
    public java.lang.String getDownloadUrl() {
      return downloadUrl;
    }

    /**
     * Cloud storage URL to download this report. This URL is valid for 30 minutes.
     * @param downloadUrl downloadUrl or {@code null} for none
     */
    public Outputs setDownloadUrl(java.lang.String downloadUrl) {
      this.downloadUrl = downloadUrl;
      return this;
    }

    /**
     * Format of the output.
     * @return value or {@code null} for none
     */
    public java.lang.String getFormat() {
      return format;
    }

    /**
     * Format of the output.
     * @param format format or {@code null} for none
     */
    public Outputs setFormat(java.lang.String format) {
      this.format = format;
      return this;
    }

    /**
     * Type of the output.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Type of the output.
     * @param type type or {@code null} for none
     */
    public Outputs setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public Outputs set(String fieldName, Object value) {
      return (Outputs) super.set(fieldName, value);
    }

    @Override
    public Outputs clone() {
      return (Outputs) super.clone();
    }

  }

  /**
   * Period included in the report. For reports containing all entities endTime is not set. Both
   * startTime and endTime are inclusive.
   */
  public static final class TimeSpan extends com.google.api.client.json.GenericJson {

    /**
     * End of the period included in the report. Inclusive. For reports containing all entities
     * endTime is not set.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private com.google.api.client.util.DateTime endTime;

    /**
     * Start of the period included in the report. Inclusive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private com.google.api.client.util.DateTime startTime;

    /**
     * End of the period included in the report. Inclusive. For reports containing all entities
     * endTime is not set.
     * @return value or {@code null} for none
     */
    public com.google.api.client.util.DateTime getEndTime() {
      return endTime;
    }

    /**
     * End of the period included in the report. Inclusive. For reports containing all entities
     * endTime is not set.
     * @param endTime endTime or {@code null} for none
     */
    public TimeSpan setEndTime(com.google.api.client.util.DateTime endTime) {
      this.endTime = endTime;
      return this;
    }

    /**
     * Start of the period included in the report. Inclusive.
     * @return value or {@code null} for none
     */
    public com.google.api.client.util.DateTime getStartTime() {
      return startTime;
    }

    /**
     * Start of the period included in the report. Inclusive.
     * @param startTime startTime or {@code null} for none
     */
    public TimeSpan setStartTime(com.google.api.client.util.DateTime startTime) {
      this.startTime = startTime;
      return this;
    }

    @Override
    public TimeSpan set(String fieldName, Object value) {
      return (TimeSpan) super.set(fieldName, value);
    }

    @Override
    public TimeSpan clone() {
      return (TimeSpan) super.clone();
    }

  }

}
