/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * The payload of a single user-defined object context.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ObjectCustomContextPayload extends com.google.api.client.json.GenericJson {

  /**
   * The time at which the object context was created in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createTime;

  /**
   * The time at which the object context was last updated in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updateTime;

  /**
   * The value of the object context.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The time at which the object context was created in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreateTime() {
    return createTime;
  }

  /**
   * The time at which the object context was created in RFC 3339 format.
   * @param createTime createTime or {@code null} for none
   */
  public ObjectCustomContextPayload setCreateTime(com.google.api.client.util.DateTime createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The time at which the object context was last updated in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdateTime() {
    return updateTime;
  }

  /**
   * The time at which the object context was last updated in RFC 3339 format.
   * @param updateTime updateTime or {@code null} for none
   */
  public ObjectCustomContextPayload setUpdateTime(com.google.api.client.util.DateTime updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  /**
   * The value of the object context.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value of the object context.
   * @param value value or {@code null} for none
   */
  public ObjectCustomContextPayload setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public ObjectCustomContextPayload set(String fieldName, Object value) {
    return (ObjectCustomContextPayload) super.set(fieldName, value);
  }

  @Override
  public ObjectCustomContextPayload clone() {
    return (ObjectCustomContextPayload) super.clone();
  }

}
