/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Configuration for a BigQuery subscription.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BigQueryConfig extends com.google.api.client.json.GenericJson {

  /**
   * When true and use_topic_schema is true, any fields that are a part of the topic schema that are
   * not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the
   * schemas must be kept in sync and any messages with extra fields are not written and remain in
   * the subscription's backlog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dropUnknownFields;

  /**
   * Output only. An output-only field that indicates whether or not the subscription can receive
   * messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String table;

  /**
   * When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useTopicSchema;

  /**
   * When true, write the subscription name, message_id, publish_time, attributes, and ordering_key
   * to additional columns in the table. The subscription name, message_id, and publish_time fields
   * are put in their own columns while all other message properties (other than data) are written
   * to a JSON object in the attributes column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writeMetadata;

  /**
   * When true and use_topic_schema is true, any fields that are a part of the topic schema that are
   * not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the
   * schemas must be kept in sync and any messages with extra fields are not written and remain in
   * the subscription's backlog.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDropUnknownFields() {
    return dropUnknownFields;
  }

  /**
   * When true and use_topic_schema is true, any fields that are a part of the topic schema that are
   * not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the
   * schemas must be kept in sync and any messages with extra fields are not written and remain in
   * the subscription's backlog.
   * @param dropUnknownFields dropUnknownFields or {@code null} for none
   */
  public BigQueryConfig setDropUnknownFields(java.lang.Boolean dropUnknownFields) {
    this.dropUnknownFields = dropUnknownFields;
    return this;
  }

  /**
   * Output only. An output-only field that indicates whether or not the subscription can receive
   * messages.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. An output-only field that indicates whether or not the subscription can receive
   * messages.
   * @param state state or {@code null} for none
   */
  public BigQueryConfig setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
   * @return value or {@code null} for none
   */
  public java.lang.String getTable() {
    return table;
  }

  /**
   * The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
   * @param table table or {@code null} for none
   */
  public BigQueryConfig setTable(java.lang.String table) {
    this.table = table;
    return this;
  }

  /**
   * When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseTopicSchema() {
    return useTopicSchema;
  }

  /**
   * When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
   * @param useTopicSchema useTopicSchema or {@code null} for none
   */
  public BigQueryConfig setUseTopicSchema(java.lang.Boolean useTopicSchema) {
    this.useTopicSchema = useTopicSchema;
    return this;
  }

  /**
   * When true, write the subscription name, message_id, publish_time, attributes, and ordering_key
   * to additional columns in the table. The subscription name, message_id, and publish_time fields
   * are put in their own columns while all other message properties (other than data) are written
   * to a JSON object in the attributes column.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWriteMetadata() {
    return writeMetadata;
  }

  /**
   * When true, write the subscription name, message_id, publish_time, attributes, and ordering_key
   * to additional columns in the table. The subscription name, message_id, and publish_time fields
   * are put in their own columns while all other message properties (other than data) are written
   * to a JSON object in the attributes column.
   * @param writeMetadata writeMetadata or {@code null} for none
   */
  public BigQueryConfig setWriteMetadata(java.lang.Boolean writeMetadata) {
    this.writeMetadata = writeMetadata;
    return this;
  }

  @Override
  public BigQueryConfig set(String fieldName, Object value) {
    return (BigQueryConfig) super.set(fieldName, value);
  }

  @Override
  public BigQueryConfig clone() {
    return (BigQueryConfig) super.clone();
  }

}
