/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub;

/**
 * Service definition for Pubsub (v1).
 *
 * <p>
 * Provides reliable, many-to-many, asynchronous messaging between applications. 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/pubsub/docs" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link PubsubRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Pubsub extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Cloud Pub/Sub API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://pubsub.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://pubsub.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Pubsub(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Pubsub(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Pubsub pubsub = new Pubsub(...);}
   *   {@code Pubsub.Projects.List request = pubsub.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Schemas collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Pubsub pubsub = new Pubsub(...);}
     *   {@code Pubsub.Schemas.List request = pubsub.schemas().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Schemas schemas() {
      return new Schemas();
    }

    /**
     * The "schemas" collection of methods.
     */
    public class Schemas {

      /**
       * Creates a schema.
       *
       * Create a request for the method "schemas.create".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The name of the project in which to create the schema. Format is `projects/{project-id}`.
       * @param content the {@link com.google.api.services.pubsub.model.Schema}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.pubsub.model.Schema content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends PubsubRequest<com.google.api.services.pubsub.model.Schema> {

        private static final String REST_PATH = "v1/{+parent}/schemas";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a schema.
         *
         * Create a request for the method "schemas.create".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The name of the project in which to create the schema. Format is `projects/{project-id}`.
         * @param content the {@link com.google.api.services.pubsub.model.Schema}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.pubsub.model.Schema content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Schema.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the project in which to create the schema. Format is `projects
         * /{project-id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The name of the project in which to create the schema. Format is `projects/{project-id}`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The name of the project in which to create the schema. Format is `projects
         * /{project-id}`.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The ID to use for the schema, which will become the final component of the schema's
         * resource name. See https://cloud.google.com/pubsub/docs/admin#resource_names for resource
         * name constraints.
         */
        @com.google.api.client.util.Key
        private java.lang.String schemaId;

        /** The ID to use for the schema, which will become the final component of the schema's resource name.
       See https://cloud.google.com/pubsub/docs/admin#resource_names for resource name constraints.
         */
        public java.lang.String getSchemaId() {
          return schemaId;
        }

        /**
         * The ID to use for the schema, which will become the final component of the schema's
         * resource name. See https://cloud.google.com/pubsub/docs/admin#resource_names for resource
         * name constraints.
         */
        public Create setSchemaId(java.lang.String schemaId) {
          this.schemaId = schemaId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a schema.
       *
       * Create a request for the method "schemas.delete".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. Name of the schema to delete. Format is `projects/{project}/schemas/{schema}`.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/schemas/[^/]+$");

        /**
         * Deletes a schema.
         *
         * Create a request for the method "schemas.delete".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Name of the schema to delete. Format is `projects/{project}/schemas/{schema}`.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Pubsub.this, "DELETE", REST_PATH, null, com.google.api.services.pubsub.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Name of the schema to delete. Format is `projects/{project}/schemas/{schema}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Name of the schema to delete. Format is `projects/{project}/schemas/{schema}`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Name of the schema to delete. Format is `projects/{project}/schemas/{schema}`.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a schema.
       *
       * Create a request for the method "schemas.get".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the schema to get. Format is `projects/{project}/schemas/{schema}`.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PubsubRequest<com.google.api.services.pubsub.model.Schema> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/schemas/[^/]+$");

        /**
         * Gets a schema.
         *
         * Create a request for the method "schemas.get".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the schema to get. Format is `projects/{project}/schemas/{schema}`.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Schema.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the schema to get. Format is `projects/{project}/schemas/{schema}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the schema to get. Format is `projects/{project}/schemas/{schema}`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the schema to get. Format is `projects/{project}/schemas/{schema}`.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * The set of fields to return in the response. If not set, returns a Schema with all fields
         * filled out. Set to `BASIC` to omit the `definition`.
         */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** The set of fields to return in the response. If not set, returns a Schema with all fields filled
       out. Set to `BASIC` to omit the `definition`.
         */
        public java.lang.String getView() {
          return view;
        }

        /**
         * The set of fields to return in the response. If not set, returns a Schema with all fields
         * filled out. Set to `BASIC` to omit the `definition`.
         */
        public Get setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "schemas.getIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/schemas/[^/]+$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "schemas.getIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        @com.google.api.client.util.Key("options.requestedPolicyVersion")
        private java.lang.Integer optionsRequestedPolicyVersion;

        /** Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1,
       and 3. Requests specifying an invalid value will be rejected. Requests for policies with any
       conditional role bindings must specify version 3. Policies with no conditional role bindings may
       specify any valid value or leave the field unset. The policy in the response might use the policy
       version that you specified, or it might use a lower policy version. For example, if you specify
       version 3, but the policy has no conditional role bindings, the response uses version 1. To learn
       which resources support conditions in their IAM policies, see the [IAM
       documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public java.lang.Integer getOptionsRequestedPolicyVersion() {
          return optionsRequestedPolicyVersion;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
          this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists schemas in a project.
       *
       * Create a request for the method "schemas.list".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The name of the project in which to list schemas. Format is `projects/{project-id}`.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListSchemasResponse> {

        private static final String REST_PATH = "v1/{+parent}/schemas";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists schemas in a project.
         *
         * Create a request for the method "schemas.list".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The name of the project in which to list schemas. Format is `projects/{project-id}`.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListSchemasResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the project in which to list schemas. Format is `projects/{project-
         * id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The name of the project in which to list schemas. Format is `projects/{project-id}`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The name of the project in which to list schemas. Format is `projects/{project-
         * id}`.
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /** Maximum number of schemas to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Maximum number of schemas to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Maximum number of schemas to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * The value returned by the last `ListSchemasResponse`; indicates that this is a
         * continuation of a prior `ListSchemas` call, and that the system should return the next
         * page of data.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The value returned by the last `ListSchemasResponse`; indicates that this is a continuation of a
       prior `ListSchemas` call, and that the system should return the next page of data.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The value returned by the last `ListSchemasResponse`; indicates that this is a
         * continuation of a prior `ListSchemas` call, and that the system should return the next
         * page of data.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * The set of Schema fields to return in the response. If not set, returns Schemas with
         * `name` and `type`, but not `definition`. Set to `FULL` to retrieve all fields.
         */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** The set of Schema fields to return in the response. If not set, returns Schemas with `name` and
       `type`, but not `definition`. Set to `FULL` to retrieve all fields.
         */
        public java.lang.String getView() {
          return view;
        }

        /**
         * The set of Schema fields to return in the response. If not set, returns Schemas with
         * `name` and `type`, but not `definition`. Set to `FULL` to retrieve all fields.
         */
        public List setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "schemas.setIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/schemas/[^/]+$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "schemas.setIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
       * designed to be used for building permission-aware UIs and command-line tools, not for
       * authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "schemas.testIamPermissions".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends PubsubRequest<com.google.api.services.pubsub.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/schemas/[^/]+$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
         * operation is designed to be used for building permission-aware UIs and command-line tools, not
         * for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "schemas.testIamPermissions".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/schemas/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }
      /**
       * Validates a schema.
       *
       * Create a request for the method "schemas.validate".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Validate#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The name of the project in which to validate schemas. Format is `projects/{project-id}`.
       * @param content the {@link com.google.api.services.pubsub.model.ValidateSchemaRequest}
       * @return the request
       */
      public Validate validate(java.lang.String parent, com.google.api.services.pubsub.model.ValidateSchemaRequest content) throws java.io.IOException {
        Validate result = new Validate(parent, content);
        initialize(result);
        return result;
      }

      public class Validate extends PubsubRequest<com.google.api.services.pubsub.model.ValidateSchemaResponse> {

        private static final String REST_PATH = "v1/{+parent}/schemas:validate";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Validates a schema.
         *
         * Create a request for the method "schemas.validate".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Validate#execute()} method to invoke the remote operation. <p>
         * {@link
         * Validate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The name of the project in which to validate schemas. Format is `projects/{project-id}`.
         * @param content the {@link com.google.api.services.pubsub.model.ValidateSchemaRequest}
         * @since 1.13
         */
        protected Validate(java.lang.String parent, com.google.api.services.pubsub.model.ValidateSchemaRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.ValidateSchemaResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Validate set$Xgafv(java.lang.String $Xgafv) {
          return (Validate) super.set$Xgafv($Xgafv);
        }

        @Override
        public Validate setAccessToken(java.lang.String accessToken) {
          return (Validate) super.setAccessToken(accessToken);
        }

        @Override
        public Validate setAlt(java.lang.String alt) {
          return (Validate) super.setAlt(alt);
        }

        @Override
        public Validate setCallback(java.lang.String callback) {
          return (Validate) super.setCallback(callback);
        }

        @Override
        public Validate setFields(java.lang.String fields) {
          return (Validate) super.setFields(fields);
        }

        @Override
        public Validate setKey(java.lang.String key) {
          return (Validate) super.setKey(key);
        }

        @Override
        public Validate setOauthToken(java.lang.String oauthToken) {
          return (Validate) super.setOauthToken(oauthToken);
        }

        @Override
        public Validate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Validate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Validate setQuotaUser(java.lang.String quotaUser) {
          return (Validate) super.setQuotaUser(quotaUser);
        }

        @Override
        public Validate setUploadType(java.lang.String uploadType) {
          return (Validate) super.setUploadType(uploadType);
        }

        @Override
        public Validate setUploadProtocol(java.lang.String uploadProtocol) {
          return (Validate) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the project in which to validate schemas. Format is `projects
         * /{project-id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The name of the project in which to validate schemas. Format is `projects/{project-id}`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The name of the project in which to validate schemas. Format is `projects
         * /{project-id}`.
         */
        public Validate setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Validate set(String parameterName, Object value) {
          return (Validate) super.set(parameterName, value);
        }
      }
      /**
       * Validates a message against a schema.
       *
       * Create a request for the method "schemas.validateMessage".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link ValidateMessage#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The name of the project in which to validate schemas. Format is `projects/{project-id}`.
       * @param content the {@link com.google.api.services.pubsub.model.ValidateMessageRequest}
       * @return the request
       */
      public ValidateMessage validateMessage(java.lang.String parent, com.google.api.services.pubsub.model.ValidateMessageRequest content) throws java.io.IOException {
        ValidateMessage result = new ValidateMessage(parent, content);
        initialize(result);
        return result;
      }

      public class ValidateMessage extends PubsubRequest<com.google.api.services.pubsub.model.ValidateMessageResponse> {

        private static final String REST_PATH = "v1/{+parent}/schemas:validateMessage";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Validates a message against a schema.
         *
         * Create a request for the method "schemas.validateMessage".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link ValidateMessage#execute()} method to invoke the remote operation.
         * <p> {@link ValidateMessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
         * lientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param parent Required. The name of the project in which to validate schemas. Format is `projects/{project-id}`.
         * @param content the {@link com.google.api.services.pubsub.model.ValidateMessageRequest}
         * @since 1.13
         */
        protected ValidateMessage(java.lang.String parent, com.google.api.services.pubsub.model.ValidateMessageRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.ValidateMessageResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public ValidateMessage set$Xgafv(java.lang.String $Xgafv) {
          return (ValidateMessage) super.set$Xgafv($Xgafv);
        }

        @Override
        public ValidateMessage setAccessToken(java.lang.String accessToken) {
          return (ValidateMessage) super.setAccessToken(accessToken);
        }

        @Override
        public ValidateMessage setAlt(java.lang.String alt) {
          return (ValidateMessage) super.setAlt(alt);
        }

        @Override
        public ValidateMessage setCallback(java.lang.String callback) {
          return (ValidateMessage) super.setCallback(callback);
        }

        @Override
        public ValidateMessage setFields(java.lang.String fields) {
          return (ValidateMessage) super.setFields(fields);
        }

        @Override
        public ValidateMessage setKey(java.lang.String key) {
          return (ValidateMessage) super.setKey(key);
        }

        @Override
        public ValidateMessage setOauthToken(java.lang.String oauthToken) {
          return (ValidateMessage) super.setOauthToken(oauthToken);
        }

        @Override
        public ValidateMessage setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (ValidateMessage) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public ValidateMessage setQuotaUser(java.lang.String quotaUser) {
          return (ValidateMessage) super.setQuotaUser(quotaUser);
        }

        @Override
        public ValidateMessage setUploadType(java.lang.String uploadType) {
          return (ValidateMessage) super.setUploadType(uploadType);
        }

        @Override
        public ValidateMessage setUploadProtocol(java.lang.String uploadProtocol) {
          return (ValidateMessage) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the project in which to validate schemas. Format is `projects
         * /{project-id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The name of the project in which to validate schemas. Format is `projects/{project-id}`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The name of the project in which to validate schemas. Format is `projects
         * /{project-id}`.
         */
        public ValidateMessage setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public ValidateMessage set(String parameterName, Object value) {
          return (ValidateMessage) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Snapshots collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Pubsub pubsub = new Pubsub(...);}
     *   {@code Pubsub.Snapshots.List request = pubsub.snapshots().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Snapshots snapshots() {
      return new Snapshots();
    }

    /**
     * The "snapshots" collection of methods.
     */
    public class Snapshots {

      /**
       * Creates a snapshot from the requested subscription. Snapshots are used in
       * [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to
       * manage message acknowledgments in bulk. That is, you can set the acknowledgment state of messages
       * in an existing subscription to the state captured by a snapshot. If the snapshot already exists,
       * returns `ALREADY_EXISTS`. If the requested subscription doesn't exist, returns `NOT_FOUND`. If
       * the backlog in the subscription is too old -- and the resulting snapshot would expire in less
       * than 1 hour -- then `FAILED_PRECONDITION` is returned. See also the `Snapshot.expire_time` field.
       * If the name is not provided in the request, the server will assign a random name for this
       * snapshot on the same project as the subscription, conforming to the [resource name format]
       * (https://cloud.google.com/pubsub/docs/admin#resource_names). The generated name is populated in
       * the returned Snapshot object. Note that for REST API requests, you must specify a name in the
       * request.
       *
       * Create a request for the method "snapshots.create".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name Required. User-provided name for this snapshot. If the name is not provided in the request, the
       *        server will assign a random name for this snapshot on the same project as the
       *        subscription. Note that for REST API requests, you must specify a name. See the [resource
       *        name rules](https://cloud.google.com/pubsub/docs/admin#resource_names). Format is
       *        `projects/{project}/snapshots/{snap}`.
       * @param content the {@link com.google.api.services.pubsub.model.CreateSnapshotRequest}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.pubsub.model.CreateSnapshotRequest content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends PubsubRequest<com.google.api.services.pubsub.model.Snapshot> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Creates a snapshot from the requested subscription. Snapshots are used in
         * [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to
         * manage message acknowledgments in bulk. That is, you can set the acknowledgment state of
         * messages in an existing subscription to the state captured by a snapshot. If the snapshot
         * already exists, returns `ALREADY_EXISTS`. If the requested subscription doesn't exist, returns
         * `NOT_FOUND`. If the backlog in the subscription is too old -- and the resulting snapshot would
         * expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned. See also the
         * `Snapshot.expire_time` field. If the name is not provided in the request, the server will
         * assign a random name for this snapshot on the same project as the subscription, conforming to
         * the [resource name format] (https://cloud.google.com/pubsub/docs/admin#resource_names). The
         * generated name is populated in the returned Snapshot object. Note that for REST API requests,
         * you must specify a name in the request.
         *
         * Create a request for the method "snapshots.create".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. User-provided name for this snapshot. If the name is not provided in the request, the
       *        server will assign a random name for this snapshot on the same project as the
       *        subscription. Note that for REST API requests, you must specify a name. See the [resource
       *        name rules](https://cloud.google.com/pubsub/docs/admin#resource_names). Format is
       *        `projects/{project}/snapshots/{snap}`.
         * @param content the {@link com.google.api.services.pubsub.model.CreateSnapshotRequest}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.pubsub.model.CreateSnapshotRequest content) {
          super(Pubsub.this, "PUT", REST_PATH, content, com.google.api.services.pubsub.model.Snapshot.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. User-provided name for this snapshot. If the name is not provided in the
         * request, the server will assign a random name for this snapshot on the same project as
         * the subscription. Note that for REST API requests, you must specify a name. See the
         * [resource name rules](https://cloud.google.com/pubsub/docs/admin#resource_names). Format
         * is `projects/{project}/snapshots/{snap}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. User-provided name for this snapshot. If the name is not provided in the request, the
       server will assign a random name for this snapshot on the same project as the subscription. Note
       that for REST API requests, you must specify a name. See the [resource name
       rules](https://cloud.google.com/pubsub/docs/admin#resource_names). Format is
       `projects/{project}/snapshots/{snap}`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. User-provided name for this snapshot. If the name is not provided in the
         * request, the server will assign a random name for this snapshot on the same project as
         * the subscription. Note that for REST API requests, you must specify a name. See the
         * [resource name rules](https://cloud.google.com/pubsub/docs/admin#resource_names). Format
         * is `projects/{project}/snapshots/{snap}`.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Removes an existing snapshot. Snapshots are used in [Seek] (https://cloud.google.com/pubsub/docs
       * /replay-overview) operations, which allow you to manage message acknowledgments in bulk. That is,
       * you can set the acknowledgment state of messages in an existing subscription to the state
       * captured by a snapshot. When the snapshot is deleted, all messages retained in the snapshot are
       * immediately dropped. After a snapshot is deleted, a new one may be created with the same name,
       * but the new one has no association with the old snapshot or its subscription, unless the same
       * subscription is specified.
       *
       * Create a request for the method "snapshots.delete".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param snapshot Required. The name of the snapshot to delete. Format is `projects/{project}/snapshots/{snap}`.
       * @return the request
       */
      public Delete delete(java.lang.String snapshot) throws java.io.IOException {
        Delete result = new Delete(snapshot);
        initialize(result);
        return result;
      }

      public class Delete extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+snapshot}";

        private final java.util.regex.Pattern SNAPSHOT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Removes an existing snapshot. Snapshots are used in [Seek]
         * (https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to manage
         * message acknowledgments in bulk. That is, you can set the acknowledgment state of messages in
         * an existing subscription to the state captured by a snapshot. When the snapshot is deleted, all
         * messages retained in the snapshot are immediately dropped. After a snapshot is deleted, a new
         * one may be created with the same name, but the new one has no association with the old snapshot
         * or its subscription, unless the same subscription is specified.
         *
         * Create a request for the method "snapshots.delete".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param snapshot Required. The name of the snapshot to delete. Format is `projects/{project}/snapshots/{snap}`.
         * @since 1.13
         */
        protected Delete(java.lang.String snapshot) {
          super(Pubsub.this, "DELETE", REST_PATH, null, com.google.api.services.pubsub.model.Empty.class);
          this.snapshot = com.google.api.client.util.Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
                "Parameter snapshot must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the snapshot to delete. Format is
         * `projects/{project}/snapshots/{snap}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String snapshot;

        /** Required. The name of the snapshot to delete. Format is `projects/{project}/snapshots/{snap}`.
         */
        public java.lang.String getSnapshot() {
          return snapshot;
        }

        /**
         * Required. The name of the snapshot to delete. Format is
         * `projects/{project}/snapshots/{snap}`.
         */
        public Delete setSnapshot(java.lang.String snapshot) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
                "Parameter snapshot must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.snapshot = snapshot;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the configuration details of a snapshot. Snapshots are used in
       * [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to
       * manage message acknowledgments in bulk. That is, you can set the acknowledgment state of messages
       * in an existing subscription to the state captured by a snapshot.
       *
       * Create a request for the method "snapshots.get".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param snapshot Required. The name of the snapshot to get. Format is `projects/{project}/snapshots/{snap}`.
       * @return the request
       */
      public Get get(java.lang.String snapshot) throws java.io.IOException {
        Get result = new Get(snapshot);
        initialize(result);
        return result;
      }

      public class Get extends PubsubRequest<com.google.api.services.pubsub.model.Snapshot> {

        private static final String REST_PATH = "v1/{+snapshot}";

        private final java.util.regex.Pattern SNAPSHOT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Gets the configuration details of a snapshot. Snapshots are used in
         * [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to
         * manage message acknowledgments in bulk. That is, you can set the acknowledgment state of
         * messages in an existing subscription to the state captured by a snapshot.
         *
         * Create a request for the method "snapshots.get".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param snapshot Required. The name of the snapshot to get. Format is `projects/{project}/snapshots/{snap}`.
         * @since 1.13
         */
        protected Get(java.lang.String snapshot) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Snapshot.class);
          this.snapshot = com.google.api.client.util.Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
                "Parameter snapshot must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the snapshot to get. Format is
         * `projects/{project}/snapshots/{snap}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String snapshot;

        /** Required. The name of the snapshot to get. Format is `projects/{project}/snapshots/{snap}`.
         */
        public java.lang.String getSnapshot() {
          return snapshot;
        }

        /**
         * Required. The name of the snapshot to get. Format is
         * `projects/{project}/snapshots/{snap}`.
         */
        public Get setSnapshot(java.lang.String snapshot) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
                "Parameter snapshot must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.snapshot = snapshot;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "snapshots.getIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "snapshots.getIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        @com.google.api.client.util.Key("options.requestedPolicyVersion")
        private java.lang.Integer optionsRequestedPolicyVersion;

        /** Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1,
       and 3. Requests specifying an invalid value will be rejected. Requests for policies with any
       conditional role bindings must specify version 3. Policies with no conditional role bindings may
       specify any valid value or leave the field unset. The policy in the response might use the policy
       version that you specified, or it might use a lower policy version. For example, if you specify
       version 3, but the policy has no conditional role bindings, the response uses version 1. To learn
       which resources support conditions in their IAM policies, see the [IAM
       documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public java.lang.Integer getOptionsRequestedPolicyVersion() {
          return optionsRequestedPolicyVersion;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
          this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists the existing snapshots. Snapshots are used in [Seek]( https://cloud.google.com/pubsub/docs
       * /replay-overview) operations, which allow you to manage message acknowledgments in bulk. That is,
       * you can set the acknowledgment state of messages in an existing subscription to the state
       * captured by a snapshot.
       *
       * Create a request for the method "snapshots.list".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param project Required. The name of the project in which to list snapshots. Format is `projects/{project-id}`.
       * @return the request
       */
      public List list(java.lang.String project) throws java.io.IOException {
        List result = new List(project);
        initialize(result);
        return result;
      }

      public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListSnapshotsResponse> {

        private static final String REST_PATH = "v1/{+project}/snapshots";

        private final java.util.regex.Pattern PROJECT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists the existing snapshots. Snapshots are used in [Seek](
         * https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to manage
         * message acknowledgments in bulk. That is, you can set the acknowledgment state of messages in
         * an existing subscription to the state captured by a snapshot.
         *
         * Create a request for the method "snapshots.list".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param project Required. The name of the project in which to list snapshots. Format is `projects/{project-id}`.
         * @since 1.13
         */
        protected List(java.lang.String project) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListSnapshotsResponse.class);
          this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the project in which to list snapshots. Format is `projects
         * /{project-id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String project;

        /** Required. The name of the project in which to list snapshots. Format is `projects/{project-id}`.
         */
        public java.lang.String getProject() {
          return project;
        }

        /**
         * Required. The name of the project in which to list snapshots. Format is `projects
         * /{project-id}`.
         */
        public List setProject(java.lang.String project) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.project = project;
          return this;
        }

        /** Maximum number of snapshots to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Maximum number of snapshots to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Maximum number of snapshots to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * The value returned by the last `ListSnapshotsResponse`; indicates that this is a
         * continuation of a prior `ListSnapshots` call, and that the system should return the next
         * page of data.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The value returned by the last `ListSnapshotsResponse`; indicates that this is a continuation of a
       prior `ListSnapshots` call, and that the system should return the next page of data.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The value returned by the last `ListSnapshotsResponse`; indicates that this is a
         * continuation of a prior `ListSnapshots` call, and that the system should return the next
         * page of data.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing snapshot. Snapshots are used in [Seek](https://cloud.google.com/pubsub/docs
       * /replay-overview) operations, which allow you to manage message acknowledgments in bulk. That is,
       * you can set the acknowledgment state of messages in an existing subscription to the state
       * captured by a snapshot.
       *
       * Create a request for the method "snapshots.patch".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The name of the snapshot.
       * @param content the {@link com.google.api.services.pubsub.model.UpdateSnapshotRequest}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.pubsub.model.UpdateSnapshotRequest content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends PubsubRequest<com.google.api.services.pubsub.model.Snapshot> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Updates an existing snapshot. Snapshots are used in [Seek](https://cloud.google.com/pubsub/docs
         * /replay-overview) operations, which allow you to manage message acknowledgments in bulk. That
         * is, you can set the acknowledgment state of messages in an existing subscription to the state
         * captured by a snapshot.
         *
         * Create a request for the method "snapshots.patch".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the snapshot.
         * @param content the {@link com.google.api.services.pubsub.model.UpdateSnapshotRequest}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.pubsub.model.UpdateSnapshotRequest content) {
          super(Pubsub.this, "PATCH", REST_PATH, content, com.google.api.services.pubsub.model.Snapshot.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the snapshot. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the snapshot.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the snapshot. */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "snapshots.setIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "snapshots.setIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
       * designed to be used for building permission-aware UIs and command-line tools, not for
       * authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "snapshots.testIamPermissions".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends PubsubRequest<com.google.api.services.pubsub.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
         * operation is designed to be used for building permission-aware UIs and command-line tools, not
         * for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "snapshots.testIamPermissions".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Subscriptions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Pubsub pubsub = new Pubsub(...);}
     *   {@code Pubsub.Subscriptions.List request = pubsub.subscriptions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Subscriptions subscriptions() {
      return new Subscriptions();
    }

    /**
     * The "subscriptions" collection of methods.
     */
    public class Subscriptions {

      /**
       * Acknowledges the messages associated with the `ack_ids` in the `AcknowledgeRequest`. The Pub/Sub
       * system can remove the relevant messages from the subscription. Acknowledging a message whose ack
       * deadline has expired may succeed, but such a message may be redelivered later. Acknowledging a
       * message more than once will not result in an error.
       *
       * Create a request for the method "subscriptions.acknowledge".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Acknowledge#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The subscription whose message is being acknowledged. Format is
       *        `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.AcknowledgeRequest}
       * @return the request
       */
      public Acknowledge acknowledge(java.lang.String subscription, com.google.api.services.pubsub.model.AcknowledgeRequest content) throws java.io.IOException {
        Acknowledge result = new Acknowledge(subscription, content);
        initialize(result);
        return result;
      }

      public class Acknowledge extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}:acknowledge";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Acknowledges the messages associated with the `ack_ids` in the `AcknowledgeRequest`. The
         * Pub/Sub system can remove the relevant messages from the subscription. Acknowledging a message
         * whose ack deadline has expired may succeed, but such a message may be redelivered later.
         * Acknowledging a message more than once will not result in an error.
         *
         * Create a request for the method "subscriptions.acknowledge".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Acknowledge#execute()} method to invoke the remote operation. <p>
         * {@link
         * Acknowledge#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription Required. The subscription whose message is being acknowledged. Format is
       *        `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.AcknowledgeRequest}
         * @since 1.13
         */
        protected Acknowledge(java.lang.String subscription, com.google.api.services.pubsub.model.AcknowledgeRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Acknowledge set$Xgafv(java.lang.String $Xgafv) {
          return (Acknowledge) super.set$Xgafv($Xgafv);
        }

        @Override
        public Acknowledge setAccessToken(java.lang.String accessToken) {
          return (Acknowledge) super.setAccessToken(accessToken);
        }

        @Override
        public Acknowledge setAlt(java.lang.String alt) {
          return (Acknowledge) super.setAlt(alt);
        }

        @Override
        public Acknowledge setCallback(java.lang.String callback) {
          return (Acknowledge) super.setCallback(callback);
        }

        @Override
        public Acknowledge setFields(java.lang.String fields) {
          return (Acknowledge) super.setFields(fields);
        }

        @Override
        public Acknowledge setKey(java.lang.String key) {
          return (Acknowledge) super.setKey(key);
        }

        @Override
        public Acknowledge setOauthToken(java.lang.String oauthToken) {
          return (Acknowledge) super.setOauthToken(oauthToken);
        }

        @Override
        public Acknowledge setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Acknowledge) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Acknowledge setQuotaUser(java.lang.String quotaUser) {
          return (Acknowledge) super.setQuotaUser(quotaUser);
        }

        @Override
        public Acknowledge setUploadType(java.lang.String uploadType) {
          return (Acknowledge) super.setUploadType(uploadType);
        }

        @Override
        public Acknowledge setUploadProtocol(java.lang.String uploadProtocol) {
          return (Acknowledge) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The subscription whose message is being acknowledged. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The subscription whose message is being acknowledged. Format is
       `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * Required. The subscription whose message is being acknowledged. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        public Acknowledge setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Acknowledge set(String parameterName, Object value) {
          return (Acknowledge) super.set(parameterName, value);
        }
      }
      /**
       * Creates a subscription to a given topic. See the [resource name rules]
       * (https://cloud.google.com/pubsub/docs/admin#resource_names). If the subscription already exists,
       * returns `ALREADY_EXISTS`. If the corresponding topic doesn't exist, returns `NOT_FOUND`. If the
       * name is not provided in the request, the server will assign a random name for this subscription
       * on the same project as the topic, conforming to the [resource name format]
       * (https://cloud.google.com/pubsub/docs/admin#resource_names). The generated name is populated in
       * the returned Subscription object. Note that for REST API requests, you must specify a name in the
       * request.
       *
       * Create a request for the method "subscriptions.create".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the subscription. It must have the format
       *        `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
       *        letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
       *        underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must
       *        be between 3 and 255 characters in length, and it must not start with `"goog"`.
       * @param content the {@link com.google.api.services.pubsub.model.Subscription}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.pubsub.model.Subscription content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends PubsubRequest<com.google.api.services.pubsub.model.Subscription> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Creates a subscription to a given topic. See the [resource name rules]
         * (https://cloud.google.com/pubsub/docs/admin#resource_names). If the subscription already
         * exists, returns `ALREADY_EXISTS`. If the corresponding topic doesn't exist, returns
         * `NOT_FOUND`. If the name is not provided in the request, the server will assign a random name
         * for this subscription on the same project as the topic, conforming to the [resource name
         * format] (https://cloud.google.com/pubsub/docs/admin#resource_names). The generated name is
         * populated in the returned Subscription object. Note that for REST API requests, you must
         * specify a name in the request.
         *
         * Create a request for the method "subscriptions.create".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the subscription. It must have the format
       *        `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
       *        letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
       *        underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must
       *        be between 3 and 255 characters in length, and it must not start with `"goog"`.
         * @param content the {@link com.google.api.services.pubsub.model.Subscription}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.pubsub.model.Subscription content) {
          super(Pubsub.this, "PUT", REST_PATH, content, com.google.api.services.pubsub.model.Subscription.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the subscription. It must have the format
         * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
         * letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
         * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
         * must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the subscription. It must have the format
       `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a letter, and
       contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`), underscores (`_`), periods
       (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters in
       length, and it must not start with `"goog"`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the subscription. It must have the format
         * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
         * letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
         * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
         * must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an existing subscription. All messages retained in the subscription are immediately
       * dropped. Calls to `Pull` after deletion will return `NOT_FOUND`. After a subscription is deleted,
       * a new one may be created with the same name, but the new one has no association with the old
       * subscription or its topic unless the same topic is specified.
       *
       * Create a request for the method "subscriptions.delete".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
       * @return the request
       */
      public Delete delete(java.lang.String subscription) throws java.io.IOException {
        Delete result = new Delete(subscription);
        initialize(result);
        return result;
      }

      public class Delete extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Deletes an existing subscription. All messages retained in the subscription are immediately
         * dropped. Calls to `Pull` after deletion will return `NOT_FOUND`. After a subscription is
         * deleted, a new one may be created with the same name, but the new one has no association with
         * the old subscription or its topic unless the same topic is specified.
         *
         * Create a request for the method "subscriptions.delete".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription Required. The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
         * @since 1.13
         */
        protected Delete(java.lang.String subscription) {
          super(Pubsub.this, "DELETE", REST_PATH, null, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * Required. The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public Delete setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Detaches a subscription from this topic. All messages retained in the subscription are dropped.
       * Subsequent `Pull` and `StreamingPull` requests will return FAILED_PRECONDITION. If the
       * subscription is a push subscription, pushes to the endpoint will stop.
       *
       * Create a request for the method "subscriptions.detach".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Detach#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The subscription to detach. Format is `projects/{project}/subscriptions/{subscription}`.
       * @return the request
       */
      public Detach detach(java.lang.String subscription) throws java.io.IOException {
        Detach result = new Detach(subscription);
        initialize(result);
        return result;
      }

      public class Detach extends PubsubRequest<com.google.api.services.pubsub.model.DetachSubscriptionResponse> {

        private static final String REST_PATH = "v1/{+subscription}:detach";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Detaches a subscription from this topic. All messages retained in the subscription are dropped.
         * Subsequent `Pull` and `StreamingPull` requests will return FAILED_PRECONDITION. If the
         * subscription is a push subscription, pushes to the endpoint will stop.
         *
         * Create a request for the method "subscriptions.detach".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Detach#execute()} method to invoke the remote operation. <p> {@link
         * Detach#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription Required. The subscription to detach. Format is `projects/{project}/subscriptions/{subscription}`.
         * @since 1.13
         */
        protected Detach(java.lang.String subscription) {
          super(Pubsub.this, "POST", REST_PATH, null, com.google.api.services.pubsub.model.DetachSubscriptionResponse.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Detach set$Xgafv(java.lang.String $Xgafv) {
          return (Detach) super.set$Xgafv($Xgafv);
        }

        @Override
        public Detach setAccessToken(java.lang.String accessToken) {
          return (Detach) super.setAccessToken(accessToken);
        }

        @Override
        public Detach setAlt(java.lang.String alt) {
          return (Detach) super.setAlt(alt);
        }

        @Override
        public Detach setCallback(java.lang.String callback) {
          return (Detach) super.setCallback(callback);
        }

        @Override
        public Detach setFields(java.lang.String fields) {
          return (Detach) super.setFields(fields);
        }

        @Override
        public Detach setKey(java.lang.String key) {
          return (Detach) super.setKey(key);
        }

        @Override
        public Detach setOauthToken(java.lang.String oauthToken) {
          return (Detach) super.setOauthToken(oauthToken);
        }

        @Override
        public Detach setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Detach) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Detach setQuotaUser(java.lang.String quotaUser) {
          return (Detach) super.setQuotaUser(quotaUser);
        }

        @Override
        public Detach setUploadType(java.lang.String uploadType) {
          return (Detach) super.setUploadType(uploadType);
        }

        @Override
        public Detach setUploadProtocol(java.lang.String uploadProtocol) {
          return (Detach) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The subscription to detach. Format is
         * `projects/{project}/subscriptions/{subscription}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The subscription to detach. Format is `projects/{project}/subscriptions/{subscription}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * Required. The subscription to detach. Format is
         * `projects/{project}/subscriptions/{subscription}`.
         */
        public Detach setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Detach set(String parameterName, Object value) {
          return (Detach) super.set(parameterName, value);
        }
      }
      /**
       * Gets the configuration details of a subscription.
       *
       * Create a request for the method "subscriptions.get".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The name of the subscription to get. Format is `projects/{project}/subscriptions/{sub}`.
       * @return the request
       */
      public Get get(java.lang.String subscription) throws java.io.IOException {
        Get result = new Get(subscription);
        initialize(result);
        return result;
      }

      public class Get extends PubsubRequest<com.google.api.services.pubsub.model.Subscription> {

        private static final String REST_PATH = "v1/{+subscription}";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Gets the configuration details of a subscription.
         *
         * Create a request for the method "subscriptions.get".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription Required. The name of the subscription to get. Format is `projects/{project}/subscriptions/{sub}`.
         * @since 1.13
         */
        protected Get(java.lang.String subscription) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Subscription.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the subscription to get. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The name of the subscription to get. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * Required. The name of the subscription to get. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        public Get setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "subscriptions.getIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "subscriptions.getIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        @com.google.api.client.util.Key("options.requestedPolicyVersion")
        private java.lang.Integer optionsRequestedPolicyVersion;

        /** Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1,
       and 3. Requests specifying an invalid value will be rejected. Requests for policies with any
       conditional role bindings must specify version 3. Policies with no conditional role bindings may
       specify any valid value or leave the field unset. The policy in the response might use the policy
       version that you specified, or it might use a lower policy version. For example, if you specify
       version 3, but the policy has no conditional role bindings, the response uses version 1. To learn
       which resources support conditions in their IAM policies, see the [IAM
       documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public java.lang.Integer getOptionsRequestedPolicyVersion() {
          return optionsRequestedPolicyVersion;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
          this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists matching subscriptions.
       *
       * Create a request for the method "subscriptions.list".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param project Required. The name of the project in which to list subscriptions. Format is `projects/{project-id}`.
       * @return the request
       */
      public List list(java.lang.String project) throws java.io.IOException {
        List result = new List(project);
        initialize(result);
        return result;
      }

      public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListSubscriptionsResponse> {

        private static final String REST_PATH = "v1/{+project}/subscriptions";

        private final java.util.regex.Pattern PROJECT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists matching subscriptions.
         *
         * Create a request for the method "subscriptions.list".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param project Required. The name of the project in which to list subscriptions. Format is `projects/{project-id}`.
         * @since 1.13
         */
        protected List(java.lang.String project) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListSubscriptionsResponse.class);
          this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the project in which to list subscriptions. Format is `projects
         * /{project-id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String project;

        /** Required. The name of the project in which to list subscriptions. Format is `projects/{project-
       id}`.
         */
        public java.lang.String getProject() {
          return project;
        }

        /**
         * Required. The name of the project in which to list subscriptions. Format is `projects
         * /{project-id}`.
         */
        public List setProject(java.lang.String project) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.project = project;
          return this;
        }

        /** Maximum number of subscriptions to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Maximum number of subscriptions to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Maximum number of subscriptions to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * The value returned by the last `ListSubscriptionsResponse`; indicates that this is a
         * continuation of a prior `ListSubscriptions` call, and that the system should return the
         * next page of data.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The value returned by the last `ListSubscriptionsResponse`; indicates that this is a continuation
       of a prior `ListSubscriptions` call, and that the system should return the next page of data.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The value returned by the last `ListSubscriptionsResponse`; indicates that this is a
         * continuation of a prior `ListSubscriptions` call, and that the system should return the
         * next page of data.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Modifies the ack deadline for a specific message. This method is useful to indicate that more
       * time is needed to process a message by the subscriber, or to make the message available for
       * redelivery if the processing was interrupted. Note that this does not modify the subscription-
       * level `ackDeadlineSeconds` used for subsequent messages.
       *
       * Create a request for the method "subscriptions.modifyAckDeadline".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link ModifyAckDeadline#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.ModifyAckDeadlineRequest}
       * @return the request
       */
      public ModifyAckDeadline modifyAckDeadline(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyAckDeadlineRequest content) throws java.io.IOException {
        ModifyAckDeadline result = new ModifyAckDeadline(subscription, content);
        initialize(result);
        return result;
      }

      public class ModifyAckDeadline extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}:modifyAckDeadline";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Modifies the ack deadline for a specific message. This method is useful to indicate that more
         * time is needed to process a message by the subscriber, or to make the message available for
         * redelivery if the processing was interrupted. Note that this does not modify the subscription-
         * level `ackDeadlineSeconds` used for subsequent messages.
         *
         * Create a request for the method "subscriptions.modifyAckDeadline".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link ModifyAckDeadline#execute()} method to invoke the remote operation.
         * <p> {@link ModifyAckDeadline#initialize(com.google.api.client.googleapis.services.AbstractGoogl
         * eClientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param subscription Required. The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.ModifyAckDeadlineRequest}
         * @since 1.13
         */
        protected ModifyAckDeadline(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyAckDeadlineRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public ModifyAckDeadline set$Xgafv(java.lang.String $Xgafv) {
          return (ModifyAckDeadline) super.set$Xgafv($Xgafv);
        }

        @Override
        public ModifyAckDeadline setAccessToken(java.lang.String accessToken) {
          return (ModifyAckDeadline) super.setAccessToken(accessToken);
        }

        @Override
        public ModifyAckDeadline setAlt(java.lang.String alt) {
          return (ModifyAckDeadline) super.setAlt(alt);
        }

        @Override
        public ModifyAckDeadline setCallback(java.lang.String callback) {
          return (ModifyAckDeadline) super.setCallback(callback);
        }

        @Override
        public ModifyAckDeadline setFields(java.lang.String fields) {
          return (ModifyAckDeadline) super.setFields(fields);
        }

        @Override
        public ModifyAckDeadline setKey(java.lang.String key) {
          return (ModifyAckDeadline) super.setKey(key);
        }

        @Override
        public ModifyAckDeadline setOauthToken(java.lang.String oauthToken) {
          return (ModifyAckDeadline) super.setOauthToken(oauthToken);
        }

        @Override
        public ModifyAckDeadline setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (ModifyAckDeadline) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public ModifyAckDeadline setQuotaUser(java.lang.String quotaUser) {
          return (ModifyAckDeadline) super.setQuotaUser(quotaUser);
        }

        @Override
        public ModifyAckDeadline setUploadType(java.lang.String uploadType) {
          return (ModifyAckDeadline) super.setUploadType(uploadType);
        }

        @Override
        public ModifyAckDeadline setUploadProtocol(java.lang.String uploadProtocol) {
          return (ModifyAckDeadline) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the subscription. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * Required. The name of the subscription. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        public ModifyAckDeadline setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public ModifyAckDeadline set(String parameterName, Object value) {
          return (ModifyAckDeadline) super.set(parameterName, value);
        }
      }
      /**
       * Modifies the `PushConfig` for a specified subscription. This may be used to change a push
       * subscription to a pull one (signified by an empty `PushConfig`) or vice versa, or change the
       * endpoint URL and other attributes of a push subscription. Messages will accumulate for delivery
       * continuously through the call regardless of changes to the `PushConfig`.
       *
       * Create a request for the method "subscriptions.modifyPushConfig".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link ModifyPushConfig#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.ModifyPushConfigRequest}
       * @return the request
       */
      public ModifyPushConfig modifyPushConfig(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyPushConfigRequest content) throws java.io.IOException {
        ModifyPushConfig result = new ModifyPushConfig(subscription, content);
        initialize(result);
        return result;
      }

      public class ModifyPushConfig extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}:modifyPushConfig";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Modifies the `PushConfig` for a specified subscription. This may be used to change a push
         * subscription to a pull one (signified by an empty `PushConfig`) or vice versa, or change the
         * endpoint URL and other attributes of a push subscription. Messages will accumulate for delivery
         * continuously through the call regardless of changes to the `PushConfig`.
         *
         * Create a request for the method "subscriptions.modifyPushConfig".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link ModifyPushConfig#execute()} method to invoke the remote operation.
         * <p> {@link ModifyPushConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogle
         * ClientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param subscription Required. The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.ModifyPushConfigRequest}
         * @since 1.13
         */
        protected ModifyPushConfig(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyPushConfigRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public ModifyPushConfig set$Xgafv(java.lang.String $Xgafv) {
          return (ModifyPushConfig) super.set$Xgafv($Xgafv);
        }

        @Override
        public ModifyPushConfig setAccessToken(java.lang.String accessToken) {
          return (ModifyPushConfig) super.setAccessToken(accessToken);
        }

        @Override
        public ModifyPushConfig setAlt(java.lang.String alt) {
          return (ModifyPushConfig) super.setAlt(alt);
        }

        @Override
        public ModifyPushConfig setCallback(java.lang.String callback) {
          return (ModifyPushConfig) super.setCallback(callback);
        }

        @Override
        public ModifyPushConfig setFields(java.lang.String fields) {
          return (ModifyPushConfig) super.setFields(fields);
        }

        @Override
        public ModifyPushConfig setKey(java.lang.String key) {
          return (ModifyPushConfig) super.setKey(key);
        }

        @Override
        public ModifyPushConfig setOauthToken(java.lang.String oauthToken) {
          return (ModifyPushConfig) super.setOauthToken(oauthToken);
        }

        @Override
        public ModifyPushConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (ModifyPushConfig) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public ModifyPushConfig setQuotaUser(java.lang.String quotaUser) {
          return (ModifyPushConfig) super.setQuotaUser(quotaUser);
        }

        @Override
        public ModifyPushConfig setUploadType(java.lang.String uploadType) {
          return (ModifyPushConfig) super.setUploadType(uploadType);
        }

        @Override
        public ModifyPushConfig setUploadProtocol(java.lang.String uploadProtocol) {
          return (ModifyPushConfig) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the subscription. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * Required. The name of the subscription. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        public ModifyPushConfig setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public ModifyPushConfig set(String parameterName, Object value) {
          return (ModifyPushConfig) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing subscription. Note that certain properties of a subscription, such as its
       * topic, are not modifiable.
       *
       * Create a request for the method "subscriptions.patch".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the subscription. It must have the format
       *        `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
       *        letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
       *        underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must
       *        be between 3 and 255 characters in length, and it must not start with `"goog"`.
       * @param content the {@link com.google.api.services.pubsub.model.UpdateSubscriptionRequest}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.pubsub.model.UpdateSubscriptionRequest content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends PubsubRequest<com.google.api.services.pubsub.model.Subscription> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Updates an existing subscription. Note that certain properties of a subscription, such as its
         * topic, are not modifiable.
         *
         * Create a request for the method "subscriptions.patch".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the subscription. It must have the format
       *        `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
       *        letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
       *        underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must
       *        be between 3 and 255 characters in length, and it must not start with `"goog"`.
         * @param content the {@link com.google.api.services.pubsub.model.UpdateSubscriptionRequest}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.pubsub.model.UpdateSubscriptionRequest content) {
          super(Pubsub.this, "PATCH", REST_PATH, content, com.google.api.services.pubsub.model.Subscription.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the subscription. It must have the format
         * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
         * letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
         * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
         * must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the subscription. It must have the format
       `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a letter, and
       contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`), underscores (`_`), periods
       (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters in
       length, and it must not start with `"goog"`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the subscription. It must have the format
         * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
         * letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
         * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
         * must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Pulls messages from the server.
       *
       * Create a request for the method "subscriptions.pull".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Pull#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The subscription from which messages should be pulled. Format is
       *        `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.PullRequest}
       * @return the request
       */
      public Pull pull(java.lang.String subscription, com.google.api.services.pubsub.model.PullRequest content) throws java.io.IOException {
        Pull result = new Pull(subscription, content);
        initialize(result);
        return result;
      }

      public class Pull extends PubsubRequest<com.google.api.services.pubsub.model.PullResponse> {

        private static final String REST_PATH = "v1/{+subscription}:pull";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Pulls messages from the server.
         *
         * Create a request for the method "subscriptions.pull".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Pull#execute()} method to invoke the remote operation. <p> {@link
         * Pull#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription Required. The subscription from which messages should be pulled. Format is
       *        `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.PullRequest}
         * @since 1.13
         */
        protected Pull(java.lang.String subscription, com.google.api.services.pubsub.model.PullRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.PullResponse.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Pull set$Xgafv(java.lang.String $Xgafv) {
          return (Pull) super.set$Xgafv($Xgafv);
        }

        @Override
        public Pull setAccessToken(java.lang.String accessToken) {
          return (Pull) super.setAccessToken(accessToken);
        }

        @Override
        public Pull setAlt(java.lang.String alt) {
          return (Pull) super.setAlt(alt);
        }

        @Override
        public Pull setCallback(java.lang.String callback) {
          return (Pull) super.setCallback(callback);
        }

        @Override
        public Pull setFields(java.lang.String fields) {
          return (Pull) super.setFields(fields);
        }

        @Override
        public Pull setKey(java.lang.String key) {
          return (Pull) super.setKey(key);
        }

        @Override
        public Pull setOauthToken(java.lang.String oauthToken) {
          return (Pull) super.setOauthToken(oauthToken);
        }

        @Override
        public Pull setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Pull) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Pull setQuotaUser(java.lang.String quotaUser) {
          return (Pull) super.setQuotaUser(quotaUser);
        }

        @Override
        public Pull setUploadType(java.lang.String uploadType) {
          return (Pull) super.setUploadType(uploadType);
        }

        @Override
        public Pull setUploadProtocol(java.lang.String uploadProtocol) {
          return (Pull) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The subscription from which messages should be pulled. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The subscription from which messages should be pulled. Format is
       `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * Required. The subscription from which messages should be pulled. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        public Pull setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Pull set(String parameterName, Object value) {
          return (Pull) super.set(parameterName, value);
        }
      }
      /**
       * Seeks an existing subscription to a point in time or to a given snapshot, whichever is provided
       * in the request. Snapshots are used in [Seek] (https://cloud.google.com/pubsub/docs/replay-
       * overview) operations, which allow you to manage message acknowledgments in bulk. That is, you can
       * set the acknowledgment state of messages in an existing subscription to the state captured by a
       * snapshot. Note that both the subscription and the snapshot must be on the same topic.
       *
       * Create a request for the method "subscriptions.seek".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Seek#execute()} method to invoke the remote operation.
       *
       * @param subscription Required. The subscription to affect.
       * @param content the {@link com.google.api.services.pubsub.model.SeekRequest}
       * @return the request
       */
      public Seek seek(java.lang.String subscription, com.google.api.services.pubsub.model.SeekRequest content) throws java.io.IOException {
        Seek result = new Seek(subscription, content);
        initialize(result);
        return result;
      }

      public class Seek extends PubsubRequest<com.google.api.services.pubsub.model.SeekResponse> {

        private static final String REST_PATH = "v1/{+subscription}:seek";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Seeks an existing subscription to a point in time or to a given snapshot, whichever is provided
         * in the request. Snapshots are used in [Seek] (https://cloud.google.com/pubsub/docs/replay-
         * overview) operations, which allow you to manage message acknowledgments in bulk. That is, you
         * can set the acknowledgment state of messages in an existing subscription to the state captured
         * by a snapshot. Note that both the subscription and the snapshot must be on the same topic.
         *
         * Create a request for the method "subscriptions.seek".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Seek#execute()} method to invoke the remote operation. <p> {@link
         * Seek#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription Required. The subscription to affect.
         * @param content the {@link com.google.api.services.pubsub.model.SeekRequest}
         * @since 1.13
         */
        protected Seek(java.lang.String subscription, com.google.api.services.pubsub.model.SeekRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.SeekResponse.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Seek set$Xgafv(java.lang.String $Xgafv) {
          return (Seek) super.set$Xgafv($Xgafv);
        }

        @Override
        public Seek setAccessToken(java.lang.String accessToken) {
          return (Seek) super.setAccessToken(accessToken);
        }

        @Override
        public Seek setAlt(java.lang.String alt) {
          return (Seek) super.setAlt(alt);
        }

        @Override
        public Seek setCallback(java.lang.String callback) {
          return (Seek) super.setCallback(callback);
        }

        @Override
        public Seek setFields(java.lang.String fields) {
          return (Seek) super.setFields(fields);
        }

        @Override
        public Seek setKey(java.lang.String key) {
          return (Seek) super.setKey(key);
        }

        @Override
        public Seek setOauthToken(java.lang.String oauthToken) {
          return (Seek) super.setOauthToken(oauthToken);
        }

        @Override
        public Seek setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Seek) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Seek setQuotaUser(java.lang.String quotaUser) {
          return (Seek) super.setQuotaUser(quotaUser);
        }

        @Override
        public Seek setUploadType(java.lang.String uploadType) {
          return (Seek) super.setUploadType(uploadType);
        }

        @Override
        public Seek setUploadProtocol(java.lang.String uploadProtocol) {
          return (Seek) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The subscription to affect. */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** Required. The subscription to affect.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /** Required. The subscription to affect. */
        public Seek setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Seek set(String parameterName, Object value) {
          return (Seek) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "subscriptions.setIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "subscriptions.setIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
       * designed to be used for building permission-aware UIs and command-line tools, not for
       * authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "subscriptions.testIamPermissions".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends PubsubRequest<com.google.api.services.pubsub.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
         * operation is designed to be used for building permission-aware UIs and command-line tools, not
         * for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "subscriptions.testIamPermissions".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Topics collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Pubsub pubsub = new Pubsub(...);}
     *   {@code Pubsub.Topics.List request = pubsub.topics().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Topics topics() {
      return new Topics();
    }

    /**
     * The "topics" collection of methods.
     */
    public class Topics {

      /**
       * Creates the given topic with the given name. See the [resource name rules]
       * (https://cloud.google.com/pubsub/docs/admin#resource_names).
       *
       * Create a request for the method "topics.create".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
       *        `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers
       *        (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or
       *        percent signs (`%`). It must be between 3 and 255 characters in length, and it must not
       *        start with `"goog"`.
       * @param content the {@link com.google.api.services.pubsub.model.Topic}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.pubsub.model.Topic content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends PubsubRequest<com.google.api.services.pubsub.model.Topic> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Creates the given topic with the given name. See the [resource name rules]
         * (https://cloud.google.com/pubsub/docs/admin#resource_names).
         *
         * Create a request for the method "topics.create".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
       *        `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers
       *        (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or
       *        percent signs (`%`). It must be between 3 and 255 characters in length, and it must not
       *        start with `"goog"`.
         * @param content the {@link com.google.api.services.pubsub.model.Topic}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.pubsub.model.Topic content) {
          super(Pubsub.this, "PUT", REST_PATH, content, com.google.api.services.pubsub.model.Topic.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the topic. It must have the format
         * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter, and contain
         * only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`), underscores (`_`), periods
         * (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be between 3 and 255
         * characters in length, and it must not start with `"goog"`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
       `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`),
       dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
       must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the topic. It must have the format
         * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter, and contain
         * only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`), underscores (`_`), periods
         * (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be between 3 and 255
         * characters in length, and it must not start with `"goog"`.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes the topic with the given name. Returns `NOT_FOUND` if the topic does not exist. After a
       * topic is deleted, a new topic may be created with the same name; this is an entirely new topic
       * with none of the old configuration or subscriptions. Existing subscriptions to this topic are not
       * deleted, but their `topic` field is set to `_deleted-topic_`.
       *
       * Create a request for the method "topics.delete".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param topic Required. Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
       * @return the request
       */
      public Delete delete(java.lang.String topic) throws java.io.IOException {
        Delete result = new Delete(topic);
        initialize(result);
        return result;
      }

      public class Delete extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+topic}";

        private final java.util.regex.Pattern TOPIC_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Deletes the topic with the given name. Returns `NOT_FOUND` if the topic does not exist. After a
         * topic is deleted, a new topic may be created with the same name; this is an entirely new topic
         * with none of the old configuration or subscriptions. Existing subscriptions to this topic are
         * not deleted, but their `topic` field is set to `_deleted-topic_`.
         *
         * Create a request for the method "topics.delete".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param topic Required. Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
         * @since 1.13
         */
        protected Delete(java.lang.String topic) {
          super(Pubsub.this, "DELETE", REST_PATH, null, com.google.api.services.pubsub.model.Empty.class);
          this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String topic;

        /** Required. Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
         */
        public java.lang.String getTopic() {
          return topic;
        }

        /**
         * Required. Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
         */
        public Delete setTopic(java.lang.String topic) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.topic = topic;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the configuration of a topic.
       *
       * Create a request for the method "topics.get".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param topic Required. The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
       * @return the request
       */
      public Get get(java.lang.String topic) throws java.io.IOException {
        Get result = new Get(topic);
        initialize(result);
        return result;
      }

      public class Get extends PubsubRequest<com.google.api.services.pubsub.model.Topic> {

        private static final String REST_PATH = "v1/{+topic}";

        private final java.util.regex.Pattern TOPIC_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Gets the configuration of a topic.
         *
         * Create a request for the method "topics.get".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param topic Required. The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
         * @since 1.13
         */
        protected Get(java.lang.String topic) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Topic.class);
          this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String topic;

        /** Required. The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
         */
        public java.lang.String getTopic() {
          return topic;
        }

        /**
         * Required. The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
         */
        public Get setTopic(java.lang.String topic) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.topic = topic;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "topics.getIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "topics.getIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        @com.google.api.client.util.Key("options.requestedPolicyVersion")
        private java.lang.Integer optionsRequestedPolicyVersion;

        /** Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1,
       and 3. Requests specifying an invalid value will be rejected. Requests for policies with any
       conditional role bindings must specify version 3. Policies with no conditional role bindings may
       specify any valid value or leave the field unset. The policy in the response might use the policy
       version that you specified, or it might use a lower policy version. For example, if you specify
       version 3, but the policy has no conditional role bindings, the response uses version 1. To learn
       which resources support conditions in their IAM policies, see the [IAM
       documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public java.lang.Integer getOptionsRequestedPolicyVersion() {
          return optionsRequestedPolicyVersion;
        }

        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values
         * are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for
         * policies with any conditional role bindings must specify version 3. Policies with no
         * conditional role bindings may specify any valid value or leave the field unset. The
         * policy in the response might use the policy version that you specified, or it might use a
         * lower policy version. For example, if you specify version 3, but the policy has no
         * conditional role bindings, the response uses version 1. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
          this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists matching topics.
       *
       * Create a request for the method "topics.list".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param project Required. The name of the project in which to list topics. Format is `projects/{project-id}`.
       * @return the request
       */
      public List list(java.lang.String project) throws java.io.IOException {
        List result = new List(project);
        initialize(result);
        return result;
      }

      public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListTopicsResponse> {

        private static final String REST_PATH = "v1/{+project}/topics";

        private final java.util.regex.Pattern PROJECT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists matching topics.
         *
         * Create a request for the method "topics.list".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param project Required. The name of the project in which to list topics. Format is `projects/{project-id}`.
         * @since 1.13
         */
        protected List(java.lang.String project) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListTopicsResponse.class);
          this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the project in which to list topics. Format is `projects/{project-
         * id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String project;

        /** Required. The name of the project in which to list topics. Format is `projects/{project-id}`.
         */
        public java.lang.String getProject() {
          return project;
        }

        /**
         * Required. The name of the project in which to list topics. Format is `projects/{project-
         * id}`.
         */
        public List setProject(java.lang.String project) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.project = project;
          return this;
        }

        /** Maximum number of topics to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Maximum number of topics to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Maximum number of topics to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * The value returned by the last `ListTopicsResponse`; indicates that this is a
         * continuation of a prior `ListTopics` call, and that the system should return the next
         * page of data.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The value returned by the last `ListTopicsResponse`; indicates that this is a continuation of a
       prior `ListTopics` call, and that the system should return the next page of data.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The value returned by the last `ListTopicsResponse`; indicates that this is a
         * continuation of a prior `ListTopics` call, and that the system should return the next
         * page of data.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing topic. Note that certain properties of a topic are not modifiable.
       *
       * Create a request for the method "topics.patch".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
       *        `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers
       *        (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or
       *        percent signs (`%`). It must be between 3 and 255 characters in length, and it must not
       *        start with `"goog"`.
       * @param content the {@link com.google.api.services.pubsub.model.UpdateTopicRequest}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.pubsub.model.UpdateTopicRequest content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends PubsubRequest<com.google.api.services.pubsub.model.Topic> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Updates an existing topic. Note that certain properties of a topic are not modifiable.
         *
         * Create a request for the method "topics.patch".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
       *        `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers
       *        (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or
       *        percent signs (`%`). It must be between 3 and 255 characters in length, and it must not
       *        start with `"goog"`.
         * @param content the {@link com.google.api.services.pubsub.model.UpdateTopicRequest}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.pubsub.model.UpdateTopicRequest content) {
          super(Pubsub.this, "PATCH", REST_PATH, content, com.google.api.services.pubsub.model.Topic.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the topic. It must have the format
         * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter, and contain
         * only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`), underscores (`_`), periods
         * (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be between 3 and 255
         * characters in length, and it must not start with `"goog"`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
       `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`),
       dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
       must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the topic. It must have the format
         * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter, and contain
         * only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`), underscores (`_`), periods
         * (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be between 3 and 255
         * characters in length, and it must not start with `"goog"`.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic does not exist.
       *
       * Create a request for the method "topics.publish".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Publish#execute()} method to invoke the remote operation.
       *
       * @param topic Required. The messages in the request will be published on this topic. Format is
       *        `projects/{project}/topics/{topic}`.
       * @param content the {@link com.google.api.services.pubsub.model.PublishRequest}
       * @return the request
       */
      public Publish publish(java.lang.String topic, com.google.api.services.pubsub.model.PublishRequest content) throws java.io.IOException {
        Publish result = new Publish(topic, content);
        initialize(result);
        return result;
      }

      public class Publish extends PubsubRequest<com.google.api.services.pubsub.model.PublishResponse> {

        private static final String REST_PATH = "v1/{+topic}:publish";

        private final java.util.regex.Pattern TOPIC_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic does not exist.
         *
         * Create a request for the method "topics.publish".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Publish#execute()} method to invoke the remote operation. <p>
         * {@link
         * Publish#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param topic Required. The messages in the request will be published on this topic. Format is
       *        `projects/{project}/topics/{topic}`.
         * @param content the {@link com.google.api.services.pubsub.model.PublishRequest}
         * @since 1.13
         */
        protected Publish(java.lang.String topic, com.google.api.services.pubsub.model.PublishRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.PublishResponse.class);
          this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public Publish set$Xgafv(java.lang.String $Xgafv) {
          return (Publish) super.set$Xgafv($Xgafv);
        }

        @Override
        public Publish setAccessToken(java.lang.String accessToken) {
          return (Publish) super.setAccessToken(accessToken);
        }

        @Override
        public Publish setAlt(java.lang.String alt) {
          return (Publish) super.setAlt(alt);
        }

        @Override
        public Publish setCallback(java.lang.String callback) {
          return (Publish) super.setCallback(callback);
        }

        @Override
        public Publish setFields(java.lang.String fields) {
          return (Publish) super.setFields(fields);
        }

        @Override
        public Publish setKey(java.lang.String key) {
          return (Publish) super.setKey(key);
        }

        @Override
        public Publish setOauthToken(java.lang.String oauthToken) {
          return (Publish) super.setOauthToken(oauthToken);
        }

        @Override
        public Publish setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Publish) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Publish setQuotaUser(java.lang.String quotaUser) {
          return (Publish) super.setQuotaUser(quotaUser);
        }

        @Override
        public Publish setUploadType(java.lang.String uploadType) {
          return (Publish) super.setUploadType(uploadType);
        }

        @Override
        public Publish setUploadProtocol(java.lang.String uploadProtocol) {
          return (Publish) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The messages in the request will be published on this topic. Format is
         * `projects/{project}/topics/{topic}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String topic;

        /** Required. The messages in the request will be published on this topic. Format is
       `projects/{project}/topics/{topic}`.
         */
        public java.lang.String getTopic() {
          return topic;
        }

        /**
         * Required. The messages in the request will be published on this topic. Format is
         * `projects/{project}/topics/{topic}`.
         */
        public Publish setTopic(java.lang.String topic) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.topic = topic;
          return this;
        }

        @Override
        public Publish set(String parameterName, Object value) {
          return (Publish) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "topics.setIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "topics.setIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
       * designed to be used for building permission-aware UIs and command-line tools, not for
       * authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "topics.testIamPermissions".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
       * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends PubsubRequest<com.google.api.services.pubsub.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
         * operation is designed to be used for building permission-aware UIs and command-line tools, not
         * for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "topics.testIamPermissions".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
       *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       *        this field.
         * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See [Resource
       names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
       field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource
         * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
         * this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Snapshots collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Pubsub pubsub = new Pubsub(...);}
       *   {@code Pubsub.Snapshots.List request = pubsub.snapshots().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Snapshots snapshots() {
        return new Snapshots();
      }

      /**
       * The "snapshots" collection of methods.
       */
      public class Snapshots {

        /**
         * Lists the names of the snapshots on this topic. Snapshots are used in
         * [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to
         * manage message acknowledgments in bulk. That is, you can set the acknowledgment state of messages
         * in an existing subscription to the state captured by a snapshot.
         *
         * Create a request for the method "snapshots.list".
         *
         * This request holds the parameters needed by the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param topic Required. The name of the topic that snapshots are attached to. Format is
         *        `projects/{project}/topics/{topic}`.
         * @return the request
         */
        public List list(java.lang.String topic) throws java.io.IOException {
          List result = new List(topic);
          initialize(result);
          return result;
        }

        public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListTopicSnapshotsResponse> {

          private static final String REST_PATH = "v1/{+topic}/snapshots";

          private final java.util.regex.Pattern TOPIC_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

          /**
           * Lists the names of the snapshots on this topic. Snapshots are used in
           * [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations, which allow you to
           * manage message acknowledgments in bulk. That is, you can set the acknowledgment state of
           * messages in an existing subscription to the state captured by a snapshot.
           *
           * Create a request for the method "snapshots.list".
           *
           * This request holds the parameters needed by the the pubsub server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param topic Required. The name of the topic that snapshots are attached to. Format is
         *        `projects/{project}/topics/{topic}`.
           * @since 1.13
           */
          protected List(java.lang.String topic) {
            super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListTopicSnapshotsResponse.class);
            this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                  "Parameter topic must conform to the pattern " +
                  "^projects/[^/]+/topics/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The name of the topic that snapshots are attached to. Format is
           * `projects/{project}/topics/{topic}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String topic;

          /** Required. The name of the topic that snapshots are attached to. Format is
         `projects/{project}/topics/{topic}`.
           */
          public java.lang.String getTopic() {
            return topic;
          }

          /**
           * Required. The name of the topic that snapshots are attached to. Format is
           * `projects/{project}/topics/{topic}`.
           */
          public List setTopic(java.lang.String topic) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                  "Parameter topic must conform to the pattern " +
                  "^projects/[^/]+/topics/[^/]+$");
            }
            this.topic = topic;
            return this;
          }

          /** Maximum number of snapshot names to return. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum number of snapshot names to return.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum number of snapshot names to return. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * The value returned by the last `ListTopicSnapshotsResponse`; indicates that this is a
           * continuation of a prior `ListTopicSnapshots` call, and that the system should return
           * the next page of data.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The value returned by the last `ListTopicSnapshotsResponse`; indicates that this is a continuation
         of a prior `ListTopicSnapshots` call, and that the system should return the next page of data.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * The value returned by the last `ListTopicSnapshotsResponse`; indicates that this is a
           * continuation of a prior `ListTopicSnapshots` call, and that the system should return
           * the next page of data.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Subscriptions collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Pubsub pubsub = new Pubsub(...);}
       *   {@code Pubsub.Subscriptions.List request = pubsub.subscriptions().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Subscriptions subscriptions() {
        return new Subscriptions();
      }

      /**
       * The "subscriptions" collection of methods.
       */
      public class Subscriptions {

        /**
         * Lists the names of the attached subscriptions on this topic.
         *
         * Create a request for the method "subscriptions.list".
         *
         * This request holds the parameters needed by the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param topic Required. The name of the topic that subscriptions are attached to. Format is
         *        `projects/{project}/topics/{topic}`.
         * @return the request
         */
        public List list(java.lang.String topic) throws java.io.IOException {
          List result = new List(topic);
          initialize(result);
          return result;
        }

        public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListTopicSubscriptionsResponse> {

          private static final String REST_PATH = "v1/{+topic}/subscriptions";

          private final java.util.regex.Pattern TOPIC_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

          /**
           * Lists the names of the attached subscriptions on this topic.
           *
           * Create a request for the method "subscriptions.list".
           *
           * This request holds the parameters needed by the the pubsub server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param topic Required. The name of the topic that subscriptions are attached to. Format is
         *        `projects/{project}/topics/{topic}`.
           * @since 1.13
           */
          protected List(java.lang.String topic) {
            super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListTopicSubscriptionsResponse.class);
            this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                  "Parameter topic must conform to the pattern " +
                  "^projects/[^/]+/topics/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The name of the topic that subscriptions are attached to. Format is
           * `projects/{project}/topics/{topic}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String topic;

          /** Required. The name of the topic that subscriptions are attached to. Format is
         `projects/{project}/topics/{topic}`.
           */
          public java.lang.String getTopic() {
            return topic;
          }

          /**
           * Required. The name of the topic that subscriptions are attached to. Format is
           * `projects/{project}/topics/{topic}`.
           */
          public List setTopic(java.lang.String topic) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                  "Parameter topic must conform to the pattern " +
                  "^projects/[^/]+/topics/[^/]+$");
            }
            this.topic = topic;
            return this;
          }

          /** Maximum number of subscription names to return. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum number of subscription names to return.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum number of subscription names to return. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * The value returned by the last `ListTopicSubscriptionsResponse`; indicates that this is
           * a continuation of a prior `ListTopicSubscriptions` call, and that the system should
           * return the next page of data.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The value returned by the last `ListTopicSubscriptionsResponse`; indicates that this is a
         continuation of a prior `ListTopicSubscriptions` call, and that the system should return the next
         page of data.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * The value returned by the last `ListTopicSubscriptionsResponse`; indicates that this is
           * a continuation of a prior `ListTopicSubscriptions` call, and that the system should
           * return the next page of data.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link Pubsub}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Pubsub}. */
    @Override
    public Pubsub build() {
      return new Pubsub(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link PubsubRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setPubsubRequestInitializer(
        PubsubRequestInitializer pubsubRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(pubsubRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
