/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.plus;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.plus.PlusRequest;
import com.google.api.services.plus.PlusRequestInitializer;
import com.google.api.services.plus.model.Activity;
import com.google.api.services.plus.model.ActivityFeed;
import com.google.api.services.plus.model.AudiencesFeed;
import com.google.api.services.plus.model.Circle;
import com.google.api.services.plus.model.CircleFeed;
import com.google.api.services.plus.model.Comment;
import com.google.api.services.plus.model.CommentFeed;
import com.google.api.services.plus.model.PeopleFeed;
import com.google.api.services.plus.model.Person;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plus
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "plus/v1domains/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/plus/v1domains/";

    public Plus(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Plus(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Activities activities() {
        return new Activities();
    }

    public Audiences audiences() {
        return new Audiences();
    }

    public Circles circles() {
        return new Circles();
    }

    public Comments comments() {
        return new Comments();
    }

    public Media media() {
        return new Media();
    }

    public People people() {
        return new People();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.15.0-rc of the Google+ API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Plus.DEFAULT_ROOT_URL, Plus.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Plus build() {
            return new Plus(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setPlusRequestInitializer(PlusRequestInitializer plusRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)plusRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class People {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListByActivity listByActivity(String string, String string2) throws IOException {
            ListByActivity listByActivity = new ListByActivity(string, string2);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)listByActivity);
            return listByActivity;
        }

        public ListByCircle listByCircle(String string) throws IOException {
            ListByCircle listByCircle = new ListByCircle(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)listByCircle);
            return listByCircle;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListByCircle
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "circles/{circleId}/people";
            @Key
            private String circleId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected ListByCircle(String string) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.circleId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter circleId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListByCircle setAlt(String string) {
                return (ListByCircle)super.setAlt(string);
            }

            public ListByCircle setFields(String string) {
                return (ListByCircle)super.setFields(string);
            }

            public ListByCircle setKey(String string) {
                return (ListByCircle)super.setKey(string);
            }

            public ListByCircle setOauthToken(String string) {
                return (ListByCircle)super.setOauthToken(string);
            }

            public ListByCircle setPrettyPrint(Boolean bl) {
                return (ListByCircle)super.setPrettyPrint(bl);
            }

            public ListByCircle setQuotaUser(String string) {
                return (ListByCircle)super.setQuotaUser(string);
            }

            public ListByCircle setUserIp(String string) {
                return (ListByCircle)super.setUserIp(string);
            }

            public String getCircleId() {
                return this.circleId;
            }

            public ListByCircle setCircleId(String string) {
                this.circleId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByCircle setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByCircle setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public ListByCircle set(String string, Object object) {
                return (ListByCircle)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListByActivity
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "activities/{activityId}/people/{collection}";
            @Key
            private String activityId;
            @Key
            private String collection;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected ListByActivity(String string, String string2) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListByActivity setAlt(String string) {
                return (ListByActivity)super.setAlt(string);
            }

            public ListByActivity setFields(String string) {
                return (ListByActivity)super.setFields(string);
            }

            public ListByActivity setKey(String string) {
                return (ListByActivity)super.setKey(string);
            }

            public ListByActivity setOauthToken(String string) {
                return (ListByActivity)super.setOauthToken(string);
            }

            public ListByActivity setPrettyPrint(Boolean bl) {
                return (ListByActivity)super.setPrettyPrint(bl);
            }

            public ListByActivity setQuotaUser(String string) {
                return (ListByActivity)super.setQuotaUser(string);
            }

            public ListByActivity setUserIp(String string) {
                return (ListByActivity)super.setUserIp(string);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public ListByActivity setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListByActivity setCollection(String string) {
                this.collection = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByActivity setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByActivity setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public ListByActivity set(String string, Object object) {
                return (ListByActivity)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "people/{userId}/people/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String string) {
                this.collection = string;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest<Person> {
            private static final String REST_PATH = "people/{userId}";
            @Key
            private String userId;

            protected Get(String string) {
                super(Plus.this, "GET", REST_PATH, null, Person.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String string) {
                this.userId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Media {
        public Insert insert(String string, String string2, com.google.api.services.plus.model.Media media) throws IOException {
            Insert insert = new Insert(string, string2, media);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(String string, String string2, com.google.api.services.plus.model.Media media, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, string2, media, abstractInputStreamContent);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends PlusRequest<com.google.api.services.plus.model.Media> {
            private static final String REST_PATH = "people/{userId}/media/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;

            protected Insert(String string, String string2, com.google.api.services.plus.model.Media media2) {
                super(Plus.this, "POST", REST_PATH, (Object)media2, com.google.api.services.plus.model.Media.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            protected Insert(String string, String string2, com.google.api.services.plus.model.Media media2, AbstractInputStreamContent abstractInputStreamContent) {
                super(Plus.this, "POST", "/upload/" + Plus.this.getServicePath() + REST_PATH, (Object)media2, com.google.api.services.plus.model.Media.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Insert setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public Insert setCollection(String string) {
                this.collection = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }
    }

    public class Comments {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Comment comment) throws IOException {
            Insert insert = new Insert(string, comment);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<CommentFeed> {
            private static final String REST_PATH = "activities/{activityId}/comments";
            @Key
            private String activityId;
            @Key
            private String pageToken;
            @Key
            private String sortOrder;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Plus.this, "GET", REST_PATH, null, CommentFeed.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public List setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends PlusRequest<Comment> {
            private static final String REST_PATH = "activities/{activityId}/comments";
            @Key
            private String activityId;

            protected Insert(String string, Comment comment) {
                super(Plus.this, "POST", REST_PATH, (Object)comment, Comment.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public Insert setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest<Comment> {
            private static final String REST_PATH = "comments/{commentId}";
            @Key
            private String commentId;

            protected Get(String string) {
                super(Plus.this, "GET", REST_PATH, null, Comment.class);
                this.commentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Circles {
        public AddPeople addPeople(String string) throws IOException {
            AddPeople addPeople = new AddPeople(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)addPeople);
            return addPeople;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Circle circle) throws IOException {
            Insert insert = new Insert(string, circle);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Circle circle) throws IOException {
            Patch patch = new Patch(string, circle);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Remove remove(String string) throws IOException {
            Remove remove = new Remove(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)remove);
            return remove;
        }

        public RemovePeople removePeople(String string) throws IOException {
            RemovePeople removePeople = new RemovePeople(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)removePeople);
            return removePeople;
        }

        public Update update(String string, Circle circle) throws IOException {
            Update update = new Update(string, circle);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends PlusRequest<Circle> {
            private static final String REST_PATH = "circles/{circleId}";
            @Key
            private String circleId;

            protected Update(String string, Circle circle) {
                super(Plus.this, "PUT", REST_PATH, (Object)circle, Circle.class);
                this.circleId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter circleId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCircleId() {
                return this.circleId;
            }

            public Update setCircleId(String string) {
                this.circleId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RemovePeople
        extends PlusRequest<Void> {
            private static final String REST_PATH = "circles/{circleId}/people";
            @Key
            private String circleId;
            @Key
            private java.util.List<String> userId;
            @Key
            private java.util.List<String> email;

            protected RemovePeople(String string) {
                super(Plus.this, "DELETE", REST_PATH, null, Void.class);
                this.circleId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter circleId must be specified.");
            }

            public RemovePeople setAlt(String string) {
                return (RemovePeople)super.setAlt(string);
            }

            public RemovePeople setFields(String string) {
                return (RemovePeople)super.setFields(string);
            }

            public RemovePeople setKey(String string) {
                return (RemovePeople)super.setKey(string);
            }

            public RemovePeople setOauthToken(String string) {
                return (RemovePeople)super.setOauthToken(string);
            }

            public RemovePeople setPrettyPrint(Boolean bl) {
                return (RemovePeople)super.setPrettyPrint(bl);
            }

            public RemovePeople setQuotaUser(String string) {
                return (RemovePeople)super.setQuotaUser(string);
            }

            public RemovePeople setUserIp(String string) {
                return (RemovePeople)super.setUserIp(string);
            }

            public String getCircleId() {
                return this.circleId;
            }

            public RemovePeople setCircleId(String string) {
                this.circleId = string;
                return this;
            }

            public java.util.List<String> getUserId() {
                return this.userId;
            }

            public RemovePeople setUserId(java.util.List<String> list) {
                this.userId = list;
                return this;
            }

            public java.util.List<String> getEmail() {
                return this.email;
            }

            public RemovePeople setEmail(java.util.List<String> list) {
                this.email = list;
                return this;
            }

            @Override
            public RemovePeople set(String string, Object object) {
                return (RemovePeople)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Remove
        extends PlusRequest<Void> {
            private static final String REST_PATH = "circles/{circleId}";
            @Key
            private String circleId;

            protected Remove(String string) {
                super(Plus.this, "DELETE", REST_PATH, null, Void.class);
                this.circleId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter circleId must be specified.");
            }

            public Remove setAlt(String string) {
                return (Remove)super.setAlt(string);
            }

            public Remove setFields(String string) {
                return (Remove)super.setFields(string);
            }

            public Remove setKey(String string) {
                return (Remove)super.setKey(string);
            }

            public Remove setOauthToken(String string) {
                return (Remove)super.setOauthToken(string);
            }

            public Remove setPrettyPrint(Boolean bl) {
                return (Remove)super.setPrettyPrint(bl);
            }

            public Remove setQuotaUser(String string) {
                return (Remove)super.setQuotaUser(string);
            }

            public Remove setUserIp(String string) {
                return (Remove)super.setUserIp(string);
            }

            public String getCircleId() {
                return this.circleId;
            }

            public Remove setCircleId(String string) {
                this.circleId = string;
                return this;
            }

            @Override
            public Remove set(String string, Object object) {
                return (Remove)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends PlusRequest<Circle> {
            private static final String REST_PATH = "circles/{circleId}";
            @Key
            private String circleId;

            protected Patch(String string, Circle circle) {
                super(Plus.this, "PATCH", REST_PATH, (Object)circle, Circle.class);
                this.circleId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter circleId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCircleId() {
                return this.circleId;
            }

            public Patch setCircleId(String string) {
                this.circleId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<CircleFeed> {
            private static final String REST_PATH = "people/{userId}/circles";
            @Key
            private String userId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Plus.this, "GET", REST_PATH, null, CircleFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends PlusRequest<Circle> {
            private static final String REST_PATH = "people/{userId}/circles";
            @Key
            private String userId;

            protected Insert(String string, Circle circle) {
                super(Plus.this, "POST", REST_PATH, (Object)circle, Circle.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.checkRequiredParameter((Object)circle, "content");
                this.checkRequiredParameter(circle.getDisplayName(), "Circle.getDisplayName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Insert setUserId(String string) {
                this.userId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest<Circle> {
            private static final String REST_PATH = "circles/{circleId}";
            @Key
            private String circleId;

            protected Get(String string) {
                super(Plus.this, "GET", REST_PATH, null, Circle.class);
                this.circleId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter circleId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCircleId() {
                return this.circleId;
            }

            public Get setCircleId(String string) {
                this.circleId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddPeople
        extends PlusRequest<Circle> {
            private static final String REST_PATH = "circles/{circleId}/people";
            @Key
            private String circleId;
            @Key
            private java.util.List<String> userId;
            @Key
            private java.util.List<String> email;

            protected AddPeople(String string) {
                super(Plus.this, "PUT", REST_PATH, null, Circle.class);
                this.circleId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter circleId must be specified.");
            }

            public AddPeople setAlt(String string) {
                return (AddPeople)super.setAlt(string);
            }

            public AddPeople setFields(String string) {
                return (AddPeople)super.setFields(string);
            }

            public AddPeople setKey(String string) {
                return (AddPeople)super.setKey(string);
            }

            public AddPeople setOauthToken(String string) {
                return (AddPeople)super.setOauthToken(string);
            }

            public AddPeople setPrettyPrint(Boolean bl) {
                return (AddPeople)super.setPrettyPrint(bl);
            }

            public AddPeople setQuotaUser(String string) {
                return (AddPeople)super.setQuotaUser(string);
            }

            public AddPeople setUserIp(String string) {
                return (AddPeople)super.setUserIp(string);
            }

            public String getCircleId() {
                return this.circleId;
            }

            public AddPeople setCircleId(String string) {
                this.circleId = string;
                return this;
            }

            public java.util.List<String> getUserId() {
                return this.userId;
            }

            public AddPeople setUserId(java.util.List<String> list) {
                this.userId = list;
                return this;
            }

            public java.util.List<String> getEmail() {
                return this.email;
            }

            public AddPeople setEmail(java.util.List<String> list) {
                this.email = list;
                return this;
            }

            @Override
            public AddPeople set(String string, Object object) {
                return (AddPeople)super.set(string, object);
            }
        }
    }

    public class Audiences {
        public List list(String string) throws IOException {
            List list = new List(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<AudiencesFeed> {
            private static final String REST_PATH = "people/{userId}/audiences";
            @Key
            private String userId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Plus.this, "GET", REST_PATH, null, AudiencesFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Activities {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Activity activity) throws IOException {
            Insert insert = new Insert(string, activity);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<ActivityFeed> {
            private static final String REST_PATH = "people/{userId}/activities/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Plus.this, "GET", REST_PATH, null, ActivityFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String string) {
                this.collection = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends PlusRequest<Activity> {
            private static final String REST_PATH = "people/{userId}/activities";
            @Key
            private String userId;
            @Key
            private Boolean preview;

            protected Insert(String string, Activity activity) {
                super(Plus.this, "POST", REST_PATH, (Object)activity, Activity.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Insert setUserId(String string) {
                this.userId = string;
                return this;
            }

            public Boolean getPreview() {
                return this.preview;
            }

            public Insert setPreview(Boolean bl) {
                this.preview = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest<Activity> {
            private static final String REST_PATH = "activities/{activityId}";
            @Key
            private String activityId;

            protected Get(String string) {
                super(Plus.this, "GET", REST_PATH, null, Activity.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public Get setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

