/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.plus;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.plus.PlusRequest;
import com.google.api.services.plus.PlusRequestInitializer;
import com.google.api.services.plus.model.Activity;
import com.google.api.services.plus.model.ActivityFeed;
import com.google.api.services.plus.model.Comment;
import com.google.api.services.plus.model.CommentFeed;
import com.google.api.services.plus.model.PeopleFeed;
import com.google.api.services.plus.model.Person;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plus
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "plus/v1/";
    public static final String DEFAULT_BATCH_PATH = "batch/plus/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/plus/v1/";

    public Plus(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Plus(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Activities activities() {
        return new Activities();
    }

    public Comments comments() {
        return new Comments();
    }

    public People people() {
        return new People();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.24.1 of the Google+ API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Plus.DEFAULT_ROOT_URL, Plus.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Plus.DEFAULT_BATCH_PATH);
        }

        public Plus build() {
            return new Plus(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setPlusRequestInitializer(PlusRequestInitializer plusRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)plusRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class People {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListByActivity listByActivity(String string, String string2) throws IOException {
            ListByActivity listByActivity = new ListByActivity(string, string2);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)listByActivity);
            return listByActivity;
        }

        public Search search(String string) throws IOException {
            Search search = new Search(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)search);
            return search;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Search
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "people";
            @Key
            private String query;
            @Key
            private String language;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected Search(String string) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.query = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter query must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search setAlt(String string) {
                return (Search)super.setAlt(string);
            }

            public Search setFields(String string) {
                return (Search)super.setFields(string);
            }

            public Search setKey(String string) {
                return (Search)super.setKey(string);
            }

            public Search setOauthToken(String string) {
                return (Search)super.setOauthToken(string);
            }

            public Search setPrettyPrint(Boolean bl) {
                return (Search)super.setPrettyPrint(bl);
            }

            public Search setQuotaUser(String string) {
                return (Search)super.setQuotaUser(string);
            }

            public Search setUserIp(String string) {
                return (Search)super.setUserIp(string);
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Search setLanguage(String string) {
                this.language = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public Search set(String string, Object object) {
                return (Search)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListByActivity
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "activities/{activityId}/people/{collection}";
            @Key
            private String activityId;
            @Key
            private String collection;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected ListByActivity(String string, String string2) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListByActivity setAlt(String string) {
                return (ListByActivity)super.setAlt(string);
            }

            public ListByActivity setFields(String string) {
                return (ListByActivity)super.setFields(string);
            }

            public ListByActivity setKey(String string) {
                return (ListByActivity)super.setKey(string);
            }

            public ListByActivity setOauthToken(String string) {
                return (ListByActivity)super.setOauthToken(string);
            }

            public ListByActivity setPrettyPrint(Boolean bl) {
                return (ListByActivity)super.setPrettyPrint(bl);
            }

            public ListByActivity setQuotaUser(String string) {
                return (ListByActivity)super.setQuotaUser(string);
            }

            public ListByActivity setUserIp(String string) {
                return (ListByActivity)super.setUserIp(string);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public ListByActivity setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListByActivity setCollection(String string) {
                this.collection = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByActivity setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByActivity setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public ListByActivity set(String string, Object object) {
                return (ListByActivity)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "people/{userId}/people/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String string) {
                this.collection = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest<Person> {
            private static final String REST_PATH = "people/{userId}";
            @Key
            private String userId;

            protected Get(String string) {
                super(Plus.this, "GET", REST_PATH, null, Person.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String string) {
                this.userId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Comments {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<CommentFeed> {
            private static final String REST_PATH = "activities/{activityId}/comments";
            @Key
            private String activityId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortOrder;

            protected List(String string) {
                super(Plus.this, "GET", REST_PATH, null, CommentFeed.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public List setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest<Comment> {
            private static final String REST_PATH = "comments/{commentId}";
            @Key
            private String commentId;

            protected Get(String string) {
                super(Plus.this, "GET", REST_PATH, null, Comment.class);
                this.commentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Activities {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Search search(String string) throws IOException {
            Search search = new Search(string);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)search);
            return search;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Search
        extends PlusRequest<ActivityFeed> {
            private static final String REST_PATH = "activities";
            @Key
            private String query;
            @Key
            private String language;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected Search(String string) {
                super(Plus.this, "GET", REST_PATH, null, ActivityFeed.class);
                this.query = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter query must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search setAlt(String string) {
                return (Search)super.setAlt(string);
            }

            public Search setFields(String string) {
                return (Search)super.setFields(string);
            }

            public Search setKey(String string) {
                return (Search)super.setKey(string);
            }

            public Search setOauthToken(String string) {
                return (Search)super.setOauthToken(string);
            }

            public Search setPrettyPrint(Boolean bl) {
                return (Search)super.setPrettyPrint(bl);
            }

            public Search setQuotaUser(String string) {
                return (Search)super.setQuotaUser(string);
            }

            public Search setUserIp(String string) {
                return (Search)super.setUserIp(string);
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Search setLanguage(String string) {
                this.language = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Search setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public Search set(String string, Object object) {
                return (Search)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest<ActivityFeed> {
            private static final String REST_PATH = "people/{userId}/activities/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Plus.this, "GET", REST_PATH, null, ActivityFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String string) {
                this.collection = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest<Activity> {
            private static final String REST_PATH = "activities/{activityId}";
            @Key
            private String activityId;

            protected Get(String string) {
                super(Plus.this, "GET", REST_PATH, null, Activity.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public Get setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

