/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.content;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.content.ShoppingContentRequest;
import com.google.api.services.content.ShoppingContentRequestInitializer;
import com.google.api.services.content.model.Account;
import com.google.api.services.content.model.AccountStatus;
import com.google.api.services.content.model.AccountTax;
import com.google.api.services.content.model.AccountsAuthInfoResponse;
import com.google.api.services.content.model.AccountsClaimWebsiteResponse;
import com.google.api.services.content.model.AccountsCustomBatchRequest;
import com.google.api.services.content.model.AccountsCustomBatchResponse;
import com.google.api.services.content.model.AccountsLinkRequest;
import com.google.api.services.content.model.AccountsLinkResponse;
import com.google.api.services.content.model.AccountsListResponse;
import com.google.api.services.content.model.AccountstatusesCustomBatchRequest;
import com.google.api.services.content.model.AccountstatusesCustomBatchResponse;
import com.google.api.services.content.model.AccountstatusesListResponse;
import com.google.api.services.content.model.AccounttaxCustomBatchRequest;
import com.google.api.services.content.model.AccounttaxCustomBatchResponse;
import com.google.api.services.content.model.AccounttaxListResponse;
import com.google.api.services.content.model.Datafeed;
import com.google.api.services.content.model.DatafeedStatus;
import com.google.api.services.content.model.DatafeedsCustomBatchRequest;
import com.google.api.services.content.model.DatafeedsCustomBatchResponse;
import com.google.api.services.content.model.DatafeedsFetchNowResponse;
import com.google.api.services.content.model.DatafeedsListResponse;
import com.google.api.services.content.model.DatafeedstatusesCustomBatchRequest;
import com.google.api.services.content.model.DatafeedstatusesCustomBatchResponse;
import com.google.api.services.content.model.DatafeedstatusesListResponse;
import com.google.api.services.content.model.InventoryCustomBatchRequest;
import com.google.api.services.content.model.InventoryCustomBatchResponse;
import com.google.api.services.content.model.InventorySetRequest;
import com.google.api.services.content.model.InventorySetResponse;
import com.google.api.services.content.model.LiaSettings;
import com.google.api.services.content.model.LiasettingsCustomBatchRequest;
import com.google.api.services.content.model.LiasettingsCustomBatchResponse;
import com.google.api.services.content.model.LiasettingsGetAccessibleGmbAccountsResponse;
import com.google.api.services.content.model.LiasettingsListPosDataProvidersResponse;
import com.google.api.services.content.model.LiasettingsListResponse;
import com.google.api.services.content.model.LiasettingsRequestGmbAccessResponse;
import com.google.api.services.content.model.LiasettingsRequestInventoryVerificationResponse;
import com.google.api.services.content.model.LiasettingsSetInventoryVerificationContactResponse;
import com.google.api.services.content.model.LiasettingsSetPosDataProviderResponse;
import com.google.api.services.content.model.MerchantOrderReturn;
import com.google.api.services.content.model.Order;
import com.google.api.services.content.model.OrderinvoicesCreateChargeInvoiceRequest;
import com.google.api.services.content.model.OrderinvoicesCreateChargeInvoiceResponse;
import com.google.api.services.content.model.OrderinvoicesCreateRefundInvoiceRequest;
import com.google.api.services.content.model.OrderinvoicesCreateRefundInvoiceResponse;
import com.google.api.services.content.model.OrderpaymentsNotifyAuthApprovedRequest;
import com.google.api.services.content.model.OrderpaymentsNotifyAuthApprovedResponse;
import com.google.api.services.content.model.OrderpaymentsNotifyAuthDeclinedRequest;
import com.google.api.services.content.model.OrderpaymentsNotifyAuthDeclinedResponse;
import com.google.api.services.content.model.OrderpaymentsNotifyChargeRequest;
import com.google.api.services.content.model.OrderpaymentsNotifyChargeResponse;
import com.google.api.services.content.model.OrderpaymentsNotifyRefundRequest;
import com.google.api.services.content.model.OrderpaymentsNotifyRefundResponse;
import com.google.api.services.content.model.OrderreportsListDisbursementsResponse;
import com.google.api.services.content.model.OrderreportsListTransactionsResponse;
import com.google.api.services.content.model.OrderreturnsListResponse;
import com.google.api.services.content.model.OrdersAcknowledgeRequest;
import com.google.api.services.content.model.OrdersAcknowledgeResponse;
import com.google.api.services.content.model.OrdersAdvanceTestOrderResponse;
import com.google.api.services.content.model.OrdersCancelLineItemRequest;
import com.google.api.services.content.model.OrdersCancelLineItemResponse;
import com.google.api.services.content.model.OrdersCancelRequest;
import com.google.api.services.content.model.OrdersCancelResponse;
import com.google.api.services.content.model.OrdersCancelTestOrderByCustomerRequest;
import com.google.api.services.content.model.OrdersCancelTestOrderByCustomerResponse;
import com.google.api.services.content.model.OrdersCreateTestOrderRequest;
import com.google.api.services.content.model.OrdersCreateTestOrderResponse;
import com.google.api.services.content.model.OrdersCreateTestReturnRequest;
import com.google.api.services.content.model.OrdersCreateTestReturnResponse;
import com.google.api.services.content.model.OrdersCustomBatchRequest;
import com.google.api.services.content.model.OrdersCustomBatchResponse;
import com.google.api.services.content.model.OrdersGetByMerchantOrderIdResponse;
import com.google.api.services.content.model.OrdersGetTestOrderTemplateResponse;
import com.google.api.services.content.model.OrdersInStoreRefundLineItemRequest;
import com.google.api.services.content.model.OrdersInStoreRefundLineItemResponse;
import com.google.api.services.content.model.OrdersListResponse;
import com.google.api.services.content.model.OrdersRefundRequest;
import com.google.api.services.content.model.OrdersRefundResponse;
import com.google.api.services.content.model.OrdersRejectReturnLineItemRequest;
import com.google.api.services.content.model.OrdersRejectReturnLineItemResponse;
import com.google.api.services.content.model.OrdersReturnLineItemRequest;
import com.google.api.services.content.model.OrdersReturnLineItemResponse;
import com.google.api.services.content.model.OrdersReturnRefundLineItemRequest;
import com.google.api.services.content.model.OrdersReturnRefundLineItemResponse;
import com.google.api.services.content.model.OrdersSetLineItemMetadataRequest;
import com.google.api.services.content.model.OrdersSetLineItemMetadataResponse;
import com.google.api.services.content.model.OrdersShipLineItemsRequest;
import com.google.api.services.content.model.OrdersShipLineItemsResponse;
import com.google.api.services.content.model.OrdersUpdateLineItemShippingDetailsRequest;
import com.google.api.services.content.model.OrdersUpdateLineItemShippingDetailsResponse;
import com.google.api.services.content.model.OrdersUpdateMerchantOrderIdRequest;
import com.google.api.services.content.model.OrdersUpdateMerchantOrderIdResponse;
import com.google.api.services.content.model.OrdersUpdateShipmentRequest;
import com.google.api.services.content.model.OrdersUpdateShipmentResponse;
import com.google.api.services.content.model.PosCustomBatchRequest;
import com.google.api.services.content.model.PosCustomBatchResponse;
import com.google.api.services.content.model.PosInventoryRequest;
import com.google.api.services.content.model.PosInventoryResponse;
import com.google.api.services.content.model.PosListResponse;
import com.google.api.services.content.model.PosSaleRequest;
import com.google.api.services.content.model.PosSaleResponse;
import com.google.api.services.content.model.PosStore;
import com.google.api.services.content.model.Product;
import com.google.api.services.content.model.ProductStatus;
import com.google.api.services.content.model.ProductsCustomBatchRequest;
import com.google.api.services.content.model.ProductsCustomBatchResponse;
import com.google.api.services.content.model.ProductsListResponse;
import com.google.api.services.content.model.ProductstatusesCustomBatchRequest;
import com.google.api.services.content.model.ProductstatusesCustomBatchResponse;
import com.google.api.services.content.model.ProductstatusesListResponse;
import com.google.api.services.content.model.ShippingSettings;
import com.google.api.services.content.model.ShippingsettingsCustomBatchRequest;
import com.google.api.services.content.model.ShippingsettingsCustomBatchResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedCarriersResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedHolidaysResponse;
import com.google.api.services.content.model.ShippingsettingsListResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingContent
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "content/v2/";
    public static final String DEFAULT_BATCH_PATH = "batch/content/v2";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/content/v2/";

    public ShoppingContent(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    ShoppingContent(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    public Accountstatuses accountstatuses() {
        return new Accountstatuses();
    }

    public Accounttax accounttax() {
        return new Accounttax();
    }

    public Datafeeds datafeeds() {
        return new Datafeeds();
    }

    public Datafeedstatuses datafeedstatuses() {
        return new Datafeedstatuses();
    }

    public Inventory inventory() {
        return new Inventory();
    }

    public Liasettings liasettings() {
        return new Liasettings();
    }

    public Orderinvoices orderinvoices() {
        return new Orderinvoices();
    }

    public Orderpayments orderpayments() {
        return new Orderpayments();
    }

    public Orderreports orderreports() {
        return new Orderreports();
    }

    public Orderreturns orderreturns() {
        return new Orderreturns();
    }

    public Orders orders() {
        return new Orders();
    }

    public Pos pos() {
        return new Pos();
    }

    public Products products() {
        return new Products();
    }

    public Productstatuses productstatuses() {
        return new Productstatuses();
    }

    public Shippingsettings shippingsettings() {
        return new Shippingsettings();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Content API for Shopping library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, ShoppingContent.DEFAULT_ROOT_URL, ShoppingContent.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ShoppingContent.DEFAULT_BATCH_PATH);
        }

        public ShoppingContent build() {
            return new ShoppingContent(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setShoppingContentRequestInitializer(ShoppingContentRequestInitializer shoppingContentRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)shoppingContentRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Shippingsettings {
        public Custombatch custombatch(ShippingsettingsCustomBatchRequest shippingsettingsCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(shippingsettingsCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Get get = new Get(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Getsupportedcarriers getsupportedcarriers(BigInteger bigInteger) throws IOException {
            Getsupportedcarriers getsupportedcarriers = new Getsupportedcarriers(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)getsupportedcarriers);
            return getsupportedcarriers;
        }

        public Getsupportedholidays getsupportedholidays(BigInteger bigInteger) throws IOException {
            Getsupportedholidays getsupportedholidays = new Getsupportedholidays(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)getsupportedholidays);
            return getsupportedholidays;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(BigInteger bigInteger, BigInteger bigInteger2, ShippingSettings shippingSettings) throws IOException {
            Patch patch = new Patch(bigInteger, bigInteger2, shippingSettings);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(BigInteger bigInteger, BigInteger bigInteger2, ShippingSettings shippingSettings) throws IOException {
            Update update = new Update(bigInteger, bigInteger2, shippingSettings);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ShoppingContentRequest<ShippingSettings> {
            private static final String REST_PATH = "{merchantId}/shippingsettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Update(BigInteger bigInteger, BigInteger bigInteger2, ShippingSettings shippingSettings) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)shippingSettings, ShippingSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Update setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ShoppingContentRequest<ShippingSettings> {
            private static final String REST_PATH = "{merchantId}/shippingsettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Patch(BigInteger bigInteger, BigInteger bigInteger2, ShippingSettings shippingSettings) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)shippingSettings, ShippingSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Patch setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Patch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<ShippingsettingsListResponse> {
            private static final String REST_PATH = "{merchantId}/shippingsettings";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Getsupportedholidays
        extends ShoppingContentRequest<ShippingsettingsGetSupportedHolidaysResponse> {
            private static final String REST_PATH = "{merchantId}/supportedHolidays";
            @Key
            private BigInteger merchantId;

            protected Getsupportedholidays(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedHolidaysResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedholidays setAlt(String string) {
                return (Getsupportedholidays)super.setAlt(string);
            }

            public Getsupportedholidays setFields(String string) {
                return (Getsupportedholidays)super.setFields(string);
            }

            public Getsupportedholidays setKey(String string) {
                return (Getsupportedholidays)super.setKey(string);
            }

            public Getsupportedholidays setOauthToken(String string) {
                return (Getsupportedholidays)super.setOauthToken(string);
            }

            public Getsupportedholidays setPrettyPrint(Boolean bl) {
                return (Getsupportedholidays)super.setPrettyPrint(bl);
            }

            public Getsupportedholidays setQuotaUser(String string) {
                return (Getsupportedholidays)super.setQuotaUser(string);
            }

            public Getsupportedholidays setUserIp(String string) {
                return (Getsupportedholidays)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedholidays setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            @Override
            public Getsupportedholidays set(String string, Object object) {
                return (Getsupportedholidays)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Getsupportedcarriers
        extends ShoppingContentRequest<ShippingsettingsGetSupportedCarriersResponse> {
            private static final String REST_PATH = "{merchantId}/supportedCarriers";
            @Key
            private BigInteger merchantId;

            protected Getsupportedcarriers(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedCarriersResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedcarriers setAlt(String string) {
                return (Getsupportedcarriers)super.setAlt(string);
            }

            public Getsupportedcarriers setFields(String string) {
                return (Getsupportedcarriers)super.setFields(string);
            }

            public Getsupportedcarriers setKey(String string) {
                return (Getsupportedcarriers)super.setKey(string);
            }

            public Getsupportedcarriers setOauthToken(String string) {
                return (Getsupportedcarriers)super.setOauthToken(string);
            }

            public Getsupportedcarriers setPrettyPrint(Boolean bl) {
                return (Getsupportedcarriers)super.setPrettyPrint(bl);
            }

            public Getsupportedcarriers setQuotaUser(String string) {
                return (Getsupportedcarriers)super.setQuotaUser(string);
            }

            public Getsupportedcarriers setUserIp(String string) {
                return (Getsupportedcarriers)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedcarriers setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            @Override
            public Getsupportedcarriers set(String string, Object object) {
                return (Getsupportedcarriers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<ShippingSettings> {
            private static final String REST_PATH = "{merchantId}/shippingsettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<ShippingsettingsCustomBatchResponse> {
            private static final String REST_PATH = "shippingsettings/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(ShippingsettingsCustomBatchRequest shippingsettingsCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)shippingsettingsCustomBatchRequest, ShippingsettingsCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Productstatuses {
        public Custombatch custombatch(ProductstatusesCustomBatchRequest productstatusesCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(productstatusesCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Get get(BigInteger bigInteger, String string) throws IOException {
            Get get = new Get(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<ProductstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/productstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private java.util.List<String> destinations;
            @Key
            private Boolean includeAttributes;
            @Key
            private Boolean includeInvalidInsertedItems;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public List setDestinations(java.util.List<String> list) {
                this.destinations = list;
                return this;
            }

            public Boolean getIncludeAttributes() {
                return this.includeAttributes;
            }

            public List setIncludeAttributes(Boolean bl) {
                this.includeAttributes = bl;
                return this;
            }

            public Boolean getIncludeInvalidInsertedItems() {
                return this.includeInvalidInsertedItems;
            }

            public List setIncludeInvalidInsertedItems(Boolean bl) {
                this.includeInvalidInsertedItems = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<ProductStatus> {
            private static final String REST_PATH = "{merchantId}/productstatuses/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private java.util.List<String> destinations;
            @Key
            private Boolean includeAttributes;

            protected Get(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String string) {
                this.productId = string;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public Get setDestinations(java.util.List<String> list) {
                this.destinations = list;
                return this;
            }

            public Boolean getIncludeAttributes() {
                return this.includeAttributes;
            }

            public Get setIncludeAttributes(Boolean bl) {
                this.includeAttributes = bl;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<ProductstatusesCustomBatchResponse> {
            private static final String REST_PATH = "productstatuses/batch";
            @Key
            private Boolean includeAttributes;

            protected Custombatch(ProductstatusesCustomBatchRequest productstatusesCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)productstatusesCustomBatchRequest, ProductstatusesCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getIncludeAttributes() {
                return this.includeAttributes;
            }

            public Custombatch setIncludeAttributes(Boolean bl) {
                this.includeAttributes = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Products {
        public Custombatch custombatch(ProductsCustomBatchRequest productsCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(productsCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Delete delete(BigInteger bigInteger, String string) throws IOException {
            Delete delete = new Delete(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(BigInteger bigInteger, String string) throws IOException {
            Get get = new Get(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(BigInteger bigInteger, Product product) throws IOException {
            Insert insert = new Insert(bigInteger, product);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<ProductsListResponse> {
            private static final String REST_PATH = "{merchantId}/products";
            @Key
            private BigInteger merchantId;
            @Key
            private Boolean includeInvalidInsertedItems;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Boolean getIncludeInvalidInsertedItems() {
                return this.includeInvalidInsertedItems;
            }

            public List setIncludeInvalidInsertedItems(Boolean bl) {
                this.includeInvalidInsertedItems = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products";
            @Key
            private BigInteger merchantId;
            @Key
            private Boolean dryRun;

            protected Insert(BigInteger bigInteger, Product product) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)product, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.checkRequiredParameter((Object)product, "content");
                this.checkRequiredParameter(product.getChannel(), "Product.getChannel()");
                this.checkRequiredParameter((Object)product, "content");
                this.checkRequiredParameter(product.getContentLanguage(), "Product.getContentLanguage()");
                this.checkRequiredParameter((Object)product, "content");
                this.checkRequiredParameter(product.getOfferId(), "Product.getOfferId()");
                this.checkRequiredParameter((Object)product, "content");
                this.checkRequiredParameter(product.getTargetCountry(), "Product.getTargetCountry()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Insert setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;

            protected Get(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String string) {
                this.productId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private Boolean dryRun;

            protected Delete(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter productId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Delete setProductId(String string) {
                this.productId = string;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Delete setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<ProductsCustomBatchResponse> {
            private static final String REST_PATH = "products/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(ProductsCustomBatchRequest productsCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)productsCustomBatchRequest, ProductsCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Pos {
        public Custombatch custombatch(PosCustomBatchRequest posCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(posCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Delete delete(BigInteger bigInteger, BigInteger bigInteger2, String string) throws IOException {
            Delete delete = new Delete(bigInteger, bigInteger2, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2, String string) throws IOException {
            Get get = new Get(bigInteger, bigInteger2, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(BigInteger bigInteger, BigInteger bigInteger2, PosStore posStore) throws IOException {
            Insert insert = new Insert(bigInteger, bigInteger2, posStore);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Inventory inventory(BigInteger bigInteger, BigInteger bigInteger2, PosInventoryRequest posInventoryRequest) throws IOException {
            Inventory inventory = new Inventory(bigInteger, bigInteger2, posInventoryRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)inventory);
            return inventory;
        }

        public List list(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            List list = new List(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Sale sale(BigInteger bigInteger, BigInteger bigInteger2, PosSaleRequest posSaleRequest) throws IOException {
            Sale sale = new Sale(bigInteger, bigInteger2, posSaleRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)sale);
            return sale;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Sale
        extends ShoppingContentRequest<PosSaleResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/sale";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private Boolean dryRun;

            protected Sale(BigInteger bigInteger, BigInteger bigInteger2, PosSaleRequest posSaleRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)posSaleRequest, PosSaleResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter targetMerchantId must be specified.");
                this.checkRequiredParameter((Object)posSaleRequest, "content");
                this.checkRequiredParameter(posSaleRequest.getContentLanguage(), "PosSaleRequest.getContentLanguage()");
                this.checkRequiredParameter((Object)posSaleRequest, "content");
                this.checkRequiredParameter(posSaleRequest.getItemId(), "PosSaleRequest.getItemId()");
                this.checkRequiredParameter((Object)posSaleRequest, "content");
                this.checkRequiredParameter(posSaleRequest.getQuantity(), "PosSaleRequest.getQuantity()");
                this.checkRequiredParameter((Object)posSaleRequest, "content");
                this.checkRequiredParameter(posSaleRequest.getStoreCode(), "PosSaleRequest.getStoreCode()");
                this.checkRequiredParameter((Object)posSaleRequest, "content");
                this.checkRequiredParameter(posSaleRequest.getTargetCountry(), "PosSaleRequest.getTargetCountry()");
                this.checkRequiredParameter((Object)posSaleRequest, "content");
                this.checkRequiredParameter(posSaleRequest.getTimestamp(), "PosSaleRequest.getTimestamp()");
            }

            public Sale setAlt(String string) {
                return (Sale)super.setAlt(string);
            }

            public Sale setFields(String string) {
                return (Sale)super.setFields(string);
            }

            public Sale setKey(String string) {
                return (Sale)super.setKey(string);
            }

            public Sale setOauthToken(String string) {
                return (Sale)super.setOauthToken(string);
            }

            public Sale setPrettyPrint(Boolean bl) {
                return (Sale)super.setPrettyPrint(bl);
            }

            public Sale setQuotaUser(String string) {
                return (Sale)super.setQuotaUser(string);
            }

            public Sale setUserIp(String string) {
                return (Sale)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Sale setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Sale setTargetMerchantId(BigInteger bigInteger) {
                this.targetMerchantId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Sale setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Sale set(String string, Object object) {
                return (Sale)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<PosListResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected List(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PosListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public List setTargetMerchantId(BigInteger bigInteger) {
                this.targetMerchantId = bigInteger;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Inventory
        extends ShoppingContentRequest<PosInventoryResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/inventory";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private Boolean dryRun;

            protected Inventory(BigInteger bigInteger, BigInteger bigInteger2, PosInventoryRequest posInventoryRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)posInventoryRequest, PosInventoryResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter targetMerchantId must be specified.");
                this.checkRequiredParameter((Object)posInventoryRequest, "content");
                this.checkRequiredParameter(posInventoryRequest.getContentLanguage(), "PosInventoryRequest.getContentLanguage()");
                this.checkRequiredParameter((Object)posInventoryRequest, "content");
                this.checkRequiredParameter(posInventoryRequest.getItemId(), "PosInventoryRequest.getItemId()");
                this.checkRequiredParameter((Object)posInventoryRequest, "content");
                this.checkRequiredParameter(posInventoryRequest.getQuantity(), "PosInventoryRequest.getQuantity()");
                this.checkRequiredParameter((Object)posInventoryRequest, "content");
                this.checkRequiredParameter(posInventoryRequest.getStoreCode(), "PosInventoryRequest.getStoreCode()");
                this.checkRequiredParameter((Object)posInventoryRequest, "content");
                this.checkRequiredParameter(posInventoryRequest.getTargetCountry(), "PosInventoryRequest.getTargetCountry()");
                this.checkRequiredParameter((Object)posInventoryRequest, "content");
                this.checkRequiredParameter(posInventoryRequest.getTimestamp(), "PosInventoryRequest.getTimestamp()");
            }

            public Inventory setAlt(String string) {
                return (Inventory)super.setAlt(string);
            }

            public Inventory setFields(String string) {
                return (Inventory)super.setFields(string);
            }

            public Inventory setKey(String string) {
                return (Inventory)super.setKey(string);
            }

            public Inventory setOauthToken(String string) {
                return (Inventory)super.setOauthToken(string);
            }

            public Inventory setPrettyPrint(Boolean bl) {
                return (Inventory)super.setPrettyPrint(bl);
            }

            public Inventory setQuotaUser(String string) {
                return (Inventory)super.setQuotaUser(string);
            }

            public Inventory setUserIp(String string) {
                return (Inventory)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Inventory setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Inventory setTargetMerchantId(BigInteger bigInteger) {
                this.targetMerchantId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Inventory setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Inventory set(String string, Object object) {
                return (Inventory)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ShoppingContentRequest<PosStore> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private Boolean dryRun;

            protected Insert(BigInteger bigInteger, BigInteger bigInteger2, PosStore posStore) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)posStore, PosStore.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter targetMerchantId must be specified.");
                this.checkRequiredParameter((Object)posStore, "content");
                this.checkRequiredParameter(posStore.getStoreAddress(), "PosStore.getStoreAddress()");
                this.checkRequiredParameter((Object)posStore, "content");
                this.checkRequiredParameter(posStore.getStoreCode(), "PosStore.getStoreCode()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Insert setTargetMerchantId(BigInteger bigInteger) {
                this.targetMerchantId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Insert setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<PosStore> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store/{storeCode}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private String storeCode;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PosStore.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter targetMerchantId must be specified.");
                this.storeCode = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter storeCode must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Get setTargetMerchantId(BigInteger bigInteger) {
                this.targetMerchantId = bigInteger;
                return this;
            }

            public String getStoreCode() {
                return this.storeCode;
            }

            public Get setStoreCode(String string) {
                this.storeCode = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store/{storeCode}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private String storeCode;
            @Key
            private Boolean dryRun;

            protected Delete(BigInteger bigInteger, BigInteger bigInteger2, String string) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter targetMerchantId must be specified.");
                this.storeCode = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter storeCode must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Delete setTargetMerchantId(BigInteger bigInteger) {
                this.targetMerchantId = bigInteger;
                return this;
            }

            public String getStoreCode() {
                return this.storeCode;
            }

            public Delete setStoreCode(String string) {
                this.storeCode = string;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Delete setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<PosCustomBatchResponse> {
            private static final String REST_PATH = "pos/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(PosCustomBatchRequest posCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)posCustomBatchRequest, PosCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Orders {
        public Acknowledge acknowledge(BigInteger bigInteger, String string, OrdersAcknowledgeRequest ordersAcknowledgeRequest) throws IOException {
            Acknowledge acknowledge = new Acknowledge(bigInteger, string, ordersAcknowledgeRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)acknowledge);
            return acknowledge;
        }

        public Advancetestorder advancetestorder(BigInteger bigInteger, String string) throws IOException {
            Advancetestorder advancetestorder = new Advancetestorder(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)advancetestorder);
            return advancetestorder;
        }

        public Cancel cancel(BigInteger bigInteger, String string, OrdersCancelRequest ordersCancelRequest) throws IOException {
            Cancel cancel = new Cancel(bigInteger, string, ordersCancelRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)cancel);
            return cancel;
        }

        public Cancellineitem cancellineitem(BigInteger bigInteger, String string, OrdersCancelLineItemRequest ordersCancelLineItemRequest) throws IOException {
            Cancellineitem cancellineitem = new Cancellineitem(bigInteger, string, ordersCancelLineItemRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)cancellineitem);
            return cancellineitem;
        }

        public Canceltestorderbycustomer canceltestorderbycustomer(BigInteger bigInteger, String string, OrdersCancelTestOrderByCustomerRequest ordersCancelTestOrderByCustomerRequest) throws IOException {
            Canceltestorderbycustomer canceltestorderbycustomer = new Canceltestorderbycustomer(bigInteger, string, ordersCancelTestOrderByCustomerRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)canceltestorderbycustomer);
            return canceltestorderbycustomer;
        }

        public Createtestorder createtestorder(BigInteger bigInteger, OrdersCreateTestOrderRequest ordersCreateTestOrderRequest) throws IOException {
            Createtestorder createtestorder = new Createtestorder(bigInteger, ordersCreateTestOrderRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)createtestorder);
            return createtestorder;
        }

        public Createtestreturn createtestreturn(BigInteger bigInteger, String string, OrdersCreateTestReturnRequest ordersCreateTestReturnRequest) throws IOException {
            Createtestreturn createtestreturn = new Createtestreturn(bigInteger, string, ordersCreateTestReturnRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)createtestreturn);
            return createtestreturn;
        }

        public Custombatch custombatch(OrdersCustomBatchRequest ordersCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(ordersCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Get get(BigInteger bigInteger, String string) throws IOException {
            Get get = new Get(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Getbymerchantorderid getbymerchantorderid(BigInteger bigInteger, String string) throws IOException {
            Getbymerchantorderid getbymerchantorderid = new Getbymerchantorderid(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)getbymerchantorderid);
            return getbymerchantorderid;
        }

        public Gettestordertemplate gettestordertemplate(BigInteger bigInteger, String string) throws IOException {
            Gettestordertemplate gettestordertemplate = new Gettestordertemplate(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)gettestordertemplate);
            return gettestordertemplate;
        }

        public Instorerefundlineitem instorerefundlineitem(BigInteger bigInteger, String string, OrdersInStoreRefundLineItemRequest ordersInStoreRefundLineItemRequest) throws IOException {
            Instorerefundlineitem instorerefundlineitem = new Instorerefundlineitem(bigInteger, string, ordersInStoreRefundLineItemRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)instorerefundlineitem);
            return instorerefundlineitem;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Refund refund(BigInteger bigInteger, String string, OrdersRefundRequest ordersRefundRequest) throws IOException {
            Refund refund = new Refund(bigInteger, string, ordersRefundRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)refund);
            return refund;
        }

        public Rejectreturnlineitem rejectreturnlineitem(BigInteger bigInteger, String string, OrdersRejectReturnLineItemRequest ordersRejectReturnLineItemRequest) throws IOException {
            Rejectreturnlineitem rejectreturnlineitem = new Rejectreturnlineitem(bigInteger, string, ordersRejectReturnLineItemRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)rejectreturnlineitem);
            return rejectreturnlineitem;
        }

        public Returnlineitem returnlineitem(BigInteger bigInteger, String string, OrdersReturnLineItemRequest ordersReturnLineItemRequest) throws IOException {
            Returnlineitem returnlineitem = new Returnlineitem(bigInteger, string, ordersReturnLineItemRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)returnlineitem);
            return returnlineitem;
        }

        public Returnrefundlineitem returnrefundlineitem(BigInteger bigInteger, String string, OrdersReturnRefundLineItemRequest ordersReturnRefundLineItemRequest) throws IOException {
            Returnrefundlineitem returnrefundlineitem = new Returnrefundlineitem(bigInteger, string, ordersReturnRefundLineItemRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)returnrefundlineitem);
            return returnrefundlineitem;
        }

        public Setlineitemmetadata setlineitemmetadata(BigInteger bigInteger, String string, OrdersSetLineItemMetadataRequest ordersSetLineItemMetadataRequest) throws IOException {
            Setlineitemmetadata setlineitemmetadata = new Setlineitemmetadata(bigInteger, string, ordersSetLineItemMetadataRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)setlineitemmetadata);
            return setlineitemmetadata;
        }

        public Shiplineitems shiplineitems(BigInteger bigInteger, String string, OrdersShipLineItemsRequest ordersShipLineItemsRequest) throws IOException {
            Shiplineitems shiplineitems = new Shiplineitems(bigInteger, string, ordersShipLineItemsRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)shiplineitems);
            return shiplineitems;
        }

        public Updatelineitemshippingdetails updatelineitemshippingdetails(BigInteger bigInteger, String string, OrdersUpdateLineItemShippingDetailsRequest ordersUpdateLineItemShippingDetailsRequest) throws IOException {
            Updatelineitemshippingdetails updatelineitemshippingdetails = new Updatelineitemshippingdetails(bigInteger, string, ordersUpdateLineItemShippingDetailsRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)updatelineitemshippingdetails);
            return updatelineitemshippingdetails;
        }

        public Updatemerchantorderid updatemerchantorderid(BigInteger bigInteger, String string, OrdersUpdateMerchantOrderIdRequest ordersUpdateMerchantOrderIdRequest) throws IOException {
            Updatemerchantorderid updatemerchantorderid = new Updatemerchantorderid(bigInteger, string, ordersUpdateMerchantOrderIdRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)updatemerchantorderid);
            return updatemerchantorderid;
        }

        public Updateshipment updateshipment(BigInteger bigInteger, String string, OrdersUpdateShipmentRequest ordersUpdateShipmentRequest) throws IOException {
            Updateshipment updateshipment = new Updateshipment(bigInteger, string, ordersUpdateShipmentRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)updateshipment);
            return updateshipment;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Updateshipment
        extends ShoppingContentRequest<OrdersUpdateShipmentResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/updateShipment";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Updateshipment(BigInteger bigInteger, String string, OrdersUpdateShipmentRequest ordersUpdateShipmentRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersUpdateShipmentRequest, OrdersUpdateShipmentResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Updateshipment setAlt(String string) {
                return (Updateshipment)super.setAlt(string);
            }

            public Updateshipment setFields(String string) {
                return (Updateshipment)super.setFields(string);
            }

            public Updateshipment setKey(String string) {
                return (Updateshipment)super.setKey(string);
            }

            public Updateshipment setOauthToken(String string) {
                return (Updateshipment)super.setOauthToken(string);
            }

            public Updateshipment setPrettyPrint(Boolean bl) {
                return (Updateshipment)super.setPrettyPrint(bl);
            }

            public Updateshipment setQuotaUser(String string) {
                return (Updateshipment)super.setQuotaUser(string);
            }

            public Updateshipment setUserIp(String string) {
                return (Updateshipment)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updateshipment setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Updateshipment setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Updateshipment set(String string, Object object) {
                return (Updateshipment)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Updatemerchantorderid
        extends ShoppingContentRequest<OrdersUpdateMerchantOrderIdResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/updateMerchantOrderId";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Updatemerchantorderid(BigInteger bigInteger, String string, OrdersUpdateMerchantOrderIdRequest ordersUpdateMerchantOrderIdRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersUpdateMerchantOrderIdRequest, OrdersUpdateMerchantOrderIdResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Updatemerchantorderid setAlt(String string) {
                return (Updatemerchantorderid)super.setAlt(string);
            }

            public Updatemerchantorderid setFields(String string) {
                return (Updatemerchantorderid)super.setFields(string);
            }

            public Updatemerchantorderid setKey(String string) {
                return (Updatemerchantorderid)super.setKey(string);
            }

            public Updatemerchantorderid setOauthToken(String string) {
                return (Updatemerchantorderid)super.setOauthToken(string);
            }

            public Updatemerchantorderid setPrettyPrint(Boolean bl) {
                return (Updatemerchantorderid)super.setPrettyPrint(bl);
            }

            public Updatemerchantorderid setQuotaUser(String string) {
                return (Updatemerchantorderid)super.setQuotaUser(string);
            }

            public Updatemerchantorderid setUserIp(String string) {
                return (Updatemerchantorderid)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updatemerchantorderid setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Updatemerchantorderid setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Updatemerchantorderid set(String string, Object object) {
                return (Updatemerchantorderid)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Updatelineitemshippingdetails
        extends ShoppingContentRequest<OrdersUpdateLineItemShippingDetailsResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/updateLineItemShippingDetails";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Updatelineitemshippingdetails(BigInteger bigInteger, String string, OrdersUpdateLineItemShippingDetailsRequest ordersUpdateLineItemShippingDetailsRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersUpdateLineItemShippingDetailsRequest, OrdersUpdateLineItemShippingDetailsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Updatelineitemshippingdetails setAlt(String string) {
                return (Updatelineitemshippingdetails)super.setAlt(string);
            }

            public Updatelineitemshippingdetails setFields(String string) {
                return (Updatelineitemshippingdetails)super.setFields(string);
            }

            public Updatelineitemshippingdetails setKey(String string) {
                return (Updatelineitemshippingdetails)super.setKey(string);
            }

            public Updatelineitemshippingdetails setOauthToken(String string) {
                return (Updatelineitemshippingdetails)super.setOauthToken(string);
            }

            public Updatelineitemshippingdetails setPrettyPrint(Boolean bl) {
                return (Updatelineitemshippingdetails)super.setPrettyPrint(bl);
            }

            public Updatelineitemshippingdetails setQuotaUser(String string) {
                return (Updatelineitemshippingdetails)super.setQuotaUser(string);
            }

            public Updatelineitemshippingdetails setUserIp(String string) {
                return (Updatelineitemshippingdetails)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updatelineitemshippingdetails setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Updatelineitemshippingdetails setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Updatelineitemshippingdetails set(String string, Object object) {
                return (Updatelineitemshippingdetails)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Shiplineitems
        extends ShoppingContentRequest<OrdersShipLineItemsResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/shipLineItems";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Shiplineitems(BigInteger bigInteger, String string, OrdersShipLineItemsRequest ordersShipLineItemsRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersShipLineItemsRequest, OrdersShipLineItemsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Shiplineitems setAlt(String string) {
                return (Shiplineitems)super.setAlt(string);
            }

            public Shiplineitems setFields(String string) {
                return (Shiplineitems)super.setFields(string);
            }

            public Shiplineitems setKey(String string) {
                return (Shiplineitems)super.setKey(string);
            }

            public Shiplineitems setOauthToken(String string) {
                return (Shiplineitems)super.setOauthToken(string);
            }

            public Shiplineitems setPrettyPrint(Boolean bl) {
                return (Shiplineitems)super.setPrettyPrint(bl);
            }

            public Shiplineitems setQuotaUser(String string) {
                return (Shiplineitems)super.setQuotaUser(string);
            }

            public Shiplineitems setUserIp(String string) {
                return (Shiplineitems)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Shiplineitems setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Shiplineitems setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Shiplineitems set(String string, Object object) {
                return (Shiplineitems)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Setlineitemmetadata
        extends ShoppingContentRequest<OrdersSetLineItemMetadataResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/setLineItemMetadata";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Setlineitemmetadata(BigInteger bigInteger, String string, OrdersSetLineItemMetadataRequest ordersSetLineItemMetadataRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersSetLineItemMetadataRequest, OrdersSetLineItemMetadataResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Setlineitemmetadata setAlt(String string) {
                return (Setlineitemmetadata)super.setAlt(string);
            }

            public Setlineitemmetadata setFields(String string) {
                return (Setlineitemmetadata)super.setFields(string);
            }

            public Setlineitemmetadata setKey(String string) {
                return (Setlineitemmetadata)super.setKey(string);
            }

            public Setlineitemmetadata setOauthToken(String string) {
                return (Setlineitemmetadata)super.setOauthToken(string);
            }

            public Setlineitemmetadata setPrettyPrint(Boolean bl) {
                return (Setlineitemmetadata)super.setPrettyPrint(bl);
            }

            public Setlineitemmetadata setQuotaUser(String string) {
                return (Setlineitemmetadata)super.setQuotaUser(string);
            }

            public Setlineitemmetadata setUserIp(String string) {
                return (Setlineitemmetadata)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setlineitemmetadata setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Setlineitemmetadata setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Setlineitemmetadata set(String string, Object object) {
                return (Setlineitemmetadata)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Returnrefundlineitem
        extends ShoppingContentRequest<OrdersReturnRefundLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/returnRefundLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Returnrefundlineitem(BigInteger bigInteger, String string, OrdersReturnRefundLineItemRequest ordersReturnRefundLineItemRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersReturnRefundLineItemRequest, OrdersReturnRefundLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Returnrefundlineitem setAlt(String string) {
                return (Returnrefundlineitem)super.setAlt(string);
            }

            public Returnrefundlineitem setFields(String string) {
                return (Returnrefundlineitem)super.setFields(string);
            }

            public Returnrefundlineitem setKey(String string) {
                return (Returnrefundlineitem)super.setKey(string);
            }

            public Returnrefundlineitem setOauthToken(String string) {
                return (Returnrefundlineitem)super.setOauthToken(string);
            }

            public Returnrefundlineitem setPrettyPrint(Boolean bl) {
                return (Returnrefundlineitem)super.setPrettyPrint(bl);
            }

            public Returnrefundlineitem setQuotaUser(String string) {
                return (Returnrefundlineitem)super.setQuotaUser(string);
            }

            public Returnrefundlineitem setUserIp(String string) {
                return (Returnrefundlineitem)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Returnrefundlineitem setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Returnrefundlineitem setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Returnrefundlineitem set(String string, Object object) {
                return (Returnrefundlineitem)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Returnlineitem
        extends ShoppingContentRequest<OrdersReturnLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/returnLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Returnlineitem(BigInteger bigInteger, String string, OrdersReturnLineItemRequest ordersReturnLineItemRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersReturnLineItemRequest, OrdersReturnLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Returnlineitem setAlt(String string) {
                return (Returnlineitem)super.setAlt(string);
            }

            public Returnlineitem setFields(String string) {
                return (Returnlineitem)super.setFields(string);
            }

            public Returnlineitem setKey(String string) {
                return (Returnlineitem)super.setKey(string);
            }

            public Returnlineitem setOauthToken(String string) {
                return (Returnlineitem)super.setOauthToken(string);
            }

            public Returnlineitem setPrettyPrint(Boolean bl) {
                return (Returnlineitem)super.setPrettyPrint(bl);
            }

            public Returnlineitem setQuotaUser(String string) {
                return (Returnlineitem)super.setQuotaUser(string);
            }

            public Returnlineitem setUserIp(String string) {
                return (Returnlineitem)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Returnlineitem setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Returnlineitem setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Returnlineitem set(String string, Object object) {
                return (Returnlineitem)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Rejectreturnlineitem
        extends ShoppingContentRequest<OrdersRejectReturnLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/rejectReturnLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Rejectreturnlineitem(BigInteger bigInteger, String string, OrdersRejectReturnLineItemRequest ordersRejectReturnLineItemRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersRejectReturnLineItemRequest, OrdersRejectReturnLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Rejectreturnlineitem setAlt(String string) {
                return (Rejectreturnlineitem)super.setAlt(string);
            }

            public Rejectreturnlineitem setFields(String string) {
                return (Rejectreturnlineitem)super.setFields(string);
            }

            public Rejectreturnlineitem setKey(String string) {
                return (Rejectreturnlineitem)super.setKey(string);
            }

            public Rejectreturnlineitem setOauthToken(String string) {
                return (Rejectreturnlineitem)super.setOauthToken(string);
            }

            public Rejectreturnlineitem setPrettyPrint(Boolean bl) {
                return (Rejectreturnlineitem)super.setPrettyPrint(bl);
            }

            public Rejectreturnlineitem setQuotaUser(String string) {
                return (Rejectreturnlineitem)super.setQuotaUser(string);
            }

            public Rejectreturnlineitem setUserIp(String string) {
                return (Rejectreturnlineitem)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Rejectreturnlineitem setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Rejectreturnlineitem setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Rejectreturnlineitem set(String string, Object object) {
                return (Rejectreturnlineitem)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Refund
        extends ShoppingContentRequest<OrdersRefundResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/refund";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Refund(BigInteger bigInteger, String string, OrdersRefundRequest ordersRefundRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersRefundRequest, OrdersRefundResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Refund setAlt(String string) {
                return (Refund)super.setAlt(string);
            }

            public Refund setFields(String string) {
                return (Refund)super.setFields(string);
            }

            public Refund setKey(String string) {
                return (Refund)super.setKey(string);
            }

            public Refund setOauthToken(String string) {
                return (Refund)super.setOauthToken(string);
            }

            public Refund setPrettyPrint(Boolean bl) {
                return (Refund)super.setPrettyPrint(bl);
            }

            public Refund setQuotaUser(String string) {
                return (Refund)super.setQuotaUser(string);
            }

            public Refund setUserIp(String string) {
                return (Refund)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Refund setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Refund setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Refund set(String string, Object object) {
                return (Refund)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<OrdersListResponse> {
            private static final String REST_PATH = "{merchantId}/orders";
            @Key
            private BigInteger merchantId;
            @Key
            private Boolean acknowledged;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String placedDateEnd;
            @Key
            private String placedDateStart;
            @Key
            private java.util.List<String> statuses;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrdersListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Boolean getAcknowledged() {
                return this.acknowledged;
            }

            public List setAcknowledged(Boolean bl) {
                this.acknowledged = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getPlacedDateEnd() {
                return this.placedDateEnd;
            }

            public List setPlacedDateEnd(String string) {
                this.placedDateEnd = string;
                return this;
            }

            public String getPlacedDateStart() {
                return this.placedDateStart;
            }

            public List setPlacedDateStart(String string) {
                this.placedDateStart = string;
                return this;
            }

            public java.util.List<String> getStatuses() {
                return this.statuses;
            }

            public List setStatuses(java.util.List<String> list) {
                this.statuses = list;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Instorerefundlineitem
        extends ShoppingContentRequest<OrdersInStoreRefundLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/inStoreRefundLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Instorerefundlineitem(BigInteger bigInteger, String string, OrdersInStoreRefundLineItemRequest ordersInStoreRefundLineItemRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersInStoreRefundLineItemRequest, OrdersInStoreRefundLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Instorerefundlineitem setAlt(String string) {
                return (Instorerefundlineitem)super.setAlt(string);
            }

            public Instorerefundlineitem setFields(String string) {
                return (Instorerefundlineitem)super.setFields(string);
            }

            public Instorerefundlineitem setKey(String string) {
                return (Instorerefundlineitem)super.setKey(string);
            }

            public Instorerefundlineitem setOauthToken(String string) {
                return (Instorerefundlineitem)super.setOauthToken(string);
            }

            public Instorerefundlineitem setPrettyPrint(Boolean bl) {
                return (Instorerefundlineitem)super.setPrettyPrint(bl);
            }

            public Instorerefundlineitem setQuotaUser(String string) {
                return (Instorerefundlineitem)super.setQuotaUser(string);
            }

            public Instorerefundlineitem setUserIp(String string) {
                return (Instorerefundlineitem)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Instorerefundlineitem setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Instorerefundlineitem setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Instorerefundlineitem set(String string, Object object) {
                return (Instorerefundlineitem)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Gettestordertemplate
        extends ShoppingContentRequest<OrdersGetTestOrderTemplateResponse> {
            private static final String REST_PATH = "{merchantId}/testordertemplates/{templateName}";
            @Key
            private BigInteger merchantId;
            @Key
            private String templateName;
            @Key
            private String country;

            protected Gettestordertemplate(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrdersGetTestOrderTemplateResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.templateName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter templateName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Gettestordertemplate setAlt(String string) {
                return (Gettestordertemplate)super.setAlt(string);
            }

            public Gettestordertemplate setFields(String string) {
                return (Gettestordertemplate)super.setFields(string);
            }

            public Gettestordertemplate setKey(String string) {
                return (Gettestordertemplate)super.setKey(string);
            }

            public Gettestordertemplate setOauthToken(String string) {
                return (Gettestordertemplate)super.setOauthToken(string);
            }

            public Gettestordertemplate setPrettyPrint(Boolean bl) {
                return (Gettestordertemplate)super.setPrettyPrint(bl);
            }

            public Gettestordertemplate setQuotaUser(String string) {
                return (Gettestordertemplate)super.setQuotaUser(string);
            }

            public Gettestordertemplate setUserIp(String string) {
                return (Gettestordertemplate)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Gettestordertemplate setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getTemplateName() {
                return this.templateName;
            }

            public Gettestordertemplate setTemplateName(String string) {
                this.templateName = string;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Gettestordertemplate setCountry(String string) {
                this.country = string;
                return this;
            }

            @Override
            public Gettestordertemplate set(String string, Object object) {
                return (Gettestordertemplate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Getbymerchantorderid
        extends ShoppingContentRequest<OrdersGetByMerchantOrderIdResponse> {
            private static final String REST_PATH = "{merchantId}/ordersbymerchantid/{merchantOrderId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String merchantOrderId;

            protected Getbymerchantorderid(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrdersGetByMerchantOrderIdResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.merchantOrderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter merchantOrderId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getbymerchantorderid setAlt(String string) {
                return (Getbymerchantorderid)super.setAlt(string);
            }

            public Getbymerchantorderid setFields(String string) {
                return (Getbymerchantorderid)super.setFields(string);
            }

            public Getbymerchantorderid setKey(String string) {
                return (Getbymerchantorderid)super.setKey(string);
            }

            public Getbymerchantorderid setOauthToken(String string) {
                return (Getbymerchantorderid)super.setOauthToken(string);
            }

            public Getbymerchantorderid setPrettyPrint(Boolean bl) {
                return (Getbymerchantorderid)super.setPrettyPrint(bl);
            }

            public Getbymerchantorderid setQuotaUser(String string) {
                return (Getbymerchantorderid)super.setQuotaUser(string);
            }

            public Getbymerchantorderid setUserIp(String string) {
                return (Getbymerchantorderid)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getbymerchantorderid setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getMerchantOrderId() {
                return this.merchantOrderId;
            }

            public Getbymerchantorderid setMerchantOrderId(String string) {
                this.merchantOrderId = string;
                return this;
            }

            @Override
            public Getbymerchantorderid set(String string, Object object) {
                return (Getbymerchantorderid)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<Order> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Get(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Order.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Get setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<OrdersCustomBatchResponse> {
            private static final String REST_PATH = "orders/batch";

            protected Custombatch(OrdersCustomBatchRequest ordersCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersCustomBatchRequest, OrdersCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Createtestreturn
        extends ShoppingContentRequest<OrdersCreateTestReturnResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/testreturn";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Createtestreturn(BigInteger bigInteger, String string, OrdersCreateTestReturnRequest ordersCreateTestReturnRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersCreateTestReturnRequest, OrdersCreateTestReturnResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Createtestreturn setAlt(String string) {
                return (Createtestreturn)super.setAlt(string);
            }

            public Createtestreturn setFields(String string) {
                return (Createtestreturn)super.setFields(string);
            }

            public Createtestreturn setKey(String string) {
                return (Createtestreturn)super.setKey(string);
            }

            public Createtestreturn setOauthToken(String string) {
                return (Createtestreturn)super.setOauthToken(string);
            }

            public Createtestreturn setPrettyPrint(Boolean bl) {
                return (Createtestreturn)super.setPrettyPrint(bl);
            }

            public Createtestreturn setQuotaUser(String string) {
                return (Createtestreturn)super.setQuotaUser(string);
            }

            public Createtestreturn setUserIp(String string) {
                return (Createtestreturn)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createtestreturn setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Createtestreturn setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Createtestreturn set(String string, Object object) {
                return (Createtestreturn)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Createtestorder
        extends ShoppingContentRequest<OrdersCreateTestOrderResponse> {
            private static final String REST_PATH = "{merchantId}/testorders";
            @Key
            private BigInteger merchantId;

            protected Createtestorder(BigInteger bigInteger, OrdersCreateTestOrderRequest ordersCreateTestOrderRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersCreateTestOrderRequest, OrdersCreateTestOrderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public Createtestorder setAlt(String string) {
                return (Createtestorder)super.setAlt(string);
            }

            public Createtestorder setFields(String string) {
                return (Createtestorder)super.setFields(string);
            }

            public Createtestorder setKey(String string) {
                return (Createtestorder)super.setKey(string);
            }

            public Createtestorder setOauthToken(String string) {
                return (Createtestorder)super.setOauthToken(string);
            }

            public Createtestorder setPrettyPrint(Boolean bl) {
                return (Createtestorder)super.setPrettyPrint(bl);
            }

            public Createtestorder setQuotaUser(String string) {
                return (Createtestorder)super.setQuotaUser(string);
            }

            public Createtestorder setUserIp(String string) {
                return (Createtestorder)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createtestorder setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            @Override
            public Createtestorder set(String string, Object object) {
                return (Createtestorder)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Canceltestorderbycustomer
        extends ShoppingContentRequest<OrdersCancelTestOrderByCustomerResponse> {
            private static final String REST_PATH = "{merchantId}/testorders/{orderId}/cancelByCustomer";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Canceltestorderbycustomer(BigInteger bigInteger, String string, OrdersCancelTestOrderByCustomerRequest ordersCancelTestOrderByCustomerRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersCancelTestOrderByCustomerRequest, OrdersCancelTestOrderByCustomerResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Canceltestorderbycustomer setAlt(String string) {
                return (Canceltestorderbycustomer)super.setAlt(string);
            }

            public Canceltestorderbycustomer setFields(String string) {
                return (Canceltestorderbycustomer)super.setFields(string);
            }

            public Canceltestorderbycustomer setKey(String string) {
                return (Canceltestorderbycustomer)super.setKey(string);
            }

            public Canceltestorderbycustomer setOauthToken(String string) {
                return (Canceltestorderbycustomer)super.setOauthToken(string);
            }

            public Canceltestorderbycustomer setPrettyPrint(Boolean bl) {
                return (Canceltestorderbycustomer)super.setPrettyPrint(bl);
            }

            public Canceltestorderbycustomer setQuotaUser(String string) {
                return (Canceltestorderbycustomer)super.setQuotaUser(string);
            }

            public Canceltestorderbycustomer setUserIp(String string) {
                return (Canceltestorderbycustomer)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Canceltestorderbycustomer setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Canceltestorderbycustomer setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Canceltestorderbycustomer set(String string, Object object) {
                return (Canceltestorderbycustomer)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancellineitem
        extends ShoppingContentRequest<OrdersCancelLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/cancelLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Cancellineitem(BigInteger bigInteger, String string, OrdersCancelLineItemRequest ordersCancelLineItemRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersCancelLineItemRequest, OrdersCancelLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Cancellineitem setAlt(String string) {
                return (Cancellineitem)super.setAlt(string);
            }

            public Cancellineitem setFields(String string) {
                return (Cancellineitem)super.setFields(string);
            }

            public Cancellineitem setKey(String string) {
                return (Cancellineitem)super.setKey(string);
            }

            public Cancellineitem setOauthToken(String string) {
                return (Cancellineitem)super.setOauthToken(string);
            }

            public Cancellineitem setPrettyPrint(Boolean bl) {
                return (Cancellineitem)super.setPrettyPrint(bl);
            }

            public Cancellineitem setQuotaUser(String string) {
                return (Cancellineitem)super.setQuotaUser(string);
            }

            public Cancellineitem setUserIp(String string) {
                return (Cancellineitem)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Cancellineitem setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Cancellineitem setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Cancellineitem set(String string, Object object) {
                return (Cancellineitem)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancel
        extends ShoppingContentRequest<OrdersCancelResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/cancel";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Cancel(BigInteger bigInteger, String string, OrdersCancelRequest ordersCancelRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersCancelRequest, OrdersCancelResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Cancel setAlt(String string) {
                return (Cancel)super.setAlt(string);
            }

            public Cancel setFields(String string) {
                return (Cancel)super.setFields(string);
            }

            public Cancel setKey(String string) {
                return (Cancel)super.setKey(string);
            }

            public Cancel setOauthToken(String string) {
                return (Cancel)super.setOauthToken(string);
            }

            public Cancel setPrettyPrint(Boolean bl) {
                return (Cancel)super.setPrettyPrint(bl);
            }

            public Cancel setQuotaUser(String string) {
                return (Cancel)super.setQuotaUser(string);
            }

            public Cancel setUserIp(String string) {
                return (Cancel)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Cancel setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Cancel setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Cancel set(String string, Object object) {
                return (Cancel)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Advancetestorder
        extends ShoppingContentRequest<OrdersAdvanceTestOrderResponse> {
            private static final String REST_PATH = "{merchantId}/testorders/{orderId}/advance";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Advancetestorder(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "POST", REST_PATH, null, OrdersAdvanceTestOrderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Advancetestorder setAlt(String string) {
                return (Advancetestorder)super.setAlt(string);
            }

            public Advancetestorder setFields(String string) {
                return (Advancetestorder)super.setFields(string);
            }

            public Advancetestorder setKey(String string) {
                return (Advancetestorder)super.setKey(string);
            }

            public Advancetestorder setOauthToken(String string) {
                return (Advancetestorder)super.setOauthToken(string);
            }

            public Advancetestorder setPrettyPrint(Boolean bl) {
                return (Advancetestorder)super.setPrettyPrint(bl);
            }

            public Advancetestorder setQuotaUser(String string) {
                return (Advancetestorder)super.setQuotaUser(string);
            }

            public Advancetestorder setUserIp(String string) {
                return (Advancetestorder)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Advancetestorder setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Advancetestorder setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Advancetestorder set(String string, Object object) {
                return (Advancetestorder)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Acknowledge
        extends ShoppingContentRequest<OrdersAcknowledgeResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/acknowledge";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Acknowledge(BigInteger bigInteger, String string, OrdersAcknowledgeRequest ordersAcknowledgeRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)ordersAcknowledgeRequest, OrdersAcknowledgeResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Acknowledge setAlt(String string) {
                return (Acknowledge)super.setAlt(string);
            }

            public Acknowledge setFields(String string) {
                return (Acknowledge)super.setFields(string);
            }

            public Acknowledge setKey(String string) {
                return (Acknowledge)super.setKey(string);
            }

            public Acknowledge setOauthToken(String string) {
                return (Acknowledge)super.setOauthToken(string);
            }

            public Acknowledge setPrettyPrint(Boolean bl) {
                return (Acknowledge)super.setPrettyPrint(bl);
            }

            public Acknowledge setQuotaUser(String string) {
                return (Acknowledge)super.setQuotaUser(string);
            }

            public Acknowledge setUserIp(String string) {
                return (Acknowledge)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Acknowledge setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Acknowledge setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Acknowledge set(String string, Object object) {
                return (Acknowledge)super.set(string, object);
            }
        }
    }

    public class Orderreturns {
        public Get get(BigInteger bigInteger, String string) throws IOException {
            Get get = new Get(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<OrderreturnsListResponse> {
            private static final String REST_PATH = "{merchantId}/orderreturns";
            @Key
            private BigInteger merchantId;
            @Key
            private String createdEndDate;
            @Key
            private String createdStartDate;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrderreturnsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getCreatedEndDate() {
                return this.createdEndDate;
            }

            public List setCreatedEndDate(String string) {
                this.createdEndDate = string;
                return this;
            }

            public String getCreatedStartDate() {
                return this.createdStartDate;
            }

            public List setCreatedStartDate(String string) {
                this.createdStartDate = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<MerchantOrderReturn> {
            private static final String REST_PATH = "{merchantId}/orderreturns/{returnId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnId;

            protected Get(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, MerchantOrderReturn.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.returnId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter returnId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getReturnId() {
                return this.returnId;
            }

            public Get setReturnId(String string) {
                this.returnId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Orderreports {
        public Listdisbursements listdisbursements(BigInteger bigInteger, String string) throws IOException {
            Listdisbursements listdisbursements = new Listdisbursements(bigInteger, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)listdisbursements);
            return listdisbursements;
        }

        public Listtransactions listtransactions(BigInteger bigInteger, String string, String string2) throws IOException {
            Listtransactions listtransactions = new Listtransactions(bigInteger, string, string2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)listtransactions);
            return listtransactions;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Listtransactions
        extends ShoppingContentRequest<OrderreportsListTransactionsResponse> {
            private static final String REST_PATH = "{merchantId}/orderreports/disbursements/{disbursementId}/transactions";
            @Key
            private BigInteger merchantId;
            @Key
            private String disbursementId;
            @Key
            private String transactionStartDate;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String transactionEndDate;

            protected Listtransactions(BigInteger bigInteger, String string, String string2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrderreportsListTransactionsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.disbursementId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter disbursementId must be specified.");
                this.transactionStartDate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter transactionStartDate must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listtransactions setAlt(String string) {
                return (Listtransactions)super.setAlt(string);
            }

            public Listtransactions setFields(String string) {
                return (Listtransactions)super.setFields(string);
            }

            public Listtransactions setKey(String string) {
                return (Listtransactions)super.setKey(string);
            }

            public Listtransactions setOauthToken(String string) {
                return (Listtransactions)super.setOauthToken(string);
            }

            public Listtransactions setPrettyPrint(Boolean bl) {
                return (Listtransactions)super.setPrettyPrint(bl);
            }

            public Listtransactions setQuotaUser(String string) {
                return (Listtransactions)super.setQuotaUser(string);
            }

            public Listtransactions setUserIp(String string) {
                return (Listtransactions)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Listtransactions setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getDisbursementId() {
                return this.disbursementId;
            }

            public Listtransactions setDisbursementId(String string) {
                this.disbursementId = string;
                return this;
            }

            public String getTransactionStartDate() {
                return this.transactionStartDate;
            }

            public Listtransactions setTransactionStartDate(String string) {
                this.transactionStartDate = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Listtransactions setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Listtransactions setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getTransactionEndDate() {
                return this.transactionEndDate;
            }

            public Listtransactions setTransactionEndDate(String string) {
                this.transactionEndDate = string;
                return this;
            }

            @Override
            public Listtransactions set(String string, Object object) {
                return (Listtransactions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Listdisbursements
        extends ShoppingContentRequest<OrderreportsListDisbursementsResponse> {
            private static final String REST_PATH = "{merchantId}/orderreports/disbursements";
            @Key
            private BigInteger merchantId;
            @Key
            private String disbursementStartDate;
            @Key
            private String disbursementEndDate;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected Listdisbursements(BigInteger bigInteger, String string) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrderreportsListDisbursementsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.disbursementStartDate = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter disbursementStartDate must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listdisbursements setAlt(String string) {
                return (Listdisbursements)super.setAlt(string);
            }

            public Listdisbursements setFields(String string) {
                return (Listdisbursements)super.setFields(string);
            }

            public Listdisbursements setKey(String string) {
                return (Listdisbursements)super.setKey(string);
            }

            public Listdisbursements setOauthToken(String string) {
                return (Listdisbursements)super.setOauthToken(string);
            }

            public Listdisbursements setPrettyPrint(Boolean bl) {
                return (Listdisbursements)super.setPrettyPrint(bl);
            }

            public Listdisbursements setQuotaUser(String string) {
                return (Listdisbursements)super.setQuotaUser(string);
            }

            public Listdisbursements setUserIp(String string) {
                return (Listdisbursements)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Listdisbursements setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getDisbursementStartDate() {
                return this.disbursementStartDate;
            }

            public Listdisbursements setDisbursementStartDate(String string) {
                this.disbursementStartDate = string;
                return this;
            }

            public String getDisbursementEndDate() {
                return this.disbursementEndDate;
            }

            public Listdisbursements setDisbursementEndDate(String string) {
                this.disbursementEndDate = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Listdisbursements setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Listdisbursements setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public Listdisbursements set(String string, Object object) {
                return (Listdisbursements)super.set(string, object);
            }
        }
    }

    public class Orderpayments {
        public Notifyauthapproved notifyauthapproved(BigInteger bigInteger, String string, OrderpaymentsNotifyAuthApprovedRequest orderpaymentsNotifyAuthApprovedRequest) throws IOException {
            Notifyauthapproved notifyauthapproved = new Notifyauthapproved(bigInteger, string, orderpaymentsNotifyAuthApprovedRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)notifyauthapproved);
            return notifyauthapproved;
        }

        public Notifyauthdeclined notifyauthdeclined(BigInteger bigInteger, String string, OrderpaymentsNotifyAuthDeclinedRequest orderpaymentsNotifyAuthDeclinedRequest) throws IOException {
            Notifyauthdeclined notifyauthdeclined = new Notifyauthdeclined(bigInteger, string, orderpaymentsNotifyAuthDeclinedRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)notifyauthdeclined);
            return notifyauthdeclined;
        }

        public Notifycharge notifycharge(BigInteger bigInteger, String string, OrderpaymentsNotifyChargeRequest orderpaymentsNotifyChargeRequest) throws IOException {
            Notifycharge notifycharge = new Notifycharge(bigInteger, string, orderpaymentsNotifyChargeRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)notifycharge);
            return notifycharge;
        }

        public Notifyrefund notifyrefund(BigInteger bigInteger, String string, OrderpaymentsNotifyRefundRequest orderpaymentsNotifyRefundRequest) throws IOException {
            Notifyrefund notifyrefund = new Notifyrefund(bigInteger, string, orderpaymentsNotifyRefundRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)notifyrefund);
            return notifyrefund;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Notifyrefund
        extends ShoppingContentRequest<OrderpaymentsNotifyRefundResponse> {
            private static final String REST_PATH = "{merchantId}/orderpayments/{orderId}/notifyRefund";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Notifyrefund(BigInteger bigInteger, String string, OrderpaymentsNotifyRefundRequest orderpaymentsNotifyRefundRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)orderpaymentsNotifyRefundRequest, OrderpaymentsNotifyRefundResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Notifyrefund setAlt(String string) {
                return (Notifyrefund)super.setAlt(string);
            }

            public Notifyrefund setFields(String string) {
                return (Notifyrefund)super.setFields(string);
            }

            public Notifyrefund setKey(String string) {
                return (Notifyrefund)super.setKey(string);
            }

            public Notifyrefund setOauthToken(String string) {
                return (Notifyrefund)super.setOauthToken(string);
            }

            public Notifyrefund setPrettyPrint(Boolean bl) {
                return (Notifyrefund)super.setPrettyPrint(bl);
            }

            public Notifyrefund setQuotaUser(String string) {
                return (Notifyrefund)super.setQuotaUser(string);
            }

            public Notifyrefund setUserIp(String string) {
                return (Notifyrefund)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Notifyrefund setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Notifyrefund setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Notifyrefund set(String string, Object object) {
                return (Notifyrefund)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Notifycharge
        extends ShoppingContentRequest<OrderpaymentsNotifyChargeResponse> {
            private static final String REST_PATH = "{merchantId}/orderpayments/{orderId}/notifyCharge";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Notifycharge(BigInteger bigInteger, String string, OrderpaymentsNotifyChargeRequest orderpaymentsNotifyChargeRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)orderpaymentsNotifyChargeRequest, OrderpaymentsNotifyChargeResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Notifycharge setAlt(String string) {
                return (Notifycharge)super.setAlt(string);
            }

            public Notifycharge setFields(String string) {
                return (Notifycharge)super.setFields(string);
            }

            public Notifycharge setKey(String string) {
                return (Notifycharge)super.setKey(string);
            }

            public Notifycharge setOauthToken(String string) {
                return (Notifycharge)super.setOauthToken(string);
            }

            public Notifycharge setPrettyPrint(Boolean bl) {
                return (Notifycharge)super.setPrettyPrint(bl);
            }

            public Notifycharge setQuotaUser(String string) {
                return (Notifycharge)super.setQuotaUser(string);
            }

            public Notifycharge setUserIp(String string) {
                return (Notifycharge)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Notifycharge setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Notifycharge setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Notifycharge set(String string, Object object) {
                return (Notifycharge)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Notifyauthdeclined
        extends ShoppingContentRequest<OrderpaymentsNotifyAuthDeclinedResponse> {
            private static final String REST_PATH = "{merchantId}/orderpayments/{orderId}/notifyAuthDeclined";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Notifyauthdeclined(BigInteger bigInteger, String string, OrderpaymentsNotifyAuthDeclinedRequest orderpaymentsNotifyAuthDeclinedRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)orderpaymentsNotifyAuthDeclinedRequest, OrderpaymentsNotifyAuthDeclinedResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Notifyauthdeclined setAlt(String string) {
                return (Notifyauthdeclined)super.setAlt(string);
            }

            public Notifyauthdeclined setFields(String string) {
                return (Notifyauthdeclined)super.setFields(string);
            }

            public Notifyauthdeclined setKey(String string) {
                return (Notifyauthdeclined)super.setKey(string);
            }

            public Notifyauthdeclined setOauthToken(String string) {
                return (Notifyauthdeclined)super.setOauthToken(string);
            }

            public Notifyauthdeclined setPrettyPrint(Boolean bl) {
                return (Notifyauthdeclined)super.setPrettyPrint(bl);
            }

            public Notifyauthdeclined setQuotaUser(String string) {
                return (Notifyauthdeclined)super.setQuotaUser(string);
            }

            public Notifyauthdeclined setUserIp(String string) {
                return (Notifyauthdeclined)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Notifyauthdeclined setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Notifyauthdeclined setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Notifyauthdeclined set(String string, Object object) {
                return (Notifyauthdeclined)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Notifyauthapproved
        extends ShoppingContentRequest<OrderpaymentsNotifyAuthApprovedResponse> {
            private static final String REST_PATH = "{merchantId}/orderpayments/{orderId}/notifyAuthApproved";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Notifyauthapproved(BigInteger bigInteger, String string, OrderpaymentsNotifyAuthApprovedRequest orderpaymentsNotifyAuthApprovedRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)orderpaymentsNotifyAuthApprovedRequest, OrderpaymentsNotifyAuthApprovedResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Notifyauthapproved setAlt(String string) {
                return (Notifyauthapproved)super.setAlt(string);
            }

            public Notifyauthapproved setFields(String string) {
                return (Notifyauthapproved)super.setFields(string);
            }

            public Notifyauthapproved setKey(String string) {
                return (Notifyauthapproved)super.setKey(string);
            }

            public Notifyauthapproved setOauthToken(String string) {
                return (Notifyauthapproved)super.setOauthToken(string);
            }

            public Notifyauthapproved setPrettyPrint(Boolean bl) {
                return (Notifyauthapproved)super.setPrettyPrint(bl);
            }

            public Notifyauthapproved setQuotaUser(String string) {
                return (Notifyauthapproved)super.setQuotaUser(string);
            }

            public Notifyauthapproved setUserIp(String string) {
                return (Notifyauthapproved)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Notifyauthapproved setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Notifyauthapproved setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Notifyauthapproved set(String string, Object object) {
                return (Notifyauthapproved)super.set(string, object);
            }
        }
    }

    public class Orderinvoices {
        public Createchargeinvoice createchargeinvoice(BigInteger bigInteger, String string, OrderinvoicesCreateChargeInvoiceRequest orderinvoicesCreateChargeInvoiceRequest) throws IOException {
            Createchargeinvoice createchargeinvoice = new Createchargeinvoice(bigInteger, string, orderinvoicesCreateChargeInvoiceRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)createchargeinvoice);
            return createchargeinvoice;
        }

        public Createrefundinvoice createrefundinvoice(BigInteger bigInteger, String string, OrderinvoicesCreateRefundInvoiceRequest orderinvoicesCreateRefundInvoiceRequest) throws IOException {
            Createrefundinvoice createrefundinvoice = new Createrefundinvoice(bigInteger, string, orderinvoicesCreateRefundInvoiceRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)createrefundinvoice);
            return createrefundinvoice;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Createrefundinvoice
        extends ShoppingContentRequest<OrderinvoicesCreateRefundInvoiceResponse> {
            private static final String REST_PATH = "{merchantId}/orderinvoices/{orderId}/createRefundInvoice";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Createrefundinvoice(BigInteger bigInteger, String string, OrderinvoicesCreateRefundInvoiceRequest orderinvoicesCreateRefundInvoiceRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)orderinvoicesCreateRefundInvoiceRequest, OrderinvoicesCreateRefundInvoiceResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Createrefundinvoice setAlt(String string) {
                return (Createrefundinvoice)super.setAlt(string);
            }

            public Createrefundinvoice setFields(String string) {
                return (Createrefundinvoice)super.setFields(string);
            }

            public Createrefundinvoice setKey(String string) {
                return (Createrefundinvoice)super.setKey(string);
            }

            public Createrefundinvoice setOauthToken(String string) {
                return (Createrefundinvoice)super.setOauthToken(string);
            }

            public Createrefundinvoice setPrettyPrint(Boolean bl) {
                return (Createrefundinvoice)super.setPrettyPrint(bl);
            }

            public Createrefundinvoice setQuotaUser(String string) {
                return (Createrefundinvoice)super.setQuotaUser(string);
            }

            public Createrefundinvoice setUserIp(String string) {
                return (Createrefundinvoice)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createrefundinvoice setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Createrefundinvoice setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Createrefundinvoice set(String string, Object object) {
                return (Createrefundinvoice)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Createchargeinvoice
        extends ShoppingContentRequest<OrderinvoicesCreateChargeInvoiceResponse> {
            private static final String REST_PATH = "{merchantId}/orderinvoices/{orderId}/createChargeInvoice";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Createchargeinvoice(BigInteger bigInteger, String string, OrderinvoicesCreateChargeInvoiceRequest orderinvoicesCreateChargeInvoiceRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)orderinvoicesCreateChargeInvoiceRequest, OrderinvoicesCreateChargeInvoiceResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter orderId must be specified.");
            }

            public Createchargeinvoice setAlt(String string) {
                return (Createchargeinvoice)super.setAlt(string);
            }

            public Createchargeinvoice setFields(String string) {
                return (Createchargeinvoice)super.setFields(string);
            }

            public Createchargeinvoice setKey(String string) {
                return (Createchargeinvoice)super.setKey(string);
            }

            public Createchargeinvoice setOauthToken(String string) {
                return (Createchargeinvoice)super.setOauthToken(string);
            }

            public Createchargeinvoice setPrettyPrint(Boolean bl) {
                return (Createchargeinvoice)super.setPrettyPrint(bl);
            }

            public Createchargeinvoice setQuotaUser(String string) {
                return (Createchargeinvoice)super.setQuotaUser(string);
            }

            public Createchargeinvoice setUserIp(String string) {
                return (Createchargeinvoice)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createchargeinvoice setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Createchargeinvoice setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            @Override
            public Createchargeinvoice set(String string, Object object) {
                return (Createchargeinvoice)super.set(string, object);
            }
        }
    }

    public class Liasettings {
        public Custombatch custombatch(LiasettingsCustomBatchRequest liasettingsCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(liasettingsCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Get get = new Get(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Getaccessiblegmbaccounts getaccessiblegmbaccounts(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Getaccessiblegmbaccounts getaccessiblegmbaccounts = new Getaccessiblegmbaccounts(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)getaccessiblegmbaccounts);
            return getaccessiblegmbaccounts;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Listposdataproviders listposdataproviders() throws IOException {
            Listposdataproviders listposdataproviders = new Listposdataproviders();
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)listposdataproviders);
            return listposdataproviders;
        }

        public Patch patch(BigInteger bigInteger, BigInteger bigInteger2, LiaSettings liaSettings) throws IOException {
            Patch patch = new Patch(bigInteger, bigInteger2, liaSettings);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Requestgmbaccess requestgmbaccess(BigInteger bigInteger, BigInteger bigInteger2, String string) throws IOException {
            Requestgmbaccess requestgmbaccess = new Requestgmbaccess(bigInteger, bigInteger2, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)requestgmbaccess);
            return requestgmbaccess;
        }

        public Requestinventoryverification requestinventoryverification(BigInteger bigInteger, BigInteger bigInteger2, String string) throws IOException {
            Requestinventoryverification requestinventoryverification = new Requestinventoryverification(bigInteger, bigInteger2, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)requestinventoryverification);
            return requestinventoryverification;
        }

        public Setinventoryverificationcontact setinventoryverificationcontact(BigInteger bigInteger, BigInteger bigInteger2, String string, String string2, String string3, String string4) throws IOException {
            Setinventoryverificationcontact setinventoryverificationcontact = new Setinventoryverificationcontact(bigInteger, bigInteger2, string, string2, string3, string4);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)setinventoryverificationcontact);
            return setinventoryverificationcontact;
        }

        public Setposdataprovider setposdataprovider(BigInteger bigInteger, BigInteger bigInteger2, String string) throws IOException {
            Setposdataprovider setposdataprovider = new Setposdataprovider(bigInteger, bigInteger2, string);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)setposdataprovider);
            return setposdataprovider;
        }

        public Update update(BigInteger bigInteger, BigInteger bigInteger2, LiaSettings liaSettings) throws IOException {
            Update update = new Update(bigInteger, bigInteger2, liaSettings);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ShoppingContentRequest<LiaSettings> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Update(BigInteger bigInteger, BigInteger bigInteger2, LiaSettings liaSettings) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)liaSettings, LiaSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Update setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Setposdataprovider
        extends ShoppingContentRequest<LiasettingsSetPosDataProviderResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/setposdataprovider";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;
            @Key
            private BigInteger posDataProviderId;
            @Key
            private String posExternalAccountId;

            protected Setposdataprovider(BigInteger bigInteger, BigInteger bigInteger2, String string) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsSetPosDataProviderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter country must be specified.");
            }

            public Setposdataprovider setAlt(String string) {
                return (Setposdataprovider)super.setAlt(string);
            }

            public Setposdataprovider setFields(String string) {
                return (Setposdataprovider)super.setFields(string);
            }

            public Setposdataprovider setKey(String string) {
                return (Setposdataprovider)super.setKey(string);
            }

            public Setposdataprovider setOauthToken(String string) {
                return (Setposdataprovider)super.setOauthToken(string);
            }

            public Setposdataprovider setPrettyPrint(Boolean bl) {
                return (Setposdataprovider)super.setPrettyPrint(bl);
            }

            public Setposdataprovider setQuotaUser(String string) {
                return (Setposdataprovider)super.setQuotaUser(string);
            }

            public Setposdataprovider setUserIp(String string) {
                return (Setposdataprovider)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setposdataprovider setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Setposdataprovider setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Setposdataprovider setCountry(String string) {
                this.country = string;
                return this;
            }

            public BigInteger getPosDataProviderId() {
                return this.posDataProviderId;
            }

            public Setposdataprovider setPosDataProviderId(BigInteger bigInteger) {
                this.posDataProviderId = bigInteger;
                return this;
            }

            public String getPosExternalAccountId() {
                return this.posExternalAccountId;
            }

            public Setposdataprovider setPosExternalAccountId(String string) {
                this.posExternalAccountId = string;
                return this;
            }

            @Override
            public Setposdataprovider set(String string, Object object) {
                return (Setposdataprovider)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Setinventoryverificationcontact
        extends ShoppingContentRequest<LiasettingsSetInventoryVerificationContactResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/setinventoryverificationcontact";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String contactEmail;
            @Key
            private String contactName;
            @Key
            private String country;
            @Key
            private String language;

            protected Setinventoryverificationcontact(BigInteger bigInteger, BigInteger bigInteger2, String string, String string2, String string3, String string4) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsSetInventoryVerificationContactResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
                this.contactEmail = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter contactEmail must be specified.");
                this.contactName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter contactName must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter country must be specified.");
                this.language = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter language must be specified.");
            }

            public Setinventoryverificationcontact setAlt(String string) {
                return (Setinventoryverificationcontact)super.setAlt(string);
            }

            public Setinventoryverificationcontact setFields(String string) {
                return (Setinventoryverificationcontact)super.setFields(string);
            }

            public Setinventoryverificationcontact setKey(String string) {
                return (Setinventoryverificationcontact)super.setKey(string);
            }

            public Setinventoryverificationcontact setOauthToken(String string) {
                return (Setinventoryverificationcontact)super.setOauthToken(string);
            }

            public Setinventoryverificationcontact setPrettyPrint(Boolean bl) {
                return (Setinventoryverificationcontact)super.setPrettyPrint(bl);
            }

            public Setinventoryverificationcontact setQuotaUser(String string) {
                return (Setinventoryverificationcontact)super.setQuotaUser(string);
            }

            public Setinventoryverificationcontact setUserIp(String string) {
                return (Setinventoryverificationcontact)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setinventoryverificationcontact setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Setinventoryverificationcontact setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public String getContactEmail() {
                return this.contactEmail;
            }

            public Setinventoryverificationcontact setContactEmail(String string) {
                this.contactEmail = string;
                return this;
            }

            public String getContactName() {
                return this.contactName;
            }

            public Setinventoryverificationcontact setContactName(String string) {
                this.contactName = string;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Setinventoryverificationcontact setCountry(String string) {
                this.country = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Setinventoryverificationcontact setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public Setinventoryverificationcontact set(String string, Object object) {
                return (Setinventoryverificationcontact)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Requestinventoryverification
        extends ShoppingContentRequest<LiasettingsRequestInventoryVerificationResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/requestinventoryverification/{country}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;

            protected Requestinventoryverification(BigInteger bigInteger, BigInteger bigInteger2, String string) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsRequestInventoryVerificationResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter country must be specified.");
            }

            public Requestinventoryverification setAlt(String string) {
                return (Requestinventoryverification)super.setAlt(string);
            }

            public Requestinventoryverification setFields(String string) {
                return (Requestinventoryverification)super.setFields(string);
            }

            public Requestinventoryverification setKey(String string) {
                return (Requestinventoryverification)super.setKey(string);
            }

            public Requestinventoryverification setOauthToken(String string) {
                return (Requestinventoryverification)super.setOauthToken(string);
            }

            public Requestinventoryverification setPrettyPrint(Boolean bl) {
                return (Requestinventoryverification)super.setPrettyPrint(bl);
            }

            public Requestinventoryverification setQuotaUser(String string) {
                return (Requestinventoryverification)super.setQuotaUser(string);
            }

            public Requestinventoryverification setUserIp(String string) {
                return (Requestinventoryverification)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Requestinventoryverification setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Requestinventoryverification setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Requestinventoryverification setCountry(String string) {
                this.country = string;
                return this;
            }

            @Override
            public Requestinventoryverification set(String string, Object object) {
                return (Requestinventoryverification)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Requestgmbaccess
        extends ShoppingContentRequest<LiasettingsRequestGmbAccessResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/requestgmbaccess";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String gmbEmail;

            protected Requestgmbaccess(BigInteger bigInteger, BigInteger bigInteger2, String string) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsRequestGmbAccessResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
                this.gmbEmail = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter gmbEmail must be specified.");
            }

            public Requestgmbaccess setAlt(String string) {
                return (Requestgmbaccess)super.setAlt(string);
            }

            public Requestgmbaccess setFields(String string) {
                return (Requestgmbaccess)super.setFields(string);
            }

            public Requestgmbaccess setKey(String string) {
                return (Requestgmbaccess)super.setKey(string);
            }

            public Requestgmbaccess setOauthToken(String string) {
                return (Requestgmbaccess)super.setOauthToken(string);
            }

            public Requestgmbaccess setPrettyPrint(Boolean bl) {
                return (Requestgmbaccess)super.setPrettyPrint(bl);
            }

            public Requestgmbaccess setQuotaUser(String string) {
                return (Requestgmbaccess)super.setQuotaUser(string);
            }

            public Requestgmbaccess setUserIp(String string) {
                return (Requestgmbaccess)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Requestgmbaccess setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Requestgmbaccess setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public String getGmbEmail() {
                return this.gmbEmail;
            }

            public Requestgmbaccess setGmbEmail(String string) {
                this.gmbEmail = string;
                return this;
            }

            @Override
            public Requestgmbaccess set(String string, Object object) {
                return (Requestgmbaccess)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ShoppingContentRequest<LiaSettings> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Patch(BigInteger bigInteger, BigInteger bigInteger2, LiaSettings liaSettings) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)liaSettings, LiaSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Patch setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Patch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Listposdataproviders
        extends ShoppingContentRequest<LiasettingsListPosDataProvidersResponse> {
            private static final String REST_PATH = "liasettings/posdataproviders";

            protected Listposdataproviders() {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsListPosDataProvidersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listposdataproviders setAlt(String string) {
                return (Listposdataproviders)super.setAlt(string);
            }

            public Listposdataproviders setFields(String string) {
                return (Listposdataproviders)super.setFields(string);
            }

            public Listposdataproviders setKey(String string) {
                return (Listposdataproviders)super.setKey(string);
            }

            public Listposdataproviders setOauthToken(String string) {
                return (Listposdataproviders)super.setOauthToken(string);
            }

            public Listposdataproviders setPrettyPrint(Boolean bl) {
                return (Listposdataproviders)super.setPrettyPrint(bl);
            }

            public Listposdataproviders setQuotaUser(String string) {
                return (Listposdataproviders)super.setQuotaUser(string);
            }

            public Listposdataproviders setUserIp(String string) {
                return (Listposdataproviders)super.setUserIp(string);
            }

            @Override
            public Listposdataproviders set(String string, Object object) {
                return (Listposdataproviders)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<LiasettingsListResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Getaccessiblegmbaccounts
        extends ShoppingContentRequest<LiasettingsGetAccessibleGmbAccountsResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/accessiblegmbaccounts";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Getaccessiblegmbaccounts(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsGetAccessibleGmbAccountsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getaccessiblegmbaccounts setAlt(String string) {
                return (Getaccessiblegmbaccounts)super.setAlt(string);
            }

            public Getaccessiblegmbaccounts setFields(String string) {
                return (Getaccessiblegmbaccounts)super.setFields(string);
            }

            public Getaccessiblegmbaccounts setKey(String string) {
                return (Getaccessiblegmbaccounts)super.setKey(string);
            }

            public Getaccessiblegmbaccounts setOauthToken(String string) {
                return (Getaccessiblegmbaccounts)super.setOauthToken(string);
            }

            public Getaccessiblegmbaccounts setPrettyPrint(Boolean bl) {
                return (Getaccessiblegmbaccounts)super.setPrettyPrint(bl);
            }

            public Getaccessiblegmbaccounts setQuotaUser(String string) {
                return (Getaccessiblegmbaccounts)super.setQuotaUser(string);
            }

            public Getaccessiblegmbaccounts setUserIp(String string) {
                return (Getaccessiblegmbaccounts)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getaccessiblegmbaccounts setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Getaccessiblegmbaccounts setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            @Override
            public Getaccessiblegmbaccounts set(String string, Object object) {
                return (Getaccessiblegmbaccounts)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<LiaSettings> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiaSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<LiasettingsCustomBatchResponse> {
            private static final String REST_PATH = "liasettings/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(LiasettingsCustomBatchRequest liasettingsCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)liasettingsCustomBatchRequest, LiasettingsCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Inventory {
        public Custombatch custombatch(InventoryCustomBatchRequest inventoryCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(inventoryCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Set set(BigInteger bigInteger, String string, String string2, InventorySetRequest inventorySetRequest) throws IOException {
            Set set = new Set(bigInteger, string, string2, inventorySetRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)set);
            return set;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Set
        extends ShoppingContentRequest<InventorySetResponse> {
            private static final String REST_PATH = "{merchantId}/inventory/{storeCode}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String storeCode;
            @Key
            private String productId;
            @Key
            private Boolean dryRun;

            protected Set(BigInteger bigInteger, String string, String string2, InventorySetRequest inventorySetRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)inventorySetRequest, InventorySetResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.storeCode = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter storeCode must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter productId must be specified.");
            }

            public Set setAlt(String string) {
                return (Set)super.setAlt(string);
            }

            public Set setFields(String string) {
                return (Set)super.setFields(string);
            }

            public Set setKey(String string) {
                return (Set)super.setKey(string);
            }

            public Set setOauthToken(String string) {
                return (Set)super.setOauthToken(string);
            }

            public Set setPrettyPrint(Boolean bl) {
                return (Set)super.setPrettyPrint(bl);
            }

            public Set setQuotaUser(String string) {
                return (Set)super.setQuotaUser(string);
            }

            public Set setUserIp(String string) {
                return (Set)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Set setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public String getStoreCode() {
                return this.storeCode;
            }

            public Set setStoreCode(String string) {
                this.storeCode = string;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Set setProductId(String string) {
                this.productId = string;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Set setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Set set(String string, Object object) {
                return (Set)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<InventoryCustomBatchResponse> {
            private static final String REST_PATH = "inventory/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(InventoryCustomBatchRequest inventoryCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)inventoryCustomBatchRequest, InventoryCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Datafeedstatuses {
        public Custombatch custombatch(DatafeedstatusesCustomBatchRequest datafeedstatusesCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(datafeedstatusesCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Get get = new Get(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<DatafeedstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/datafeedstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<DatafeedStatus> {
            private static final String REST_PATH = "{merchantId}/datafeedstatuses/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;
            @Key
            private String country;
            @Key
            private String language;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter datafeedId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Get setDatafeedId(BigInteger bigInteger) {
                this.datafeedId = bigInteger;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Get setCountry(String string) {
                this.country = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<DatafeedstatusesCustomBatchResponse> {
            private static final String REST_PATH = "datafeedstatuses/batch";

            protected Custombatch(DatafeedstatusesCustomBatchRequest datafeedstatusesCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)datafeedstatusesCustomBatchRequest, DatafeedstatusesCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Datafeeds {
        public Custombatch custombatch(DatafeedsCustomBatchRequest datafeedsCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(datafeedsCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Delete delete(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Delete delete = new Delete(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Fetchnow fetchnow(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Fetchnow fetchnow = new Fetchnow(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)fetchnow);
            return fetchnow;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Get get = new Get(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(BigInteger bigInteger, Datafeed datafeed) throws IOException {
            Insert insert = new Insert(bigInteger, datafeed);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(BigInteger bigInteger, BigInteger bigInteger2, Datafeed datafeed) throws IOException {
            Patch patch = new Patch(bigInteger, bigInteger2, datafeed);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(BigInteger bigInteger, BigInteger bigInteger2, Datafeed datafeed) throws IOException {
            Update update = new Update(bigInteger, bigInteger2, datafeed);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;
            @Key
            private Boolean dryRun;

            protected Update(BigInteger bigInteger, BigInteger bigInteger2, Datafeed datafeed) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)datafeed, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter datafeedId must be specified.");
                this.checkRequiredParameter((Object)datafeed, "content");
                this.checkRequiredParameter(datafeed.getContentType(), "Datafeed.getContentType()");
                this.checkRequiredParameter((Object)datafeed, "content");
                this.checkRequiredParameter(datafeed.getFileName(), "Datafeed.getFileName()");
                this.checkRequiredParameter((Object)datafeed, "content");
                this.checkRequiredParameter(datafeed.getId(), "Datafeed.getId()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Update setDatafeedId(BigInteger bigInteger) {
                this.datafeedId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Update setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;
            @Key
            private Boolean dryRun;

            protected Patch(BigInteger bigInteger, BigInteger bigInteger2, Datafeed datafeed) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)datafeed, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter datafeedId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Patch setDatafeedId(BigInteger bigInteger) {
                this.datafeedId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Patch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<DatafeedsListResponse> {
            private static final String REST_PATH = "{merchantId}/datafeeds";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds";
            @Key
            private BigInteger merchantId;
            @Key
            private Boolean dryRun;

            protected Insert(BigInteger bigInteger, Datafeed datafeed) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)datafeed, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.checkRequiredParameter((Object)datafeed, "content");
                this.checkRequiredParameter(datafeed.getContentType(), "Datafeed.getContentType()");
                this.checkRequiredParameter((Object)datafeed, "content");
                this.checkRequiredParameter(datafeed.getFileName(), "Datafeed.getFileName()");
                this.checkRequiredParameter((Object)datafeed, "content");
                this.checkRequiredParameter(datafeed.getName(), "Datafeed.getName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Insert setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter datafeedId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Get setDatafeedId(BigInteger bigInteger) {
                this.datafeedId = bigInteger;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Fetchnow
        extends ShoppingContentRequest<DatafeedsFetchNowResponse> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}/fetchNow";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;
            @Key
            private Boolean dryRun;

            protected Fetchnow(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "POST", REST_PATH, null, DatafeedsFetchNowResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter datafeedId must be specified.");
            }

            public Fetchnow setAlt(String string) {
                return (Fetchnow)super.setAlt(string);
            }

            public Fetchnow setFields(String string) {
                return (Fetchnow)super.setFields(string);
            }

            public Fetchnow setKey(String string) {
                return (Fetchnow)super.setKey(string);
            }

            public Fetchnow setOauthToken(String string) {
                return (Fetchnow)super.setOauthToken(string);
            }

            public Fetchnow setPrettyPrint(Boolean bl) {
                return (Fetchnow)super.setPrettyPrint(bl);
            }

            public Fetchnow setQuotaUser(String string) {
                return (Fetchnow)super.setQuotaUser(string);
            }

            public Fetchnow setUserIp(String string) {
                return (Fetchnow)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Fetchnow setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Fetchnow setDatafeedId(BigInteger bigInteger) {
                this.datafeedId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Fetchnow setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Fetchnow set(String string, Object object) {
                return (Fetchnow)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;
            @Key
            private Boolean dryRun;

            protected Delete(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter datafeedId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Delete setDatafeedId(BigInteger bigInteger) {
                this.datafeedId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Delete setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<DatafeedsCustomBatchResponse> {
            private static final String REST_PATH = "datafeeds/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(DatafeedsCustomBatchRequest datafeedsCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)datafeedsCustomBatchRequest, DatafeedsCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Accounttax {
        public Custombatch custombatch(AccounttaxCustomBatchRequest accounttaxCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(accounttaxCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Get get = new Get(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(BigInteger bigInteger, BigInteger bigInteger2, AccountTax accountTax) throws IOException {
            Patch patch = new Patch(bigInteger, bigInteger2, accountTax);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(BigInteger bigInteger, BigInteger bigInteger2, AccountTax accountTax) throws IOException {
            Update update = new Update(bigInteger, bigInteger2, accountTax);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ShoppingContentRequest<AccountTax> {
            private static final String REST_PATH = "{merchantId}/accounttax/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Update(BigInteger bigInteger, BigInteger bigInteger2, AccountTax accountTax) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)accountTax, AccountTax.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
                this.checkRequiredParameter((Object)accountTax, "content");
                this.checkRequiredParameter(accountTax.getAccountId(), "AccountTax.getAccountId()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Update setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ShoppingContentRequest<AccountTax> {
            private static final String REST_PATH = "{merchantId}/accounttax/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Patch(BigInteger bigInteger, BigInteger bigInteger2, AccountTax accountTax) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)accountTax, AccountTax.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Patch setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Patch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<AccounttaxListResponse> {
            private static final String REST_PATH = "{merchantId}/accounttax";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccounttaxListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<AccountTax> {
            private static final String REST_PATH = "{merchantId}/accounttax/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountTax.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<AccounttaxCustomBatchResponse> {
            private static final String REST_PATH = "accounttax/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(AccounttaxCustomBatchRequest accounttaxCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)accounttaxCustomBatchRequest, AccounttaxCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Accountstatuses {
        public Custombatch custombatch(AccountstatusesCustomBatchRequest accountstatusesCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(accountstatusesCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Get get = new Get(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<AccountstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/accountstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private java.util.List<String> destinations;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public List setDestinations(java.util.List<String> list) {
                this.destinations = list;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<AccountStatus> {
            private static final String REST_PATH = "{merchantId}/accountstatuses/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private java.util.List<String> destinations;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public Get setDestinations(java.util.List<String> list) {
                this.destinations = list;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<AccountstatusesCustomBatchResponse> {
            private static final String REST_PATH = "accountstatuses/batch";

            protected Custombatch(AccountstatusesCustomBatchRequest accountstatusesCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)accountstatusesCustomBatchRequest, AccountstatusesCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }
    }

    public class Accounts {
        public Authinfo authinfo() throws IOException {
            Authinfo authinfo = new Authinfo();
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)authinfo);
            return authinfo;
        }

        public Claimwebsite claimwebsite(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Claimwebsite claimwebsite = new Claimwebsite(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)claimwebsite);
            return claimwebsite;
        }

        public Custombatch custombatch(AccountsCustomBatchRequest accountsCustomBatchRequest) throws IOException {
            Custombatch custombatch = new Custombatch(accountsCustomBatchRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)custombatch);
            return custombatch;
        }

        public Delete delete(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Delete delete = new Delete(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
            Get get = new Get(bigInteger, bigInteger2);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(BigInteger bigInteger, Account account) throws IOException {
            Insert insert = new Insert(bigInteger, account);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Link link(BigInteger bigInteger, BigInteger bigInteger2, AccountsLinkRequest accountsLinkRequest) throws IOException {
            Link link = new Link(bigInteger, bigInteger2, accountsLinkRequest);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)link);
            return link;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(BigInteger bigInteger, BigInteger bigInteger2, Account account) throws IOException {
            Patch patch = new Patch(bigInteger, bigInteger2, account);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(BigInteger bigInteger, BigInteger bigInteger2, Account account) throws IOException {
            Update update = new Update(bigInteger, bigInteger2, account);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Update(BigInteger bigInteger, BigInteger bigInteger2, Account account) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)account, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
                this.checkRequiredParameter((Object)account, "content");
                this.checkRequiredParameter(account.getId(), "Account.getId()");
                this.checkRequiredParameter((Object)account, "content");
                this.checkRequiredParameter(account.getName(), "Account.getName()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Update setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;

            protected Patch(BigInteger bigInteger, BigInteger bigInteger2, Account account) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)account, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Patch setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Patch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ShoppingContentRequest<AccountsListResponse> {
            private static final String REST_PATH = "{merchantId}/accounts";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger bigInteger) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Link
        extends ShoppingContentRequest<AccountsLinkResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/link";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Link(BigInteger bigInteger, BigInteger bigInteger2, AccountsLinkRequest accountsLinkRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)accountsLinkRequest, AccountsLinkResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Link setAlt(String string) {
                return (Link)super.setAlt(string);
            }

            public Link setFields(String string) {
                return (Link)super.setFields(string);
            }

            public Link setKey(String string) {
                return (Link)super.setKey(string);
            }

            public Link setOauthToken(String string) {
                return (Link)super.setOauthToken(string);
            }

            public Link setPrettyPrint(Boolean bl) {
                return (Link)super.setPrettyPrint(bl);
            }

            public Link setQuotaUser(String string) {
                return (Link)super.setQuotaUser(string);
            }

            public Link setUserIp(String string) {
                return (Link)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Link setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Link setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            @Override
            public Link set(String string, Object object) {
                return (Link)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts";
            @Key
            private BigInteger merchantId;
            @Key
            private Boolean dryRun;

            protected Insert(BigInteger bigInteger, Account account) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)account, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.checkRequiredParameter((Object)account, "content");
                this.checkRequiredParameter(account.getName(), "Account.getName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Insert setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean dryRun;
            @Key
            private Boolean force;

            protected Delete(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Delete setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Delete setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            public Boolean getForce() {
                return this.force;
            }

            public Delete setForce(Boolean bl) {
                this.force = bl;
                return this;
            }

            public boolean isForce() {
                if (this.force == null || this.force == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.force;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Custombatch
        extends ShoppingContentRequest<AccountsCustomBatchResponse> {
            private static final String REST_PATH = "accounts/batch";
            @Key
            private Boolean dryRun;

            protected Custombatch(AccountsCustomBatchRequest accountsCustomBatchRequest) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)accountsCustomBatchRequest, AccountsCustomBatchResponse.class);
            }

            public Custombatch setAlt(String string) {
                return (Custombatch)super.setAlt(string);
            }

            public Custombatch setFields(String string) {
                return (Custombatch)super.setFields(string);
            }

            public Custombatch setKey(String string) {
                return (Custombatch)super.setKey(string);
            }

            public Custombatch setOauthToken(String string) {
                return (Custombatch)super.setOauthToken(string);
            }

            public Custombatch setPrettyPrint(Boolean bl) {
                return (Custombatch)super.setPrettyPrint(bl);
            }

            public Custombatch setQuotaUser(String string) {
                return (Custombatch)super.setQuotaUser(string);
            }

            public Custombatch setUserIp(String string) {
                return (Custombatch)super.setUserIp(string);
            }

            public Boolean getDryRun() {
                return this.dryRun;
            }

            public Custombatch setDryRun(Boolean bl) {
                this.dryRun = bl;
                return this;
            }

            @Override
            public Custombatch set(String string, Object object) {
                return (Custombatch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Claimwebsite
        extends ShoppingContentRequest<AccountsClaimWebsiteResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/claimwebsite";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean overwrite;

            protected Claimwebsite(BigInteger bigInteger, BigInteger bigInteger2) {
                super(ShoppingContent.this, "POST", REST_PATH, null, AccountsClaimWebsiteResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger2, (Object)"Required parameter accountId must be specified.");
            }

            public Claimwebsite setAlt(String string) {
                return (Claimwebsite)super.setAlt(string);
            }

            public Claimwebsite setFields(String string) {
                return (Claimwebsite)super.setFields(string);
            }

            public Claimwebsite setKey(String string) {
                return (Claimwebsite)super.setKey(string);
            }

            public Claimwebsite setOauthToken(String string) {
                return (Claimwebsite)super.setOauthToken(string);
            }

            public Claimwebsite setPrettyPrint(Boolean bl) {
                return (Claimwebsite)super.setPrettyPrint(bl);
            }

            public Claimwebsite setQuotaUser(String string) {
                return (Claimwebsite)super.setQuotaUser(string);
            }

            public Claimwebsite setUserIp(String string) {
                return (Claimwebsite)super.setUserIp(string);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Claimwebsite setMerchantId(BigInteger bigInteger) {
                this.merchantId = bigInteger;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Claimwebsite setAccountId(BigInteger bigInteger) {
                this.accountId = bigInteger;
                return this;
            }

            public Boolean getOverwrite() {
                return this.overwrite;
            }

            public Claimwebsite setOverwrite(Boolean bl) {
                this.overwrite = bl;
                return this;
            }

            @Override
            public Claimwebsite set(String string, Object object) {
                return (Claimwebsite)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Authinfo
        extends ShoppingContentRequest<AccountsAuthInfoResponse> {
            private static final String REST_PATH = "accounts/authinfo";

            protected Authinfo() {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsAuthInfoResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Authinfo setAlt(String string) {
                return (Authinfo)super.setAlt(string);
            }

            public Authinfo setFields(String string) {
                return (Authinfo)super.setFields(string);
            }

            public Authinfo setKey(String string) {
                return (Authinfo)super.setKey(string);
            }

            public Authinfo setOauthToken(String string) {
                return (Authinfo)super.setOauthToken(string);
            }

            public Authinfo setPrettyPrint(Boolean bl) {
                return (Authinfo)super.setPrettyPrint(bl);
            }

            public Authinfo setQuotaUser(String string) {
                return (Authinfo)super.setQuotaUser(string);
            }

            public Authinfo setUserIp(String string) {
                return (Authinfo)super.setUserIp(string);
            }

            @Override
            public Authinfo set(String string, Object object) {
                return (Authinfo)super.set(string, object);
            }
        }
    }
}

