/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The single value of a rate group or the value of a rate group table's cell. Exactly one of
 * noShipping, flatRate, pricePercentage, carrierRateName, subtableName must be set.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Value extends com.google.api.client.json.GenericJson {

  /**
   * The name of a carrier rate referring to a carrier rate defined in the same rate group. Can only
   * be set if all other fields are not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierRateName;

  /**
   * A flat rate. Can only be set if all other fields are not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price flatRate;

  /**
   * If true, then the product can't ship. Must be true when set, can only be set if all other
   * fields are not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean noShipping;

  /**
   * A percentage of the price represented as a number in decimal notation (e.g., "5.4"). Can only
   * be set if all other fields are not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pricePercentage;

  /**
   * The name of a subtable. Can only be set in table cells (i.e., not for single values), and only
   * if all other fields are not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subtableName;

  /**
   * The name of a carrier rate referring to a carrier rate defined in the same rate group. Can only
   * be set if all other fields are not set.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierRateName() {
    return carrierRateName;
  }

  /**
   * The name of a carrier rate referring to a carrier rate defined in the same rate group. Can only
   * be set if all other fields are not set.
   * @param carrierRateName carrierRateName or {@code null} for none
   */
  public Value setCarrierRateName(java.lang.String carrierRateName) {
    this.carrierRateName = carrierRateName;
    return this;
  }

  /**
   * A flat rate. Can only be set if all other fields are not set.
   * @return value or {@code null} for none
   */
  public Price getFlatRate() {
    return flatRate;
  }

  /**
   * A flat rate. Can only be set if all other fields are not set.
   * @param flatRate flatRate or {@code null} for none
   */
  public Value setFlatRate(Price flatRate) {
    this.flatRate = flatRate;
    return this;
  }

  /**
   * If true, then the product can't ship. Must be true when set, can only be set if all other
   * fields are not set.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNoShipping() {
    return noShipping;
  }

  /**
   * If true, then the product can't ship. Must be true when set, can only be set if all other
   * fields are not set.
   * @param noShipping noShipping or {@code null} for none
   */
  public Value setNoShipping(java.lang.Boolean noShipping) {
    this.noShipping = noShipping;
    return this;
  }

  /**
   * A percentage of the price represented as a number in decimal notation (e.g., "5.4"). Can only
   * be set if all other fields are not set.
   * @return value or {@code null} for none
   */
  public java.lang.String getPricePercentage() {
    return pricePercentage;
  }

  /**
   * A percentage of the price represented as a number in decimal notation (e.g., "5.4"). Can only
   * be set if all other fields are not set.
   * @param pricePercentage pricePercentage or {@code null} for none
   */
  public Value setPricePercentage(java.lang.String pricePercentage) {
    this.pricePercentage = pricePercentage;
    return this;
  }

  /**
   * The name of a subtable. Can only be set in table cells (i.e., not for single values), and only
   * if all other fields are not set.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubtableName() {
    return subtableName;
  }

  /**
   * The name of a subtable. Can only be set in table cells (i.e., not for single values), and only
   * if all other fields are not set.
   * @param subtableName subtableName or {@code null} for none
   */
  public Value setSubtableName(java.lang.String subtableName) {
    this.subtableName = subtableName;
    return this;
  }

  @Override
  public Value set(String fieldName, Object value) {
    return (Value) super.set(fieldName, value);
  }

  @Override
  public Value clone() {
    return (Value) super.clone();
  }

}
