/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ShipmentInvoiceLineItemInvoice.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShipmentInvoiceLineItemInvoice extends com.google.api.client.json.GenericJson {

  /**
   * ID of the line item. Either lineItemId or productId must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineItemId;

  /**
   * ID of the product. This is the REST ID used in the products service. Either lineItemId or
   * productId must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * [required] The shipment unit ID is assigned by the merchant and defines individual quantities
   * within a line item. The same ID can be assigned to units that are the same while units that
   * differ must be assigned a different ID (for example: free or promotional units).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> shipmentUnitIds;

  /**
   * [required] Invoice details for a single unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UnitInvoice unitInvoice;

  /**
   * ID of the line item. Either lineItemId or productId must be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineItemId() {
    return lineItemId;
  }

  /**
   * ID of the line item. Either lineItemId or productId must be set.
   * @param lineItemId lineItemId or {@code null} for none
   */
  public ShipmentInvoiceLineItemInvoice setLineItemId(java.lang.String lineItemId) {
    this.lineItemId = lineItemId;
    return this;
  }

  /**
   * ID of the product. This is the REST ID used in the products service. Either lineItemId or
   * productId must be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * ID of the product. This is the REST ID used in the products service. Either lineItemId or
   * productId must be set.
   * @param productId productId or {@code null} for none
   */
  public ShipmentInvoiceLineItemInvoice setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  /**
   * [required] The shipment unit ID is assigned by the merchant and defines individual quantities
   * within a line item. The same ID can be assigned to units that are the same while units that
   * differ must be assigned a different ID (for example: free or promotional units).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getShipmentUnitIds() {
    return shipmentUnitIds;
  }

  /**
   * [required] The shipment unit ID is assigned by the merchant and defines individual quantities
   * within a line item. The same ID can be assigned to units that are the same while units that
   * differ must be assigned a different ID (for example: free or promotional units).
   * @param shipmentUnitIds shipmentUnitIds or {@code null} for none
   */
  public ShipmentInvoiceLineItemInvoice setShipmentUnitIds(java.util.List<java.lang.String> shipmentUnitIds) {
    this.shipmentUnitIds = shipmentUnitIds;
    return this;
  }

  /**
   * [required] Invoice details for a single unit.
   * @return value or {@code null} for none
   */
  public UnitInvoice getUnitInvoice() {
    return unitInvoice;
  }

  /**
   * [required] Invoice details for a single unit.
   * @param unitInvoice unitInvoice or {@code null} for none
   */
  public ShipmentInvoiceLineItemInvoice setUnitInvoice(UnitInvoice unitInvoice) {
    this.unitInvoice = unitInvoice;
    return this;
  }

  @Override
  public ShipmentInvoiceLineItemInvoice set(String fieldName, Object value) {
    return (ShipmentInvoiceLineItemInvoice) super.set(fieldName, value);
  }

  @Override
  public ShipmentInvoiceLineItemInvoice clone() {
    return (ShipmentInvoiceLineItemInvoice) super.clone();
  }

}
