/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ShipmentInvoice.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShipmentInvoice extends com.google.api.client.json.GenericJson {

  /**
   * [required] Invoice summary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InvoiceSummary invoiceSummary;

  /**
   * [required] Invoice details per line item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ShipmentInvoiceLineItemInvoice> lineItemInvoices;

  /**
   * [required] ID of the shipment group. It is assigned by the merchant in the shipLineItems method
   * and is used to group multiple line items that have the same kind of shipping charges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shipmentGroupId;

  /**
   * [required] Invoice summary.
   * @return value or {@code null} for none
   */
  public InvoiceSummary getInvoiceSummary() {
    return invoiceSummary;
  }

  /**
   * [required] Invoice summary.
   * @param invoiceSummary invoiceSummary or {@code null} for none
   */
  public ShipmentInvoice setInvoiceSummary(InvoiceSummary invoiceSummary) {
    this.invoiceSummary = invoiceSummary;
    return this;
  }

  /**
   * [required] Invoice details per line item.
   * @return value or {@code null} for none
   */
  public java.util.List<ShipmentInvoiceLineItemInvoice> getLineItemInvoices() {
    return lineItemInvoices;
  }

  /**
   * [required] Invoice details per line item.
   * @param lineItemInvoices lineItemInvoices or {@code null} for none
   */
  public ShipmentInvoice setLineItemInvoices(java.util.List<ShipmentInvoiceLineItemInvoice> lineItemInvoices) {
    this.lineItemInvoices = lineItemInvoices;
    return this;
  }

  /**
   * [required] ID of the shipment group. It is assigned by the merchant in the shipLineItems method
   * and is used to group multiple line items that have the same kind of shipping charges.
   * @return value or {@code null} for none
   */
  public java.lang.String getShipmentGroupId() {
    return shipmentGroupId;
  }

  /**
   * [required] ID of the shipment group. It is assigned by the merchant in the shipLineItems method
   * and is used to group multiple line items that have the same kind of shipping charges.
   * @param shipmentGroupId shipmentGroupId or {@code null} for none
   */
  public ShipmentInvoice setShipmentGroupId(java.lang.String shipmentGroupId) {
    this.shipmentGroupId = shipmentGroupId;
    return this;
  }

  @Override
  public ShipmentInvoice set(String fieldName, Object value) {
    return (ShipmentInvoice) super.set(fieldName, value);
  }

  @Override
  public ShipmentInvoice clone() {
    return (ShipmentInvoice) super.clone();
  }

}
