/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for Service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Service extends com.google.api.client.json.GenericJson {

  /**
   * A boolean exposing the active status of the shipping service. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * The CLDR code of the currency to which this service applies. Must match that of the prices in
   * rate groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currency;

  /**
   * The CLDR territory code of the country to which the service applies. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryCountry;

  /**
   * Time spent in various aspects from order to the delivery of the product. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeliveryTime deliveryTime;

  /**
   * Eligibility for this service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eligibility;

  /**
   * Minimum order value for this service. If set, indicates that customers will have to spend at
   * least this amount. All prices within a service must have the same currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price minimumOrderValue;

  /**
   * Free-form name of the service. Must be unique within target account. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Shipping rate group definitions. Only the last one is allowed to have an empty
   * applicableShippingLabels, which means "everything else". The other applicableShippingLabels
   * must not overlap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RateGroup> rateGroups;

  static {
    // hack to force ProGuard to consider RateGroup used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(RateGroup.class);
  }

  /**
   * A boolean exposing the active status of the shipping service. Required.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * A boolean exposing the active status of the shipping service. Required.
   * @param active active or {@code null} for none
   */
  public Service setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * The CLDR code of the currency to which this service applies. Must match that of the prices in
   * rate groups.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrency() {
    return currency;
  }

  /**
   * The CLDR code of the currency to which this service applies. Must match that of the prices in
   * rate groups.
   * @param currency currency or {@code null} for none
   */
  public Service setCurrency(java.lang.String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * The CLDR territory code of the country to which the service applies. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryCountry() {
    return deliveryCountry;
  }

  /**
   * The CLDR territory code of the country to which the service applies. Required.
   * @param deliveryCountry deliveryCountry or {@code null} for none
   */
  public Service setDeliveryCountry(java.lang.String deliveryCountry) {
    this.deliveryCountry = deliveryCountry;
    return this;
  }

  /**
   * Time spent in various aspects from order to the delivery of the product. Required.
   * @return value or {@code null} for none
   */
  public DeliveryTime getDeliveryTime() {
    return deliveryTime;
  }

  /**
   * Time spent in various aspects from order to the delivery of the product. Required.
   * @param deliveryTime deliveryTime or {@code null} for none
   */
  public Service setDeliveryTime(DeliveryTime deliveryTime) {
    this.deliveryTime = deliveryTime;
    return this;
  }

  /**
   * Eligibility for this service.
   * @return value or {@code null} for none
   */
  public java.lang.String getEligibility() {
    return eligibility;
  }

  /**
   * Eligibility for this service.
   * @param eligibility eligibility or {@code null} for none
   */
  public Service setEligibility(java.lang.String eligibility) {
    this.eligibility = eligibility;
    return this;
  }

  /**
   * Minimum order value for this service. If set, indicates that customers will have to spend at
   * least this amount. All prices within a service must have the same currency.
   * @return value or {@code null} for none
   */
  public Price getMinimumOrderValue() {
    return minimumOrderValue;
  }

  /**
   * Minimum order value for this service. If set, indicates that customers will have to spend at
   * least this amount. All prices within a service must have the same currency.
   * @param minimumOrderValue minimumOrderValue or {@code null} for none
   */
  public Service setMinimumOrderValue(Price minimumOrderValue) {
    this.minimumOrderValue = minimumOrderValue;
    return this;
  }

  /**
   * Free-form name of the service. Must be unique within target account. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Free-form name of the service. Must be unique within target account. Required.
   * @param name name or {@code null} for none
   */
  public Service setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Shipping rate group definitions. Only the last one is allowed to have an empty
   * applicableShippingLabels, which means "everything else". The other applicableShippingLabels
   * must not overlap.
   * @return value or {@code null} for none
   */
  public java.util.List<RateGroup> getRateGroups() {
    return rateGroups;
  }

  /**
   * Shipping rate group definitions. Only the last one is allowed to have an empty
   * applicableShippingLabels, which means "everything else". The other applicableShippingLabels
   * must not overlap.
   * @param rateGroups rateGroups or {@code null} for none
   */
  public Service setRateGroups(java.util.List<RateGroup> rateGroups) {
    this.rateGroups = rateGroups;
    return this;
  }

  @Override
  public Service set(String fieldName, Object value) {
    return (Service) super.set(fieldName, value);
  }

  @Override
  public Service clone() {
    return (Service) super.clone();
  }

}
