/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ProductAmount.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductAmount extends com.google.api.client.json.GenericJson {

  /**
   * The pre-tax or post-tax price depending on the location of the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price priceAmount;

  /**
   * Remitted tax value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price remittedTaxAmount;

  /**
   * Tax value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price taxAmount;

  /**
   * The pre-tax or post-tax price depending on the location of the order.
   * @return value or {@code null} for none
   */
  public Price getPriceAmount() {
    return priceAmount;
  }

  /**
   * The pre-tax or post-tax price depending on the location of the order.
   * @param priceAmount priceAmount or {@code null} for none
   */
  public ProductAmount setPriceAmount(Price priceAmount) {
    this.priceAmount = priceAmount;
    return this;
  }

  /**
   * Remitted tax value.
   * @return value or {@code null} for none
   */
  public Price getRemittedTaxAmount() {
    return remittedTaxAmount;
  }

  /**
   * Remitted tax value.
   * @param remittedTaxAmount remittedTaxAmount or {@code null} for none
   */
  public ProductAmount setRemittedTaxAmount(Price remittedTaxAmount) {
    this.remittedTaxAmount = remittedTaxAmount;
    return this;
  }

  /**
   * Tax value.
   * @return value or {@code null} for none
   */
  public Price getTaxAmount() {
    return taxAmount;
  }

  /**
   * Tax value.
   * @param taxAmount taxAmount or {@code null} for none
   */
  public ProductAmount setTaxAmount(Price taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

  @Override
  public ProductAmount set(String fieldName, Object value) {
    return (ProductAmount) super.set(fieldName, value);
  }

  @Override
  public ProductAmount clone() {
    return (ProductAmount) super.clone();
  }

}
