/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The change of the available quantity of an item at the given store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PosSale extends com.google.api.client.json.GenericJson {

  /**
   * The two-letter ISO 639-1 language code for the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentLanguage;

  /**
   * Global Trade Item Number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gtin;

  /**
   * A unique identifier for the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String itemId;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "content#posSale".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The price of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price price;

  /**
   * The relative change of the available quantity. Negative for items returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quantity;

  /**
   * A unique ID to group items from the same sale event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String saleId;

  /**
   * The identifier of the merchant's store. Either a storeCode inserted via the API or the code of
   * the store in Google My Business.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storeCode;

  /**
   * The CLDR territory code for the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetCountry;

  /**
   * The inventory timestamp, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timestamp;

  /**
   * The two-letter ISO 639-1 language code for the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentLanguage() {
    return contentLanguage;
  }

  /**
   * The two-letter ISO 639-1 language code for the item.
   * @param contentLanguage contentLanguage or {@code null} for none
   */
  public PosSale setContentLanguage(java.lang.String contentLanguage) {
    this.contentLanguage = contentLanguage;
    return this;
  }

  /**
   * Global Trade Item Number.
   * @return value or {@code null} for none
   */
  public java.lang.String getGtin() {
    return gtin;
  }

  /**
   * Global Trade Item Number.
   * @param gtin gtin or {@code null} for none
   */
  public PosSale setGtin(java.lang.String gtin) {
    this.gtin = gtin;
    return this;
  }

  /**
   * A unique identifier for the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getItemId() {
    return itemId;
  }

  /**
   * A unique identifier for the item.
   * @param itemId itemId or {@code null} for none
   */
  public PosSale setItemId(java.lang.String itemId) {
    this.itemId = itemId;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "content#posSale".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "content#posSale".
   * @param kind kind or {@code null} for none
   */
  public PosSale setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The price of the item.
   * @return value or {@code null} for none
   */
  public Price getPrice() {
    return price;
  }

  /**
   * The price of the item.
   * @param price price or {@code null} for none
   */
  public PosSale setPrice(Price price) {
    this.price = price;
    return this;
  }

  /**
   * The relative change of the available quantity. Negative for items returned.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuantity() {
    return quantity;
  }

  /**
   * The relative change of the available quantity. Negative for items returned.
   * @param quantity quantity or {@code null} for none
   */
  public PosSale setQuantity(java.lang.Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * A unique ID to group items from the same sale event.
   * @return value or {@code null} for none
   */
  public java.lang.String getSaleId() {
    return saleId;
  }

  /**
   * A unique ID to group items from the same sale event.
   * @param saleId saleId or {@code null} for none
   */
  public PosSale setSaleId(java.lang.String saleId) {
    this.saleId = saleId;
    return this;
  }

  /**
   * The identifier of the merchant's store. Either a storeCode inserted via the API or the code of
   * the store in Google My Business.
   * @return value or {@code null} for none
   */
  public java.lang.String getStoreCode() {
    return storeCode;
  }

  /**
   * The identifier of the merchant's store. Either a storeCode inserted via the API or the code of
   * the store in Google My Business.
   * @param storeCode storeCode or {@code null} for none
   */
  public PosSale setStoreCode(java.lang.String storeCode) {
    this.storeCode = storeCode;
    return this;
  }

  /**
   * The CLDR territory code for the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetCountry() {
    return targetCountry;
  }

  /**
   * The CLDR territory code for the item.
   * @param targetCountry targetCountry or {@code null} for none
   */
  public PosSale setTargetCountry(java.lang.String targetCountry) {
    this.targetCountry = targetCountry;
    return this;
  }

  /**
   * The inventory timestamp, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimestamp() {
    return timestamp;
  }

  /**
   * The inventory timestamp, in ISO 8601 format.
   * @param timestamp timestamp or {@code null} for none
   */
  public PosSale setTimestamp(java.lang.String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  @Override
  public PosSale set(String fieldName, Object value) {
    return (PosSale) super.set(fieldName, value);
  }

  @Override
  public PosSale clone() {
    return (PosSale) super.clone();
  }

}
