/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails extends com.google.api.client.json.GenericJson {

  /**
   * Updated delivery by date, in ISO 8601 format. If not specified only ship by date is updated.
   *
   * Provided date should be within 1 year timeframe and can not be a date in the past.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliverByDate;

  /**
   * The ID of the line item to set metadata. Either lineItemId or productId is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineItemId;

  /**
   * The ID of the product to set metadata. This is the REST ID used in the products service. Either
   * lineItemId or productId is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * Updated ship by date, in ISO 8601 format. If not specified only deliver by date is updated.
   *
   * Provided date should be within 1 year timeframe and can not be a date in the past.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shipByDate;

  /**
   * Updated delivery by date, in ISO 8601 format. If not specified only ship by date is updated.
   *
   * Provided date should be within 1 year timeframe and can not be a date in the past.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliverByDate() {
    return deliverByDate;
  }

  /**
   * Updated delivery by date, in ISO 8601 format. If not specified only ship by date is updated.
   *
   * Provided date should be within 1 year timeframe and can not be a date in the past.
   * @param deliverByDate deliverByDate or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails setDeliverByDate(java.lang.String deliverByDate) {
    this.deliverByDate = deliverByDate;
    return this;
  }

  /**
   * The ID of the line item to set metadata. Either lineItemId or productId is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineItemId() {
    return lineItemId;
  }

  /**
   * The ID of the line item to set metadata. Either lineItemId or productId is required.
   * @param lineItemId lineItemId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails setLineItemId(java.lang.String lineItemId) {
    this.lineItemId = lineItemId;
    return this;
  }

  /**
   * The ID of the product to set metadata. This is the REST ID used in the products service. Either
   * lineItemId or productId is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * The ID of the product to set metadata. This is the REST ID used in the products service. Either
   * lineItemId or productId is required.
   * @param productId productId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  /**
   * Updated ship by date, in ISO 8601 format. If not specified only deliver by date is updated.
   *
   * Provided date should be within 1 year timeframe and can not be a date in the past.
   * @return value or {@code null} for none
   */
  public java.lang.String getShipByDate() {
    return shipByDate;
  }

  /**
   * Updated ship by date, in ISO 8601 format. If not specified only deliver by date is updated.
   *
   * Provided date should be within 1 year timeframe and can not be a date in the past.
   * @param shipByDate shipByDate or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails setShipByDate(java.lang.String shipByDate) {
    this.shipByDate = shipByDate;
    return this;
  }

  @Override
  public OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails set(String fieldName, Object value) {
    return (OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails) super.set(fieldName, value);
  }

  @Override
  public OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails clone() {
    return (OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails) super.clone();
  }

}
