/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersCustomBatchRequestEntryRefund.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersCustomBatchRequestEntryRefund extends com.google.api.client.json.GenericJson {

  /**
   * Deprecated. Please use amountPretax and amountTax instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price amount;

  /**
   * The amount that is refunded. Either amount or amountPretax should be filled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price amountPretax;

  /**
   * Tax amount that corresponds to refund amount in amountPretax. Optional, but if filled,
   * amountPretax must be set. Calculated automatically if not provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price amountTax;

  /**
   * The reason for the refund.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The explanation of the reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonText;

  /**
   * Deprecated. Please use amountPretax and amountTax instead.
   * @return value or {@code null} for none
   */
  public Price getAmount() {
    return amount;
  }

  /**
   * Deprecated. Please use amountPretax and amountTax instead.
   * @param amount amount or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefund setAmount(Price amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The amount that is refunded. Either amount or amountPretax should be filled.
   * @return value or {@code null} for none
   */
  public Price getAmountPretax() {
    return amountPretax;
  }

  /**
   * The amount that is refunded. Either amount or amountPretax should be filled.
   * @param amountPretax amountPretax or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefund setAmountPretax(Price amountPretax) {
    this.amountPretax = amountPretax;
    return this;
  }

  /**
   * Tax amount that corresponds to refund amount in amountPretax. Optional, but if filled,
   * amountPretax must be set. Calculated automatically if not provided.
   * @return value or {@code null} for none
   */
  public Price getAmountTax() {
    return amountTax;
  }

  /**
   * Tax amount that corresponds to refund amount in amountPretax. Optional, but if filled,
   * amountPretax must be set. Calculated automatically if not provided.
   * @param amountTax amountTax or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefund setAmountTax(Price amountTax) {
    this.amountTax = amountTax;
    return this;
  }

  /**
   * The reason for the refund.
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The reason for the refund.
   * @param reason reason or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefund setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The explanation of the reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonText() {
    return reasonText;
  }

  /**
   * The explanation of the reason.
   * @param reasonText reasonText or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefund setReasonText(java.lang.String reasonText) {
    this.reasonText = reasonText;
    return this;
  }

  @Override
  public OrdersCustomBatchRequestEntryRefund set(String fieldName, Object value) {
    return (OrdersCustomBatchRequestEntryRefund) super.set(fieldName, value);
  }

  @Override
  public OrdersCustomBatchRequestEntryRefund clone() {
    return (OrdersCustomBatchRequestEntryRefund) super.clone();
  }

}
