/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersCustomBatchRequestEntry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersCustomBatchRequestEntry extends com.google.api.client.json.GenericJson {

  /**
   * An entry ID, unique within the batch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * Required for cancel method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryCancel cancel;

  /**
   * Required for cancelLineItem method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryCancelLineItem cancelLineItem;

  /**
   * Required for inStoreReturnLineItem method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryInStoreRefundLineItem inStoreRefundLineItem;

  /**
   * The ID of the managing account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * The merchant order ID. Required for updateMerchantOrderId and getByMerchantOrderId methods.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String merchantOrderId;

  /**
   * The method to apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * The ID of the operation. Unique across all operations for a given order. Required for all
   * methods beside get and getByMerchantOrderId.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operationId;

  /**
   * The ID of the order. Required for all methods beside getByMerchantOrderId.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderId;

  /**
   * Required for refund method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryRefund refund;

  /**
   * Required for rejectReturnLineItem method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryRejectReturnLineItem rejectReturnLineItem;

  /**
   * Required for returnLineItem method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryReturnLineItem returnLineItem;

  /**
   * Required for returnRefundLineItem method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryReturnRefundLineItem returnRefundLineItem;

  /**
   * Required for setLineItemMetadata method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntrySetLineItemMetadata setLineItemMetadata;

  /**
   * Required for shipLineItems method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryShipLineItems shipLineItems;

  /**
   * Required for updateLineItemShippingDate method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails updateLineItemShippingDetails;

  /**
   * Required for updateShipment method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryUpdateShipment updateShipment;

  /**
   * An entry ID, unique within the batch request.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * An entry ID, unique within the batch request.
   * @param batchId batchId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * Required for cancel method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryCancel getCancel() {
    return cancel;
  }

  /**
   * Required for cancel method.
   * @param cancel cancel or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setCancel(OrdersCustomBatchRequestEntryCancel cancel) {
    this.cancel = cancel;
    return this;
  }

  /**
   * Required for cancelLineItem method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryCancelLineItem getCancelLineItem() {
    return cancelLineItem;
  }

  /**
   * Required for cancelLineItem method.
   * @param cancelLineItem cancelLineItem or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setCancelLineItem(OrdersCustomBatchRequestEntryCancelLineItem cancelLineItem) {
    this.cancelLineItem = cancelLineItem;
    return this;
  }

  /**
   * Required for inStoreReturnLineItem method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryInStoreRefundLineItem getInStoreRefundLineItem() {
    return inStoreRefundLineItem;
  }

  /**
   * Required for inStoreReturnLineItem method.
   * @param inStoreRefundLineItem inStoreRefundLineItem or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setInStoreRefundLineItem(OrdersCustomBatchRequestEntryInStoreRefundLineItem inStoreRefundLineItem) {
    this.inStoreRefundLineItem = inStoreRefundLineItem;
    return this;
  }

  /**
   * The ID of the managing account.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * The ID of the managing account.
   * @param merchantId merchantId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The merchant order ID. Required for updateMerchantOrderId and getByMerchantOrderId methods.
   * @return value or {@code null} for none
   */
  public java.lang.String getMerchantOrderId() {
    return merchantOrderId;
  }

  /**
   * The merchant order ID. Required for updateMerchantOrderId and getByMerchantOrderId methods.
   * @param merchantOrderId merchantOrderId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setMerchantOrderId(java.lang.String merchantOrderId) {
    this.merchantOrderId = merchantOrderId;
    return this;
  }

  /**
   * The method to apply.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method to apply.
   * @param method method or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order. Required for all
   * methods beside get and getByMerchantOrderId.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperationId() {
    return operationId;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order. Required for all
   * methods beside get and getByMerchantOrderId.
   * @param operationId operationId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setOperationId(java.lang.String operationId) {
    this.operationId = operationId;
    return this;
  }

  /**
   * The ID of the order. Required for all methods beside getByMerchantOrderId.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderId() {
    return orderId;
  }

  /**
   * The ID of the order. Required for all methods beside getByMerchantOrderId.
   * @param orderId orderId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setOrderId(java.lang.String orderId) {
    this.orderId = orderId;
    return this;
  }

  /**
   * Required for refund method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefund getRefund() {
    return refund;
  }

  /**
   * Required for refund method.
   * @param refund refund or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setRefund(OrdersCustomBatchRequestEntryRefund refund) {
    this.refund = refund;
    return this;
  }

  /**
   * Required for rejectReturnLineItem method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRejectReturnLineItem getRejectReturnLineItem() {
    return rejectReturnLineItem;
  }

  /**
   * Required for rejectReturnLineItem method.
   * @param rejectReturnLineItem rejectReturnLineItem or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setRejectReturnLineItem(OrdersCustomBatchRequestEntryRejectReturnLineItem rejectReturnLineItem) {
    this.rejectReturnLineItem = rejectReturnLineItem;
    return this;
  }

  /**
   * Required for returnLineItem method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryReturnLineItem getReturnLineItem() {
    return returnLineItem;
  }

  /**
   * Required for returnLineItem method.
   * @param returnLineItem returnLineItem or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setReturnLineItem(OrdersCustomBatchRequestEntryReturnLineItem returnLineItem) {
    this.returnLineItem = returnLineItem;
    return this;
  }

  /**
   * Required for returnRefundLineItem method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryReturnRefundLineItem getReturnRefundLineItem() {
    return returnRefundLineItem;
  }

  /**
   * Required for returnRefundLineItem method.
   * @param returnRefundLineItem returnRefundLineItem or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setReturnRefundLineItem(OrdersCustomBatchRequestEntryReturnRefundLineItem returnRefundLineItem) {
    this.returnRefundLineItem = returnRefundLineItem;
    return this;
  }

  /**
   * Required for setLineItemMetadata method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntrySetLineItemMetadata getSetLineItemMetadata() {
    return setLineItemMetadata;
  }

  /**
   * Required for setLineItemMetadata method.
   * @param setLineItemMetadata setLineItemMetadata or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setSetLineItemMetadata(OrdersCustomBatchRequestEntrySetLineItemMetadata setLineItemMetadata) {
    this.setLineItemMetadata = setLineItemMetadata;
    return this;
  }

  /**
   * Required for shipLineItems method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryShipLineItems getShipLineItems() {
    return shipLineItems;
  }

  /**
   * Required for shipLineItems method.
   * @param shipLineItems shipLineItems or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setShipLineItems(OrdersCustomBatchRequestEntryShipLineItems shipLineItems) {
    this.shipLineItems = shipLineItems;
    return this;
  }

  /**
   * Required for updateLineItemShippingDate method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails getUpdateLineItemShippingDetails() {
    return updateLineItemShippingDetails;
  }

  /**
   * Required for updateLineItemShippingDate method.
   * @param updateLineItemShippingDetails updateLineItemShippingDetails or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setUpdateLineItemShippingDetails(OrdersCustomBatchRequestEntryUpdateLineItemShippingDetails updateLineItemShippingDetails) {
    this.updateLineItemShippingDetails = updateLineItemShippingDetails;
    return this;
  }

  /**
   * Required for updateShipment method.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryUpdateShipment getUpdateShipment() {
    return updateShipment;
  }

  /**
   * Required for updateShipment method.
   * @param updateShipment updateShipment or {@code null} for none
   */
  public OrdersCustomBatchRequestEntry setUpdateShipment(OrdersCustomBatchRequestEntryUpdateShipment updateShipment) {
    this.updateShipment = updateShipment;
    return this;
  }

  @Override
  public OrdersCustomBatchRequestEntry set(String fieldName, Object value) {
    return (OrdersCustomBatchRequestEntry) super.set(fieldName, value);
  }

  @Override
  public OrdersCustomBatchRequestEntry clone() {
    return (OrdersCustomBatchRequestEntry) super.clone();
  }

}
