/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderpaymentsNotifyAuthApprovedRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderpaymentsNotifyAuthApprovedRequest extends com.google.api.client.json.GenericJson {

  /**
   * Authorized amount for pre-tax charge on user's credit card.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price authAmountPretax;

  /**
   * Authorized amount for tax charge on user's credit card.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price authAmountTax;

  /**
   * Authorized amount for pre-tax charge on user's credit card.
   * @return value or {@code null} for none
   */
  public Price getAuthAmountPretax() {
    return authAmountPretax;
  }

  /**
   * Authorized amount for pre-tax charge on user's credit card.
   * @param authAmountPretax authAmountPretax or {@code null} for none
   */
  public OrderpaymentsNotifyAuthApprovedRequest setAuthAmountPretax(Price authAmountPretax) {
    this.authAmountPretax = authAmountPretax;
    return this;
  }

  /**
   * Authorized amount for tax charge on user's credit card.
   * @return value or {@code null} for none
   */
  public Price getAuthAmountTax() {
    return authAmountTax;
  }

  /**
   * Authorized amount for tax charge on user's credit card.
   * @param authAmountTax authAmountTax or {@code null} for none
   */
  public OrderpaymentsNotifyAuthApprovedRequest setAuthAmountTax(Price authAmountTax) {
    this.authAmountTax = authAmountTax;
    return this;
  }

  @Override
  public OrderpaymentsNotifyAuthApprovedRequest set(String fieldName, Object value) {
    return (OrderpaymentsNotifyAuthApprovedRequest) super.set(fieldName, value);
  }

  @Override
  public OrderpaymentsNotifyAuthApprovedRequest clone() {
    return (OrderpaymentsNotifyAuthApprovedRequest) super.clone();
  }

}
