/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderLineItemProduct.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderLineItemProduct extends com.google.api.client.json.GenericJson {

  /**
   * Brand of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String brand;

  /**
   * The item's channel (online or local).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channel;

  /**
   * Condition or state of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String condition;

  /**
   * The two-letter ISO 639-1 language code for the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentLanguage;

  /**
   * Associated fees at order creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderLineItemProductFee> fees;

  /**
   * Global Trade Item Number (GTIN) of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gtin;

  /**
   * The REST ID of the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * URL of an image of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageLink;

  /**
   * Shared identifier for all variants of the same product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String itemGroupId;

  /**
   * Manufacturer Part Number (MPN) of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mpn;

  /**
   * An identifier of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String offerId;

  /**
   * Price of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price price;

  /**
   * URL to the cached image shown to the user when order was placed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shownImage;

  /**
   * The CLDR territory code of the target country of the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetCountry;

  /**
   * The title of the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Variant attributes for the item. These are dimensions of the product, such as color, gender,
   * material, pattern, and size. You can find a comprehensive list of variant attributes here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderLineItemProductVariantAttribute> variantAttributes;

  /**
   * Brand of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getBrand() {
    return brand;
  }

  /**
   * Brand of the item.
   * @param brand brand or {@code null} for none
   */
  public OrderLineItemProduct setBrand(java.lang.String brand) {
    this.brand = brand;
    return this;
  }

  /**
   * The item's channel (online or local).
   * @return value or {@code null} for none
   */
  public java.lang.String getChannel() {
    return channel;
  }

  /**
   * The item's channel (online or local).
   * @param channel channel or {@code null} for none
   */
  public OrderLineItemProduct setChannel(java.lang.String channel) {
    this.channel = channel;
    return this;
  }

  /**
   * Condition or state of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getCondition() {
    return condition;
  }

  /**
   * Condition or state of the item.
   * @param condition condition or {@code null} for none
   */
  public OrderLineItemProduct setCondition(java.lang.String condition) {
    this.condition = condition;
    return this;
  }

  /**
   * The two-letter ISO 639-1 language code for the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentLanguage() {
    return contentLanguage;
  }

  /**
   * The two-letter ISO 639-1 language code for the item.
   * @param contentLanguage contentLanguage or {@code null} for none
   */
  public OrderLineItemProduct setContentLanguage(java.lang.String contentLanguage) {
    this.contentLanguage = contentLanguage;
    return this;
  }

  /**
   * Associated fees at order creation time.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderLineItemProductFee> getFees() {
    return fees;
  }

  /**
   * Associated fees at order creation time.
   * @param fees fees or {@code null} for none
   */
  public OrderLineItemProduct setFees(java.util.List<OrderLineItemProductFee> fees) {
    this.fees = fees;
    return this;
  }

  /**
   * Global Trade Item Number (GTIN) of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getGtin() {
    return gtin;
  }

  /**
   * Global Trade Item Number (GTIN) of the item.
   * @param gtin gtin or {@code null} for none
   */
  public OrderLineItemProduct setGtin(java.lang.String gtin) {
    this.gtin = gtin;
    return this;
  }

  /**
   * The REST ID of the product.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The REST ID of the product.
   * @param id id or {@code null} for none
   */
  public OrderLineItemProduct setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * URL of an image of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageLink() {
    return imageLink;
  }

  /**
   * URL of an image of the item.
   * @param imageLink imageLink or {@code null} for none
   */
  public OrderLineItemProduct setImageLink(java.lang.String imageLink) {
    this.imageLink = imageLink;
    return this;
  }

  /**
   * Shared identifier for all variants of the same product.
   * @return value or {@code null} for none
   */
  public java.lang.String getItemGroupId() {
    return itemGroupId;
  }

  /**
   * Shared identifier for all variants of the same product.
   * @param itemGroupId itemGroupId or {@code null} for none
   */
  public OrderLineItemProduct setItemGroupId(java.lang.String itemGroupId) {
    this.itemGroupId = itemGroupId;
    return this;
  }

  /**
   * Manufacturer Part Number (MPN) of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getMpn() {
    return mpn;
  }

  /**
   * Manufacturer Part Number (MPN) of the item.
   * @param mpn mpn or {@code null} for none
   */
  public OrderLineItemProduct setMpn(java.lang.String mpn) {
    this.mpn = mpn;
    return this;
  }

  /**
   * An identifier of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getOfferId() {
    return offerId;
  }

  /**
   * An identifier of the item.
   * @param offerId offerId or {@code null} for none
   */
  public OrderLineItemProduct setOfferId(java.lang.String offerId) {
    this.offerId = offerId;
    return this;
  }

  /**
   * Price of the item.
   * @return value or {@code null} for none
   */
  public Price getPrice() {
    return price;
  }

  /**
   * Price of the item.
   * @param price price or {@code null} for none
   */
  public OrderLineItemProduct setPrice(Price price) {
    this.price = price;
    return this;
  }

  /**
   * URL to the cached image shown to the user when order was placed.
   * @return value or {@code null} for none
   */
  public java.lang.String getShownImage() {
    return shownImage;
  }

  /**
   * URL to the cached image shown to the user when order was placed.
   * @param shownImage shownImage or {@code null} for none
   */
  public OrderLineItemProduct setShownImage(java.lang.String shownImage) {
    this.shownImage = shownImage;
    return this;
  }

  /**
   * The CLDR territory code of the target country of the product.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetCountry() {
    return targetCountry;
  }

  /**
   * The CLDR territory code of the target country of the product.
   * @param targetCountry targetCountry or {@code null} for none
   */
  public OrderLineItemProduct setTargetCountry(java.lang.String targetCountry) {
    this.targetCountry = targetCountry;
    return this;
  }

  /**
   * The title of the product.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of the product.
   * @param title title or {@code null} for none
   */
  public OrderLineItemProduct setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Variant attributes for the item. These are dimensions of the product, such as color, gender,
   * material, pattern, and size. You can find a comprehensive list of variant attributes here.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderLineItemProductVariantAttribute> getVariantAttributes() {
    return variantAttributes;
  }

  /**
   * Variant attributes for the item. These are dimensions of the product, such as color, gender,
   * material, pattern, and size. You can find a comprehensive list of variant attributes here.
   * @param variantAttributes variantAttributes or {@code null} for none
   */
  public OrderLineItemProduct setVariantAttributes(java.util.List<OrderLineItemProductVariantAttribute> variantAttributes) {
    this.variantAttributes = variantAttributes;
    return this;
  }

  @Override
  public OrderLineItemProduct set(String fieldName, Object value) {
    return (OrderLineItemProduct) super.set(fieldName, value);
  }

  @Override
  public OrderLineItemProduct clone() {
    return (OrderLineItemProduct) super.clone();
  }

}
