/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderLegacyPromotionBenefit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderLegacyPromotionBenefit extends com.google.api.client.json.GenericJson {

  /**
   * The discount in the order price when the promotion is applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price discount;

  /**
   * The OfferId(s) that were purchased in this order and map to this specific benefit of the
   * promotion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> offerIds;

  /**
   * Further describes the benefit of the promotion. Note that we will expand on this enumeration as
   * we support new promotion sub-types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subType;

  /**
   * The impact on tax when the promotion is applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price taxImpact;

  /**
   * Describes whether the promotion applies to products (e.g. 20% off) or to shipping (e.g. Free
   * Shipping).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The discount in the order price when the promotion is applied.
   * @return value or {@code null} for none
   */
  public Price getDiscount() {
    return discount;
  }

  /**
   * The discount in the order price when the promotion is applied.
   * @param discount discount or {@code null} for none
   */
  public OrderLegacyPromotionBenefit setDiscount(Price discount) {
    this.discount = discount;
    return this;
  }

  /**
   * The OfferId(s) that were purchased in this order and map to this specific benefit of the
   * promotion.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOfferIds() {
    return offerIds;
  }

  /**
   * The OfferId(s) that were purchased in this order and map to this specific benefit of the
   * promotion.
   * @param offerIds offerIds or {@code null} for none
   */
  public OrderLegacyPromotionBenefit setOfferIds(java.util.List<java.lang.String> offerIds) {
    this.offerIds = offerIds;
    return this;
  }

  /**
   * Further describes the benefit of the promotion. Note that we will expand on this enumeration as
   * we support new promotion sub-types.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubType() {
    return subType;
  }

  /**
   * Further describes the benefit of the promotion. Note that we will expand on this enumeration as
   * we support new promotion sub-types.
   * @param subType subType or {@code null} for none
   */
  public OrderLegacyPromotionBenefit setSubType(java.lang.String subType) {
    this.subType = subType;
    return this;
  }

  /**
   * The impact on tax when the promotion is applied.
   * @return value or {@code null} for none
   */
  public Price getTaxImpact() {
    return taxImpact;
  }

  /**
   * The impact on tax when the promotion is applied.
   * @param taxImpact taxImpact or {@code null} for none
   */
  public OrderLegacyPromotionBenefit setTaxImpact(Price taxImpact) {
    this.taxImpact = taxImpact;
    return this;
  }

  /**
   * Describes whether the promotion applies to products (e.g. 20% off) or to shipping (e.g. Free
   * Shipping).
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Describes whether the promotion applies to products (e.g. 20% off) or to shipping (e.g. Free
   * Shipping).
   * @param type type or {@code null} for none
   */
  public OrderLegacyPromotionBenefit setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public OrderLegacyPromotionBenefit set(String fieldName, Object value) {
    return (OrderLegacyPromotionBenefit) super.set(fieldName, value);
  }

  @Override
  public OrderLegacyPromotionBenefit clone() {
    return (OrderLegacyPromotionBenefit) super.clone();
  }

}
