/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderLegacyPromotion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderLegacyPromotion extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderLegacyPromotionBenefit> benefits;

  /**
   * The date and time frame when the promotion is active and ready for validation review. Note that
   * the promotion live time may be delayed for a few hours due to the validation review. Start date
   * and end date are separated by a forward slash (/). The start date is specified by the format
   * (YYYY-MM-DD), followed by the letter ?T?, the time of the day when the sale starts (in
   * Greenwich Mean Time, GMT), followed by an expression of the time zone for the sale. The end
   * date is in the same format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String effectiveDates;

  /**
   * Optional. The text code that corresponds to the promotion when applied on the retailer?s
   * website.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String genericRedemptionCode;

  /**
   * The unique ID of the promotion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The full title of the promotion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String longTitle;

  /**
   * Whether the promotion is applicable to all products or only specific products.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productApplicability;

  /**
   * Indicates that the promotion is valid online.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String redemptionChannel;

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<OrderLegacyPromotionBenefit> getBenefits() {
    return benefits;
  }

  /**
   * @param benefits benefits or {@code null} for none
   */
  public OrderLegacyPromotion setBenefits(java.util.List<OrderLegacyPromotionBenefit> benefits) {
    this.benefits = benefits;
    return this;
  }

  /**
   * The date and time frame when the promotion is active and ready for validation review. Note that
   * the promotion live time may be delayed for a few hours due to the validation review. Start date
   * and end date are separated by a forward slash (/). The start date is specified by the format
   * (YYYY-MM-DD), followed by the letter ?T?, the time of the day when the sale starts (in
   * Greenwich Mean Time, GMT), followed by an expression of the time zone for the sale. The end
   * date is in the same format.
   * @return value or {@code null} for none
   */
  public java.lang.String getEffectiveDates() {
    return effectiveDates;
  }

  /**
   * The date and time frame when the promotion is active and ready for validation review. Note that
   * the promotion live time may be delayed for a few hours due to the validation review. Start date
   * and end date are separated by a forward slash (/). The start date is specified by the format
   * (YYYY-MM-DD), followed by the letter ?T?, the time of the day when the sale starts (in
   * Greenwich Mean Time, GMT), followed by an expression of the time zone for the sale. The end
   * date is in the same format.
   * @param effectiveDates effectiveDates or {@code null} for none
   */
  public OrderLegacyPromotion setEffectiveDates(java.lang.String effectiveDates) {
    this.effectiveDates = effectiveDates;
    return this;
  }

  /**
   * Optional. The text code that corresponds to the promotion when applied on the retailer?s
   * website.
   * @return value or {@code null} for none
   */
  public java.lang.String getGenericRedemptionCode() {
    return genericRedemptionCode;
  }

  /**
   * Optional. The text code that corresponds to the promotion when applied on the retailer?s
   * website.
   * @param genericRedemptionCode genericRedemptionCode or {@code null} for none
   */
  public OrderLegacyPromotion setGenericRedemptionCode(java.lang.String genericRedemptionCode) {
    this.genericRedemptionCode = genericRedemptionCode;
    return this;
  }

  /**
   * The unique ID of the promotion.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The unique ID of the promotion.
   * @param id id or {@code null} for none
   */
  public OrderLegacyPromotion setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The full title of the promotion.
   * @return value or {@code null} for none
   */
  public java.lang.String getLongTitle() {
    return longTitle;
  }

  /**
   * The full title of the promotion.
   * @param longTitle longTitle or {@code null} for none
   */
  public OrderLegacyPromotion setLongTitle(java.lang.String longTitle) {
    this.longTitle = longTitle;
    return this;
  }

  /**
   * Whether the promotion is applicable to all products or only specific products.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductApplicability() {
    return productApplicability;
  }

  /**
   * Whether the promotion is applicable to all products or only specific products.
   * @param productApplicability productApplicability or {@code null} for none
   */
  public OrderLegacyPromotion setProductApplicability(java.lang.String productApplicability) {
    this.productApplicability = productApplicability;
    return this;
  }

  /**
   * Indicates that the promotion is valid online.
   * @return value or {@code null} for none
   */
  public java.lang.String getRedemptionChannel() {
    return redemptionChannel;
  }

  /**
   * Indicates that the promotion is valid online.
   * @param redemptionChannel redemptionChannel or {@code null} for none
   */
  public OrderLegacyPromotion setRedemptionChannel(java.lang.String redemptionChannel) {
    this.redemptionChannel = redemptionChannel;
    return this;
  }

  @Override
  public OrderLegacyPromotion set(String fieldName, Object value) {
    return (OrderLegacyPromotion) super.set(fieldName, value);
  }

  @Override
  public OrderLegacyPromotion clone() {
    return (OrderLegacyPromotion) super.clone();
  }

}
