/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderCancellation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderCancellation extends com.google.api.client.json.GenericJson {

  /**
   * The actor that created the cancellation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String actor;

  /**
   * Date on which the cancellation has been created, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationDate;

  /**
   * The quantity that was canceled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long quantity;

  /**
   * The reason for the cancellation. Orders that are cancelled with a noInventory reason will lead
   * to the removal of the product from Shopping Actions until you make an update to that product.
   * This will not affect your Shopping ads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The explanation of the reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonText;

  /**
   * The actor that created the cancellation.
   * @return value or {@code null} for none
   */
  public java.lang.String getActor() {
    return actor;
  }

  /**
   * The actor that created the cancellation.
   * @param actor actor or {@code null} for none
   */
  public OrderCancellation setActor(java.lang.String actor) {
    this.actor = actor;
    return this;
  }

  /**
   * Date on which the cancellation has been created, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationDate() {
    return creationDate;
  }

  /**
   * Date on which the cancellation has been created, in ISO 8601 format.
   * @param creationDate creationDate or {@code null} for none
   */
  public OrderCancellation setCreationDate(java.lang.String creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The quantity that was canceled.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuantity() {
    return quantity;
  }

  /**
   * The quantity that was canceled.
   * @param quantity quantity or {@code null} for none
   */
  public OrderCancellation setQuantity(java.lang.Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * The reason for the cancellation. Orders that are cancelled with a noInventory reason will lead
   * to the removal of the product from Shopping Actions until you make an update to that product.
   * This will not affect your Shopping ads.
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The reason for the cancellation. Orders that are cancelled with a noInventory reason will lead
   * to the removal of the product from Shopping Actions until you make an update to that product.
   * This will not affect your Shopping ads.
   * @param reason reason or {@code null} for none
   */
  public OrderCancellation setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The explanation of the reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonText() {
    return reasonText;
  }

  /**
   * The explanation of the reason.
   * @param reasonText reasonText or {@code null} for none
   */
  public OrderCancellation setReasonText(java.lang.String reasonText) {
    this.reasonText = reasonText;
    return this;
  }

  @Override
  public OrderCancellation set(String fieldName, Object value) {
    return (OrderCancellation) super.set(fieldName, value);
  }

  @Override
  public OrderCancellation clone() {
    return (OrderCancellation) super.clone();
  }

}
