/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for Installment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Installment extends com.google.api.client.json.GenericJson {

  /**
   * The amount the buyer has to pay per month.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price amount;

  /**
   * The number of installments the buyer has to pay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long months;

  /**
   * The amount the buyer has to pay per month.
   * @return value or {@code null} for none
   */
  public Price getAmount() {
    return amount;
  }

  /**
   * The amount the buyer has to pay per month.
   * @param amount amount or {@code null} for none
   */
  public Installment setAmount(Price amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The number of installments the buyer has to pay.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMonths() {
    return months;
  }

  /**
   * The number of installments the buyer has to pay.
   * @param months months or {@code null} for none
   */
  public Installment setMonths(java.lang.Long months) {
    this.months = months;
    return this;
  }

  @Override
  public Installment set(String fieldName, Object value) {
    return (Installment) super.set(fieldName, value);
  }

  @Override
  public Installment clone() {
    return (Installment) super.clone();
  }

}
