/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A batch entry encoding a single non-batch datafeeds response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DatafeedsCustomBatchResponseEntry extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the request entry this entry responds to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * The requested data feed. Defined if and only if the request was successful.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Datafeed datafeed;

  /**
   * A list of errors defined if and only if the request failed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Errors errors;

  /**
   * The ID of the request entry this entry responds to.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * The ID of the request entry this entry responds to.
   * @param batchId batchId or {@code null} for none
   */
  public DatafeedsCustomBatchResponseEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * The requested data feed. Defined if and only if the request was successful.
   * @return value or {@code null} for none
   */
  public Datafeed getDatafeed() {
    return datafeed;
  }

  /**
   * The requested data feed. Defined if and only if the request was successful.
   * @param datafeed datafeed or {@code null} for none
   */
  public DatafeedsCustomBatchResponseEntry setDatafeed(Datafeed datafeed) {
    this.datafeed = datafeed;
    return this;
  }

  /**
   * A list of errors defined if and only if the request failed.
   * @return value or {@code null} for none
   */
  public Errors getErrors() {
    return errors;
  }

  /**
   * A list of errors defined if and only if the request failed.
   * @param errors errors or {@code null} for none
   */
  public DatafeedsCustomBatchResponseEntry setErrors(Errors errors) {
    this.errors = errors;
    return this;
  }

  @Override
  public DatafeedsCustomBatchResponseEntry set(String fieldName, Object value) {
    return (DatafeedsCustomBatchResponseEntry) super.set(fieldName, value);
  }

  @Override
  public DatafeedsCustomBatchResponseEntry clone() {
    return (DatafeedsCustomBatchResponseEntry) super.clone();
  }

}
