/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Datafeed configuration data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Datafeed extends com.google.api.client.json.GenericJson {

  /**
   * The two-letter ISO 639-1 language in which the attributes are defined in the data feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attributeLanguage;

  /**
   * [DEPRECATED] Please use targets[].language instead. The two-letter ISO 639-1 language of the
   * items in the feed. Must be a valid language for targetCountry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentLanguage;

  /**
   * The type of data feed. For product inventory feeds, only feeds for local stores, not online
   * stores, are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentType;

  /**
   * Fetch schedule for the feed file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatafeedFetchSchedule fetchSchedule;

  /**
   * The filename of the feed. All feeds must have a unique file name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileName;

  /**
   * Format of the feed file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatafeedFormat format;

  /**
   * The ID of the data feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * [DEPRECATED] Please use targets[].includedDestinations instead. The list of intended
   * destinations (corresponds to checked check boxes in Merchant Center).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> intendedDestinations;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "content#datafeed".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A descriptive name of the data feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [DEPRECATED] Please use targets[].country instead. The country where the items in the feed will
   * be included in the search index, represented as a CLDR territory code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetCountry;

  /**
   * The targets this feed should apply to (country, language, destinations).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DatafeedTarget> targets;

  /**
   * The two-letter ISO 639-1 language in which the attributes are defined in the data feed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttributeLanguage() {
    return attributeLanguage;
  }

  /**
   * The two-letter ISO 639-1 language in which the attributes are defined in the data feed.
   * @param attributeLanguage attributeLanguage or {@code null} for none
   */
  public Datafeed setAttributeLanguage(java.lang.String attributeLanguage) {
    this.attributeLanguage = attributeLanguage;
    return this;
  }

  /**
   * [DEPRECATED] Please use targets[].language instead. The two-letter ISO 639-1 language of the
   * items in the feed. Must be a valid language for targetCountry.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentLanguage() {
    return contentLanguage;
  }

  /**
   * [DEPRECATED] Please use targets[].language instead. The two-letter ISO 639-1 language of the
   * items in the feed. Must be a valid language for targetCountry.
   * @param contentLanguage contentLanguage or {@code null} for none
   */
  public Datafeed setContentLanguage(java.lang.String contentLanguage) {
    this.contentLanguage = contentLanguage;
    return this;
  }

  /**
   * The type of data feed. For product inventory feeds, only feeds for local stores, not online
   * stores, are supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentType() {
    return contentType;
  }

  /**
   * The type of data feed. For product inventory feeds, only feeds for local stores, not online
   * stores, are supported.
   * @param contentType contentType or {@code null} for none
   */
  public Datafeed setContentType(java.lang.String contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * Fetch schedule for the feed file.
   * @return value or {@code null} for none
   */
  public DatafeedFetchSchedule getFetchSchedule() {
    return fetchSchedule;
  }

  /**
   * Fetch schedule for the feed file.
   * @param fetchSchedule fetchSchedule or {@code null} for none
   */
  public Datafeed setFetchSchedule(DatafeedFetchSchedule fetchSchedule) {
    this.fetchSchedule = fetchSchedule;
    return this;
  }

  /**
   * The filename of the feed. All feeds must have a unique file name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileName() {
    return fileName;
  }

  /**
   * The filename of the feed. All feeds must have a unique file name.
   * @param fileName fileName or {@code null} for none
   */
  public Datafeed setFileName(java.lang.String fileName) {
    this.fileName = fileName;
    return this;
  }

  /**
   * Format of the feed file.
   * @return value or {@code null} for none
   */
  public DatafeedFormat getFormat() {
    return format;
  }

  /**
   * Format of the feed file.
   * @param format format or {@code null} for none
   */
  public Datafeed setFormat(DatafeedFormat format) {
    this.format = format;
    return this;
  }

  /**
   * The ID of the data feed.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * The ID of the data feed.
   * @param id id or {@code null} for none
   */
  public Datafeed setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * [DEPRECATED] Please use targets[].includedDestinations instead. The list of intended
   * destinations (corresponds to checked check boxes in Merchant Center).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIntendedDestinations() {
    return intendedDestinations;
  }

  /**
   * [DEPRECATED] Please use targets[].includedDestinations instead. The list of intended
   * destinations (corresponds to checked check boxes in Merchant Center).
   * @param intendedDestinations intendedDestinations or {@code null} for none
   */
  public Datafeed setIntendedDestinations(java.util.List<java.lang.String> intendedDestinations) {
    this.intendedDestinations = intendedDestinations;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "content#datafeed".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "content#datafeed".
   * @param kind kind or {@code null} for none
   */
  public Datafeed setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A descriptive name of the data feed.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A descriptive name of the data feed.
   * @param name name or {@code null} for none
   */
  public Datafeed setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [DEPRECATED] Please use targets[].country instead. The country where the items in the feed will
   * be included in the search index, represented as a CLDR territory code.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetCountry() {
    return targetCountry;
  }

  /**
   * [DEPRECATED] Please use targets[].country instead. The country where the items in the feed will
   * be included in the search index, represented as a CLDR territory code.
   * @param targetCountry targetCountry or {@code null} for none
   */
  public Datafeed setTargetCountry(java.lang.String targetCountry) {
    this.targetCountry = targetCountry;
    return this;
  }

  /**
   * The targets this feed should apply to (country, language, destinations).
   * @return value or {@code null} for none
   */
  public java.util.List<DatafeedTarget> getTargets() {
    return targets;
  }

  /**
   * The targets this feed should apply to (country, language, destinations).
   * @param targets targets or {@code null} for none
   */
  public Datafeed setTargets(java.util.List<DatafeedTarget> targets) {
    this.targets = targets;
    return this;
  }

  @Override
  public Datafeed set(String fieldName, Object value) {
    return (Datafeed) super.set(fieldName, value);
  }

  @Override
  public Datafeed clone() {
    return (Datafeed) super.clone();
  }

}
