/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for CustomGroup.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomGroup extends com.google.api.client.json.GenericJson {

  /**
   * The sub-attributes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomAttribute> attributes;

  static {
    // hack to force ProGuard to consider CustomAttribute used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CustomAttribute.class);
  }

  /**
   * The name of the group. Underscores will be replaced by spaces upon insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The sub-attributes.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomAttribute> getAttributes() {
    return attributes;
  }

  /**
   * The sub-attributes.
   * @param attributes attributes or {@code null} for none
   */
  public CustomGroup setAttributes(java.util.List<CustomAttribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  /**
   * The name of the group. Underscores will be replaced by spaces upon insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the group. Underscores will be replaced by spaces upon insertion.
   * @param name name or {@code null} for none
   */
  public CustomGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public CustomGroup set(String fieldName, Object value) {
    return (CustomGroup) super.set(fieldName, value);
  }

  @Override
  public CustomGroup clone() {
    return (CustomGroup) super.clone();
  }

}
