/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-05 at 18:23:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A batch entry encoding a single non-batch accounts request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountsCustomBatchRequestEntry extends com.google.api.client.json.GenericJson {

  /**
   * The account to create or update. Only defined if the method is insert or update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Account account;

  /**
   * The ID of the targeted account. Only defined if the method is not insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger accountId;

  /**
   * An entry ID, unique within the batch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * Whether the account should be deleted if the account has offers. Only applicable if the method
   * is delete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean force;

  /**
   * Details about the link request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountsCustomBatchRequestEntryLinkRequest linkRequest;

  /**
   * The ID of the managing account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * The method of the batch entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * Only applicable if the method is claimwebsite. Indicates whether or not to take the claim from
   * another account in case there is a conflict.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean overwrite;

  /**
   * The account to create or update. Only defined if the method is insert or update.
   * @return value or {@code null} for none
   */
  public Account getAccount() {
    return account;
  }

  /**
   * The account to create or update. Only defined if the method is insert or update.
   * @param account account or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setAccount(Account account) {
    this.account = account;
    return this;
  }

  /**
   * The ID of the targeted account. Only defined if the method is not insert.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getAccountId() {
    return accountId;
  }

  /**
   * The ID of the targeted account. Only defined if the method is not insert.
   * @param accountId accountId or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setAccountId(java.math.BigInteger accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * An entry ID, unique within the batch request.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * An entry ID, unique within the batch request.
   * @param batchId batchId or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * Whether the account should be deleted if the account has offers. Only applicable if the method
   * is delete.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getForce() {
    return force;
  }

  /**
   * Whether the account should be deleted if the account has offers. Only applicable if the method
   * is delete.
   * @param force force or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setForce(java.lang.Boolean force) {
    this.force = force;
    return this;
  }

  /**
   * Details about the link request.
   * @return value or {@code null} for none
   */
  public AccountsCustomBatchRequestEntryLinkRequest getLinkRequest() {
    return linkRequest;
  }

  /**
   * Details about the link request.
   * @param linkRequest linkRequest or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setLinkRequest(AccountsCustomBatchRequestEntryLinkRequest linkRequest) {
    this.linkRequest = linkRequest;
    return this;
  }

  /**
   * The ID of the managing account.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * The ID of the managing account.
   * @param merchantId merchantId or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The method of the batch entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method of the batch entry.
   * @param method method or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * Only applicable if the method is claimwebsite. Indicates whether or not to take the claim from
   * another account in case there is a conflict.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOverwrite() {
    return overwrite;
  }

  /**
   * Only applicable if the method is claimwebsite. Indicates whether or not to take the claim from
   * another account in case there is a conflict.
   * @param overwrite overwrite or {@code null} for none
   */
  public AccountsCustomBatchRequestEntry setOverwrite(java.lang.Boolean overwrite) {
    this.overwrite = overwrite;
    return this;
  }

  @Override
  public AccountsCustomBatchRequestEntry set(String fieldName, Object value) {
    return (AccountsCustomBatchRequestEntry) super.set(fieldName, value);
  }

  @Override
  public AccountsCustomBatchRequestEntry clone() {
    return (AccountsCustomBatchRequestEntry) super.clone();
  }

}
