/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-02-18 22:11:37 UTC)
 * on 2016-03-02 at 19:27:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.clouduseraccounts.model;

/**
 * A detailed view of a Linux user account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud User Accounts API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LinuxUserView extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The GECOS (user information) entry for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gecos;

  /**
   * [Output Only] User's default group ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long gid;

  /**
   * [Output Only] The path to the home directory for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String homeDirectory;

  /**
   * [Output Only] The path to the login shell for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shell;

  /**
   * [Output Only] User ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long uid;

  /**
   * [Output Only] The username of the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String username;

  /**
   * [Output Only] The GECOS (user information) entry for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getGecos() {
    return gecos;
  }

  /**
   * [Output Only] The GECOS (user information) entry for this account.
   * @param gecos gecos or {@code null} for none
   */
  public LinuxUserView setGecos(java.lang.String gecos) {
    this.gecos = gecos;
    return this;
  }

  /**
   * [Output Only] User's default group ID.
   * @return value or {@code null} for none
   */
  public java.lang.Long getGid() {
    return gid;
  }

  /**
   * [Output Only] User's default group ID.
   * @param gid gid or {@code null} for none
   */
  public LinuxUserView setGid(java.lang.Long gid) {
    this.gid = gid;
    return this;
  }

  /**
   * [Output Only] The path to the home directory for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getHomeDirectory() {
    return homeDirectory;
  }

  /**
   * [Output Only] The path to the home directory for this account.
   * @param homeDirectory homeDirectory or {@code null} for none
   */
  public LinuxUserView setHomeDirectory(java.lang.String homeDirectory) {
    this.homeDirectory = homeDirectory;
    return this;
  }

  /**
   * [Output Only] The path to the login shell for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getShell() {
    return shell;
  }

  /**
   * [Output Only] The path to the login shell for this account.
   * @param shell shell or {@code null} for none
   */
  public LinuxUserView setShell(java.lang.String shell) {
    this.shell = shell;
    return this;
  }

  /**
   * [Output Only] User ID.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUid() {
    return uid;
  }

  /**
   * [Output Only] User ID.
   * @param uid uid or {@code null} for none
   */
  public LinuxUserView setUid(java.lang.Long uid) {
    this.uid = uid;
    return this;
  }

  /**
   * [Output Only] The username of the account.
   * @return value or {@code null} for none
   */
  public java.lang.String getUsername() {
    return username;
  }

  /**
   * [Output Only] The username of the account.
   * @param username username or {@code null} for none
   */
  public LinuxUserView setUsername(java.lang.String username) {
    this.username = username;
    return this;
  }

  @Override
  public LinuxUserView set(String fieldName, Object value) {
    return (LinuxUserView) super.set(fieldName, value);
  }

  @Override
  public LinuxUserView clone() {
    return (LinuxUserView) super.clone();
  }

}
